/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.Msg;
import com.deltawalker.script.Filter;
import com.deltawalker.script.Resource;
import com.deltawalker.structure.FolderFilter;
import com.deltopia.io.FileInfo;
import com.deltopia.io.IFile;
import com.deltopia.util.OS;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AttributeFilter
extends FolderFilter
implements com.deltawalker.script.AttributeFilter {
    private final Attribute attrib;
    private volatile int hashCode;

    public AttributeFilter(FolderFilter.Action action, Attribute attribute, FolderFilter.Target target, boolean bl, String string) {
        super(action, target, bl, string);
        if (attribute == null) {
            throw new NullPointerException("attrib");
        }
        this.attrib = attribute;
    }

    public AttributeFilter(AttributeFilter attributeFilter, boolean bl) {
        super(attributeFilter, bl);
        this.attrib = attributeFilter.attrib;
    }

    public Attribute attribute() {
        return this.attrib;
    }

    @Override
    public AttributeFilter clone(boolean bl) {
        return new AttributeFilter(this, bl);
    }

    @Override
    public boolean equals(Filter filter, boolean bl) {
        if (!(filter instanceof AttributeFilter)) {
            return false;
        }
        if (this == filter) {
            return true;
        }
        AttributeFilter attributeFilter = (AttributeFilter)filter;
        return this.attrib == attributeFilter.attrib && super.equals(filter, bl);
    }

    @Override
    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    @Override
    public Resource.Attribute getAttribute() {
        return Attribute.toScript(this.attrib);
    }

    @Override
    public boolean getExclude() {
        return this.action().toBool();
    }

    @Override
    public String getExpression() {
        return this.attrib.displayName();
    }

    @Override
    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 31 * n + this.attrib.hashCode();
            this.hashCode = n = 31 * n + super.hashCode();
        }
        return n;
    }

    @Override
    public boolean isRegexType() {
        return false;
    }

    @Override
    public boolean matches(IFile iFile) {
        if (!super.matches(iFile)) {
            return false;
        }
        int n = iFile.getAttributes();
        switch (this.attrib) {
            case HIDDEN: {
                return FileInfo.isSet((int)n, (int)32);
            }
            case WRITABLE: {
                boolean bl = FileInfo.hasPermission((int)n, (int)131072);
                return OS.WIN ? !bl : bl;
            }
            case EXECUTABLE: {
                return FileInfo.hasPermission((int)n, (int)262144);
            }
            case SYM_LINK: {
                return FileInfo.isSet((int)n, (int)64);
            }
            case ARCHIVE: {
                return FileInfo.isSet((int)n, (int)256);
            }
            case SYSTEM: {
                return FileInfo.isSet((int)n, (int)128);
            }
            case READABLE: {
                return FileInfo.hasPermission((int)n, (int)65536);
            }
        }
        assert (false);
        return false;
    }

    @Override
    public void toJson(JsonWriter jsonWriter) throws IOException {
        super.toJson(jsonWriter);
        jsonWriter.name("at").value(this.attrib.toJson());
    }

    @Override
    public FolderFilter.Type type() {
        return FolderFilter.Type.ATTRIBUTE;
    }

    public static final class Attribute
    extends Enum<Attribute> {
        public static final /* enum */ Attribute ARCHIVE;
        public static final /* enum */ Attribute EXECUTABLE;
        public static final /* enum */ Attribute HIDDEN;
        public static final /* enum */ Attribute READABLE;
        public static final /* enum */ Attribute SYM_LINK;
        public static final /* enum */ Attribute SYSTEM;
        public static final /* enum */ Attribute WRITABLE;
        private static final Set<Attribute> ATTRIBS_UNIX;
        private static final Set<Attribute> ATTRIBS_WIN;
        private static final Map<Integer, Attribute> int2enum;
        private static final Map<String, Attribute> str2enum;
        private final String displayName;
        private final int intVal;
        private final String jsonText;
        private static final /* synthetic */ Attribute[] ENUM$VALUES;

        static {
            Object object;
            ARCHIVE = new Attribute(Msg.AttributeFilter_archive, 5, "a");
            EXECUTABLE = new Attribute(Msg.AttributeFilter_executable, 2, "e");
            HIDDEN = new Attribute(Msg.AttributeFilter_hidden, 0, "h");
            READABLE = new Attribute(Msg.AttributeFilter_readable, 4, "ra");
            SYM_LINK = new Attribute(Msg.AttributeFilter_symlink, 3, "sl");
            SYSTEM = new Attribute(Msg.AttributeFilter_system, 6, "s");
            WRITABLE = new Attribute(OS.WIN ? Msg.AttributeFilter_readonly : Msg.AttributeFilter_writable, 1, "r");
            ENUM$VALUES = new Attribute[]{ARCHIVE, EXECUTABLE, HIDDEN, READABLE, SYM_LINK, SYSTEM, WRITABLE};
            int2enum = new HashMap<Integer, Attribute>(4);
            str2enum = new HashMap<String, Attribute>(4);
            Attribute[] attributeArray = Attribute.values();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = attributeArray[n2];
                str2enum.put(((Attribute)((Object)object)).displayName, (Attribute)((Object)object));
                str2enum.put(((Attribute)((Object)object)).jsonText, (Attribute)((Object)object));
                int2enum.put(((Attribute)((Object)object)).intVal, (Attribute)((Object)object));
                ++n2;
            }
            object = new LinkedHashSet(2);
            object.add(HIDDEN);
            object.add(WRITABLE);
            object.add(EXECUTABLE);
            object.add(SYM_LINK);
            object.add(READABLE);
            ATTRIBS_UNIX = Collections.unmodifiableSet(object);
            object = new LinkedHashSet(object);
            object.add(ARCHIVE);
            object.add(SYSTEM);
            ATTRIBS_WIN = Collections.unmodifiableSet(object);
        }

        public static Set<Attribute> attributes() {
            return OS.WIN ? ATTRIBS_WIN : ATTRIBS_UNIX;
        }

        public static Attribute fromInt(int n) {
            return int2enum.get(n);
        }

        public static Attribute fromJson(String string) {
            assert (str2enum.containsKey(string));
            return str2enum.get(string);
        }

        public static Attribute fromScript(Resource.Attribute attribute) throws NullPointerException {
            if (attribute == null) {
                throw new NullPointerException("'attrib' cannot be null.");
            }
            switch (attribute) {
                case ARCHIVE: {
                    return ARCHIVE;
                }
                case EXECUTABLE: {
                    return EXECUTABLE;
                }
                case HIDDEN: {
                    return HIDDEN;
                }
                case READABLE: {
                    return READABLE;
                }
                case SYMBOLIC_LINK: {
                    return SYM_LINK;
                }
                case SYSTEM: {
                    return SYSTEM;
                }
                case WRITABLE: {
                    return WRITABLE;
                }
                case FOLDER: {
                    throw new IllegalArgumentException("'Resource.Attribute.FOLDER' cannot be used in an attribute filter. Use 'FolderFilter.Target.FOLDERS' instead.");
                }
            }
            throw new IllegalArgumentException("Unknow 'attrib' type");
        }

        public static Attribute fromString(String string) {
            if (string == null) {
                throw new NullPointerException("'key' cannot be null.");
            }
            if (!str2enum.containsKey(string)) {
                throw new IllegalArgumentException("key");
            }
            return str2enum.get(string);
        }

        public static Resource.Attribute toScript(Attribute attribute) {
            if (attribute == null) {
                throw new NullPointerException("'attrib' cannot be null.");
            }
            switch (attribute) {
                case ARCHIVE: {
                    return Resource.Attribute.ARCHIVE;
                }
                case EXECUTABLE: {
                    return Resource.Attribute.EXECUTABLE;
                }
                case HIDDEN: {
                    return Resource.Attribute.HIDDEN;
                }
                case READABLE: {
                    return Resource.Attribute.READABLE;
                }
                case SYM_LINK: {
                    return Resource.Attribute.SYMBOLIC_LINK;
                }
                case SYSTEM: {
                    return Resource.Attribute.SYSTEM;
                }
                case WRITABLE: {
                    return Resource.Attribute.WRITABLE;
                }
            }
            throw new IllegalArgumentException("Uknown 'attrib'");
        }

        private Attribute(String string2, int n2, String string3) {
            this.displayName = string2;
            this.intVal = n2;
            this.jsonText = string3;
        }

        public String displayName() {
            return this.displayName;
        }

        public int toInt() {
            return this.intVal;
        }

        public String toJson() {
            return this.jsonText;
        }

        public static Attribute[] values() {
            Attribute[] attributeArray = ENUM$VALUES;
            int n = attributeArray.length;
            Attribute[] attributeArray2 = new Attribute[n];
            System.arraycopy(ENUM$VALUES, 0, attributeArray2, 0, n);
            return attributeArray2;
        }

        public static Attribute valueOf(String string) {
            return Enum.valueOf(Attribute.class, string);
        }
    }
}

