/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure;

import com.deltawalker.script.Filter;
import com.deltawalker.script.FolderFilter;
import com.deltawalker.structure.FolderFilter;
import com.deltopia.StringUtil;
import com.deltopia.io.IFile;
import com.deltopia.regex.DualPattern;
import com.deltopia.regex.RegexUtil;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;

public class AlignFilter
extends FolderFilter
implements com.deltawalker.script.AlignFilter {
    private static final String ALL_REG_EX = ".*";
    private final boolean caseSensitive;
    private DualPattern dualPattern;
    private String exp1 = "";
    private String exp2 = "";
    private volatile int hashCode;
    final Pattern ptnFolders;
    private final boolean regexType;
    final String strFolders;

    public AlignFilter(AlignFilter alignFilter, boolean bl, boolean bl2) {
        super(alignFilter, bl);
        this.regexType = alignFilter.regexType;
        this.caseSensitive = alignFilter.caseSensitive;
        this.exp1 = alignFilter.exp1;
        this.exp2 = alignFilter.exp2;
        this.dualPattern = alignFilter.dualPattern;
        this.strFolders = alignFilter.strFolders;
        this.ptnFolders = alignFilter.ptnFolders;
    }

    public AlignFilter(String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, String string4) throws PatternSyntaxException {
        super(FolderFilter.Action.ALIGN, FolderFilter.Target.BOTH, bl3, string4);
        if (string == null) {
            throw new NullPointerException("expression1");
        }
        if (string2 == null) {
            throw new NullPointerException("expression2");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'expression1' cannot be empty");
        }
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("'expression2' cannot be empty");
        }
        this.regexType = bl;
        this.caseSensitive = bl2;
        this.strFolders = StringUtil.makeSafe((String)string3);
        this.ptnFolders = this.strFolders.isEmpty() ? null : Pattern.compile(RegexUtil.shell2regex((String)this.strFolders, (int)0), this.patternFlags());
        this.setExpressions(string, string2);
    }

    public boolean appliesToFolder(String string) {
        if (this.ptnFolders == null) {
            return true;
        }
        return this.ptnFolders.matcher(string).matches();
    }

    @Override
    public AlignFilter clone(boolean bl) {
        return new AlignFilter(this, bl, this.isEnabled() ^ bl);
    }

    @Override
    public boolean equals(Filter filter, boolean bl) {
        if (this == filter) {
            return true;
        }
        if (!(filter instanceof AlignFilter)) {
            return false;
        }
        AlignFilter alignFilter = (AlignFilter)filter;
        return this.regexType == alignFilter.regexType && this.caseSensitive == alignFilter.caseSensitive && this.exp1.equals(alignFilter.exp1) && this.exp2.equals(alignFilter.exp2) && this.strFolders.equals(alignFilter.strFolders) && super.equals(filter, bl);
    }

    @Override
    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    @Override
    public String getApplyToFolders() {
        return this.strFolders;
    }

    @Override
    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public String getDisplayExpression() {
        return String.valueOf(this.exp1) + '=' + this.exp2;
    }

    @Override
    public String getExpression() {
        return this.exp1;
    }

    @Override
    public String getSecondaryExpression() {
        return this.exp2;
    }

    @Override
    public FolderFilter.Target getTarget() {
        return FolderFilter.Target.FILES_AND_FOLDERS;
    }

    @Override
    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 17;
            n = 31 * n + (this.caseSensitive ? 1 : 0);
            n = 31 * n + (this.regexType ? 1 : 0);
            n = 31 * n + this.exp1.hashCode();
            n = 31 * n + this.exp2.hashCode();
            n = 31 * n + this.strFolders.hashCode();
            this.hashCode = n = 31 * n + super.hashCode();
        }
        return n;
    }

    @Override
    public boolean isRegexType() {
        return this.regexType;
    }

    @Override
    public boolean matches(IFile iFile) {
        throw new UnsupportedOperationException("matches(IFile file)");
    }

    @Override
    public boolean matches(String string, String string2) {
        return this.dualPattern.matches(string, string2);
    }

    private int patternFlags() {
        return this.caseSensitive ? 0 : 66;
    }

    @Override
    public Element report(Element element) {
        Element element2 = super.report(element);
        this.createElement(element.getOwnerDocument(), element2, "regex", Boolean.toString(this.isRegexType()), false);
        return element2;
    }

    private void setExpressions(String string, String string2) throws PatternSyntaxException {
        assert (string != null && string2 != null);
        this.exp1 = string;
        this.exp2 = string2;
        if (!this.regexType) {
            string = RegexUtil.shell2regexSingle((String)string, (int)1);
            string2 = RegexUtil.shell2regexSingle((String)string2, (int)3);
        }
        int n = this.patternFlags();
        this.dualPattern = ALL_REG_EX.equals(string2) ? null : DualPattern.compile((String)string, (String)string2, (int)n);
    }

    @Override
    public void toJson(JsonWriter jsonWriter) throws IOException {
        super.toJson(jsonWriter);
        jsonWriter.name("rex").value(this.isRegexType());
        jsonWriter.name("cs").value(this.getCaseSensitive());
        jsonWriter.name("ex").value(this.exp1);
        jsonWriter.name("sex").value(this.exp2);
        if (!this.strFolders.isEmpty()) {
            jsonWriter.name("af").value(this.strFolders);
        }
    }

    @Override
    public FolderFilter.Type type() {
        return FolderFilter.Type.ALIGN;
    }
}

