/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.sound;

import com.deltopia.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPlayer
implements Runnable {
    private static final ExecutorService exec = Executors.newCachedThreadPool();
    private static final Logger LOG = LoggerFactory.getLogger(SoundPlayer.class);
    private AudioFormat audioFormat = null;
    private AudioInputStream audioStream = null;
    private String name;
    private File path;
    private volatile boolean pause = false;
    private volatile boolean playing = false;
    private SourceDataLine sourceLine = null;
    private volatile boolean stop = false;
    private volatile float volume_dB = 0.0f;

    public SoundPlayer() {
    }

    public SoundPlayer(File file) {
        this.path = file;
    }

    public SoundPlayer(String string) {
        this.name = string;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void onPause() {
    }

    public void onPlay() {
    }

    public void onResume() {
    }

    public void onStop() {
    }

    public void pause() {
        this.pause = true;
        this.onPause();
    }

    public void play() {
        exec.execute(this);
    }

    public void playSound() throws FileNotFoundException, UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.playing = true;
        AudioInputStream audioInputStream = null;
        try {
            Object object;
            Object object2;
            if (this.name != null) {
                object2 = this.name.toLowerCase();
                if (((String)object2).endsWith(".wav") || ((String)object2).endsWith(".aiff")) {
                    object = SoundPlayer.class.getResourceAsStream(this.name);
                    audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream((InputStream)object));
                }
            } else if (this.path != null && (((String)(object2 = this.path.toString().toLowerCase())).endsWith(".wav") || ((String)object2).endsWith(".aiff"))) {
                audioInputStream = AudioSystem.getAudioInputStream(new URL("file://" + this.path));
            }
            if (audioInputStream == null) {
                throw new IllegalArgumentException("Unsupported audio format");
            }
            object2 = audioInputStream.getFormat();
            this.audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)object2).getSampleRate(), 16, ((AudioFormat)object2).getChannels(), ((AudioFormat)object2).getChannels() * 2, ((AudioFormat)object2).getSampleRate(), false);
            this.audioStream = AudioSystem.getAudioInputStream(this.audioFormat, audioInputStream);
            object = new byte[4096];
            try {
                SourceDataLine sourceDataLine = null;
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
                sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                sourceDataLine.open(this.audioFormat);
                this.sourceLine = sourceDataLine;
                this.onPlay();
                this.sourceLine.start();
                int n = 0;
                while (n != -1 && !this.stop) {
                    if (!this.pause) {
                        this.playing = true;
                        n = this.audioStream.read((byte[])object, 0, ((Object)object).length);
                        if (n == -1) continue;
                        if (this.sourceLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                            ((FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN)).setValue(this.volume_dB);
                        }
                        this.sourceLine.write((byte[])object, 0, n);
                        continue;
                    }
                    this.playing = false;
                }
                this.sourceLine.drain();
                this.sourceLine.stop();
                this.sourceLine.close();
            }
            catch (LineUnavailableException lineUnavailableException) {
                lineUnavailableException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            StreamUtil.closeSilently((Closeable)this.audioStream);
            StreamUtil.closeSilently(audioInputStream);
            throw throwable;
        }
        StreamUtil.closeSilently((Closeable)this.audioStream);
        StreamUtil.closeSilently((Closeable)audioInputStream);
        this.playing = false;
        this.onStop();
    }

    public void resume() {
        this.pause = false;
        this.onResume();
    }

    @Override
    public void run() {
        this.stop = false;
        this.pause = false;
        try {
            this.playSound();
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't play sound: ", throwable);
        }
    }

    public void setFile(String string) {
        this.name = string;
    }

    public void setVolume(Float f) {
        f = Float.valueOf(f == null ? 1.0f : f.floatValue());
        f = Float.valueOf(f.floatValue() <= 0.0f ? 1.0E-4f : f.floatValue());
        this.setVolumeInDecibels(Float.valueOf((float)(20.0 * (Math.log(f.floatValue()) / Math.log(10.0)))));
    }

    public void setVolumeInDecibels(Float f) {
        f = Float.valueOf(f == null ? 0.0f : f.floatValue());
        this.volume_dB = f.floatValue();
    }

    public void stop() {
        this.stop = true;
    }

    public static enum Sound {
        ALERT("note.wav"),
        END_COMPARE("chord.wav");

        private final String name;

        private Sound(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

