/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.sessions;

import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.internal.ContextId;
import com.deltawalker.internal.ui.HistoryTree;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltopia.io.FileType;
import java.util.HashMap;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OrganizeHistoryDialog
extends TrayDialog {
    private HashMap<Integer, Button> buttons = new HashMap();
    private HistoryTree historyTree;
    private ISelectionChangedListener onSelect = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            OrganizeHistoryDialog.this.updateButtons();
        }
    };
    private FileType type;

    public OrganizeHistoryDialog(Shell shell) {
        super(shell);
        boolean bl = PrefUtil.getGlobalPrefs().getBoolean(PrefKey.C_ORGANIZE_FILE_SESSIONS.toString());
        this.type = bl ? FileType.FILE : FileType.FOLDER;
    }

    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        if (n == Buttons.RENAME.id) {
            this.historyTree.editSelectedTreeItem();
        } else if (n == Buttons.DELETE.id) {
            this.historyTree.deleteSelectedSessions();
        } else if (n == Buttons.CLOSE.id) {
            this.close();
        } else if (n == Buttons.FILES.id || n == Buttons.FOLDERS.id) {
            boolean bl = this.getButton(Buttons.FILES.id).getSelection();
            PrefUtil.getGlobalPrefs().setValue(PrefKey.C_ORGANIZE_FILE_SESSIONS.toString(), bl);
            this.type = bl ? FileType.FILE : FileType.FOLDER;
            this.historyTree.setType(this.type);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UIUtil.setHelpContextId((Control)shell, ContextId.COMPARISON_SUMMARY_DIALOG);
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite2);
        }
        this.createButtonEx(composite2, Buttons.FILES.id, Buttons.FILES.label, false, 16);
        this.createButtonEx(composite2, Buttons.FOLDERS.id, Buttons.FOLDERS.label, false, 16);
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(768));
        ++gridLayout.numColumns;
        this.createButtonsForButtonBar(composite2);
        return composite2;
    }

    private Button createButtonEx(Composite composite, int n, String string, boolean bl, int n2) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, n2);
        button.setText(string);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)n);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OrganizeHistoryDialog.this.buttonPressed((Integer)selectionEvent.widget.getData());
            }
        });
        this.buttons.put(n, button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButtonEx(composite, Buttons.RENAME.id, Buttons.RENAME.label, false, 8);
        this.createButtonEx(composite, Buttons.DELETE.id, Buttons.DELETE.label, false, 8);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        this.createButtonEx(composite, Buttons.CLOSE.id, Buttons.CLOSE.label, true, 8);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.getShell().setText(UIMsg.OrganizeHistoryDlg_title);
        OrganizeHistoryDialog.applyDialogFont((Control)composite2);
        this.historyTree = new HistoryTree(composite2, 0, this.type, true);
        this.historyTree.addSelectionChangedListener(this.onSelect);
        this.historyTree.setLayoutData(new GridData(4, 4, true, true));
        return composite2;
    }

    protected Button getButton(int n) {
        return this.buttons.get(n);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }

    protected void helpPressed() {
        UIUtil.showHelp("comparison-history", UIUtil.HelpContext.DIALOG);
    }

    protected void setButtonLayoutData(Button button) {
        int n = (Integer)button.getData();
        GridData gridData = new GridData(256);
        int n2 = this.convertHorizontalDLUsToPixels(61);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = n == Buttons.FILES.id || n == Buttons.FOLDERS.id ? Math.min(n2, point.x) : Math.max(n2, point.x);
        button.setLayoutData((Object)gridData);
    }

    private void updateButtons() {
        if (this.getButton(Buttons.RENAME.id) == null) {
            return;
        }
        IStructuredSelection iStructuredSelection = this.historyTree.getStructuredSelection();
        boolean bl = iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IDiffDoc;
        this.getButton(Buttons.RENAME.id).setEnabled(bl);
        this.getButton(Buttons.DELETE.id).setEnabled(this.historyTree.getSelectedSessions().size() > 0);
        boolean bl2 = this.type == FileType.FILE;
        this.getButton(Buttons.FILES.id).setSelection(bl2);
        this.getButton(Buttons.FOLDERS.id).setSelection(!bl2);
    }

    public static enum Buttons {
        CLOSE(13, IDialogConstants.CLOSE_LABEL),
        DELETE(1026, UIMsg.OrganizeHistoryDlg_btnDelete),
        FILES(1027, UIMsg.OrganizeHistoryDlg_btnFiles),
        FOLDERS(1028, UIMsg.OrganizeHistoryDlg_btnFolders),
        RENAME(1029, UIMsg.OrganizeHistoryDlg_btnRename);

        private int id;
        public final String label;

        private Buttons(int n2, String string2) {
            this.id = n2;
            this.label = string2;
        }
    }
}

