/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.sessions;

import com.deltawalker.App;
import com.deltawalker.DiffDoc;
import com.deltawalker.DocFactory;
import com.deltawalker.DocType;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.interfaces.IDocFactory;
import com.deltawalker.interfaces.IScriptDoc;
import com.deltawalker.internal.ui.DocWorkbenchAdapter;
import com.deltawalker.internal.ui.WorkbenchPartAdapter;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.AdaptableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocBoss
extends Enum<DocBoss>
implements IDocBoss,
IJsonState {
    public static final /* enum */ DocBoss INSTANCE = new DocBoss();
    private static final IApp app;
    private static final Logger LOG;
    private static final int MAX_URI_HISTORY_SIZE = 10;
    private final List<IDiffDoc> docs = new ArrayList<IDiffDoc>();
    private ListenerList listeners = new ListenerList(1);
    private int maxHistorySize;
    private int maxUriHistorySize = 10;
    private static final /* synthetic */ DocBoss[] ENUM$VALUES;

    static {
        ENUM$VALUES = new DocBoss[]{INSTANCE};
        app = App.instance();
        LOG = LoggerFactory.getLogger(DocBoss.class);
    }

    private DocBoss() {
        IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (PrefKey.C_MAX_HISTORY_SIZE.toString().equals(string)) {
                    DocBoss.this.setMaxHistorySize(((IPreferenceStore)propertyChangeEvent.getSource()).getInt(string));
                }
            }
        });
        this.setMaxHistorySize(iPreferenceStore.getInt(PrefKey.C_MAX_HISTORY_SIZE.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(IDiffDoc iDiffDoc) {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            boolean bl = this.docs.add(iDiffDoc);
            if (bl) {
                this.removeSimilar(iDiffDoc);
                Collections.sort(this.docs);
                this.ensureMaxSize(iDiffDoc.fileType());
                this.fireHistoryChanged(IDocBoss.ChangeEvent.Type.ADDED, iDiffDoc);
                if (LOG.isInfoEnabled()) {
                    LOG.info(DocBoss.toStr(new StringBuilder("Added: "), iDiffDoc).append("   added: ").append(bl).append("     size: ").append(this.docs.size()).toString());
                }
            }
            return bl;
        }
    }

    @Override
    public void addListener(IDocBoss.IDeltaDocListener iDeltaDocListener) {
        this.listeners.add((Object)iDeltaDocListener);
    }

    private boolean areSimilar(IDiffDoc iDiffDoc, IDiffDoc iDiffDoc2) {
        if (iDiffDoc.isThreeWay() && !iDiffDoc2.isThreeWay() || !iDiffDoc.isThreeWay() && iDiffDoc2.isThreeWay()) {
            return false;
        }
        if (iDiffDoc.fileType() != iDiffDoc2.fileType() || !iDiffDoc.getName().equals(iDiffDoc2.getName())) {
            return false;
        }
        boolean bl = true;
        for (Role role : Relation.roles(iDiffDoc.isThreeWay())) {
            if (iDiffDoc.uriInfo(role).equals(iDiffDoc2.uriInfo(role))) continue;
            bl = false;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(FileType fileType) {
        int n = 0;
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            for (IDiffDoc iDiffDoc : this.docs) {
                if (iDiffDoc.isEmpty() || iDiffDoc.fileType() != fileType) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public IDiffDoc create(DiffDoc.Builder builder, boolean bl) {
        if (builder == null) {
            throw new NullPointerException("builder");
        }
        IDocFactory[] iDocFactoryArray = builder.docFactories();
        int n = iDocFactoryArray.length;
        if (n <= 0) {
            throw new IllegalStateException("No factories to create doc");
        }
        IDocFactory iDocFactory = iDocFactoryArray[n - 1];
        IDiffDoc iDiffDoc = iDocFactory.createDiffDoc(builder);
        this.add(iDiffDoc);
        if (bl) {
            app.stateBoss().saveState();
        }
        return iDiffDoc;
    }

    @Override
    public IDiffDoc create(ContentType contentType) {
        if (contentType == null) {
            throw new NullPointerException("cType");
        }
        IDocFactory[] iDocFactoryArray = DocFactory.getFactories(contentType);
        DiffDoc.Builder builder = new DiffDoc.Builder().contentType(contentType).docFactories(iDocFactoryArray);
        return this.create(builder, false);
    }

    @Override
    public IDiffDoc create(ContentType contentType, Map<Role, String> map) {
        if (contentType == null) {
            throw new NullPointerException("cType");
        }
        if (map == null) {
            throw new NullPointerException("extensions");
        }
        IDocFactory[] iDocFactoryArray = DocFactory.getFactories(contentType);
        DiffDoc.Builder builder = new DiffDoc.Builder().contentType(contentType).fileExtensions(map).docFactories(iDocFactoryArray);
        return this.create(builder, false);
    }

    @Override
    public synchronized IDiffDoc create(JsonReader jsonReader, String string) throws IOException {
        if (jsonReader == null) {
            throw new NullPointerException("jr");
        }
        DiffDoc diffDoc = new DiffDoc(jsonReader, string);
        if (!diffDoc.isEmpty()) {
            this.add(diffDoc);
        }
        return diffDoc;
    }

    @Override
    public IDiffDoc createLinkedDoc(IDiffDoc iDiffDoc, Map<Role, UriInfo> map) {
        UriInfoUtil.makeUriInfosSafe(map, FileType.FILE);
        IDocFactory[] iDocFactoryArray = new IDocFactory[]{DocFactory.getFactory(DocType.TEXT.factoryId())};
        IDiffDoc iDiffDoc2 = new DiffDoc.Builder().uriInfos(map).prefs(iDiffDoc.preferences()).filtersId(iDiffDoc.getFiltersId()).beInHistory(false).docFactories(iDocFactoryArray).build();
        return iDiffDoc2;
    }

    private void ensureMaxSize() {
        this.ensureMaxSize(FileType.FILE);
        this.ensureMaxSize(FileType.FOLDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMaxSize(FileType fileType) {
        assert (this.maxHistorySize >= 0);
        int n = this.count(fileType);
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            int n2 = this.docs.size() - 1;
            while (n2 >= 0 && n >= this.maxHistorySize) {
                IDiffDoc iDiffDoc = this.docs.get(n2);
                if (iDiffDoc.docType().fileType() == fileType && !iDiffDoc.isFavorite()) {
                    this.remove(iDiffDoc);
                    --n;
                }
                --n2;
            }
        }
    }

    public void fireHistoryChanged(IDocBoss.ChangeEvent.Type type, IDiffDoc iDiffDoc) {
        Object[] objectArray = this.listeners.getListeners();
        IDocBoss.ChangeEvent changeEvent = new IDocBoss.ChangeEvent(this, type);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            ((IDocBoss.IDeltaDocListener)object).deltaDocChanged(changeEvent);
            ++n2;
        }
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
        }
        while (jsonReader.hasNext()) {
            this.create(jsonReader, "");
        }
        if (jsonReader.peek() == JsonToken.END_ARRAY) {
            jsonReader.endArray();
        }
    }

    @Override
    public IDiffDoc get(FileType fileType, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("docIx");
        }
        NavigableSet<IDiffDoc> navigableSet = this.getAll(fileType, false);
        if (navigableSet.isEmpty() || n >= navigableSet.size()) {
            throw new IndexOutOfBoundsException("docIx");
        }
        return navigableSet.toArray(new IDiffDoc[navigableSet.size()])[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDiffDoc get(Object object) {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            if (object instanceof String) {
                for (IDiffDoc iDiffDoc : this.docs) {
                    if (!iDiffDoc.displayCreationTime().equals(object)) continue;
                    return iDiffDoc;
                }
                for (IDiffDoc iDiffDoc : this.docs) {
                    if (!iDiffDoc.getName().equals(object)) continue;
                    return iDiffDoc;
                }
            } else if (object instanceof Number) {
                long l = ((Number)object).longValue();
                for (IDiffDoc iDiffDoc : this.docs) {
                    if (iDiffDoc.getTimeCreated() != l) continue;
                    return iDiffDoc;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDiffDoc get(UUID uUID) {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            for (IDiffDoc iDiffDoc : this.docs) {
                if (!iDiffDoc.getId().equals(uUID)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(DocBoss.toStr(new StringBuilder().append("Get   : "), iDiffDoc).toString());
                }
                return iDiffDoc;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(DocBoss.toStr(new StringBuilder().append("Cannot find doc with UID=").append(uUID).append(" in docs:"), this.docs).toString());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDiffDoc> getAll() {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            return new ArrayList<IDiffDoc>(this.docs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalCount() {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            return this.docs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableSet<IDiffDoc> getAll(FileType fileType, boolean bl) {
        TreeSet<IDiffDoc> treeSet = new TreeSet<IDiffDoc>();
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            for (IDiffDoc iDiffDoc : this.docs) {
                if (iDiffDoc.fileType() != fileType || bl && !iDiffDoc.getHasOpenView() || iDiffDoc.isEmpty()) continue;
                treeSet.add(iDiffDoc);
            }
        }
        return treeSet;
    }

    @Override
    public void handleDocException(IDoc iDoc, Exception exception) {
        HashMap<IDoc, Exception> hashMap = new HashMap<IDoc, Exception>();
        hashMap.put(iDoc, exception);
        this.handleDocExceptions(hashMap);
    }

    private boolean handleDocExceptions(IWorkbenchPart iWorkbenchPart, Map<IDoc, Exception> map) {
        DiffDoc diffDoc;
        WorkbenchPartAdapter workbenchPartAdapter = (WorkbenchPartAdapter)iWorkbenchPart.getAdapter(WorkbenchPartAdapter.class);
        if (workbenchPartAdapter != null && (diffDoc = (DiffDoc)workbenchPartAdapter.getEditorInput()) != null) {
            int n = diffDoc.triadCount();
            int n2 = 0;
            while (n2 < n) {
                Collection<IDoc> collection = diffDoc.triad(n2).values();
                HashMap<IDoc, Exception> hashMap = new HashMap<IDoc, Exception>(collection.size());
                for (IDoc iElement : collection) {
                    Exception exception = map.remove(iElement);
                    if (exception == null) continue;
                    hashMap.put(iElement, exception);
                }
                if (!hashMap.isEmpty()) {
                    DiffView diffView = (DiffView)workbenchPartAdapter.viewHolder().view(n2, true);
                    diffView.controller().alerts().showDocException(true, hashMap);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void handleDocExceptions(Map<IDoc, Exception> map) {
        List<IEditorPart> list = UIUtil.getAllCompareEditors();
        for (IEditorPart iEditorPart : list) {
            if (!this.handleDocExceptions((IWorkbenchPart)iEditorPart, map) || !map.isEmpty()) continue;
            return;
        }
    }

    @Override
    public boolean hasThreeWay(Set<IDiffDoc> set) {
        boolean bl = false;
        for (IDiffDoc iDiffDoc : set) {
            UriInfo uriInfo = iDiffDoc.uriInfo(Role.TWO);
            if (uriInfo == null || StringUtil.isEmpty((String)uriInfo.uri())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public int maxUriCount() {
        return this.maxUriHistorySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UriInfo> recentUriInfos(FileType fileType, Role role) {
        ArrayList<UriInfo> arrayList = new ArrayList<UriInfo>();
        int n = 0;
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            for (IDiffDoc iDiffDoc : this.docs) {
                if (iDiffDoc.fileType() != fileType || n >= this.maxUriHistorySize) continue;
                arrayList.add(iDiffDoc.uriInfo(role));
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> recentUris(FileType fileType, Role role) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            for (IDiffDoc iDiffDoc : this.docs) {
                if (iDiffDoc.fileType() != fileType || iDiffDoc.isEmpty() || n >= this.maxUriHistorySize) continue;
                arrayList.add(iDiffDoc.uriInfo(role).displayUri());
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(IDiffDoc iDiffDoc) {
        int n;
        if (iDiffDoc == null) {
            throw new NullPointerException("dDoc");
        }
        boolean bl = false;
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            bl = this.docs.remove(iDiffDoc);
            n = this.docs.size();
        }
        if (bl) {
            if (LOG.isInfoEnabled()) {
                LOG.info(DocBoss.toStr(new StringBuilder("Removed doc: "), iDiffDoc).append("   removed: ").append(bl).append("     size: ").append(n).toString());
            }
            if (iDiffDoc.getFiltersId() != null && !iDiffDoc.getHasOpenView()) {
                app.filterBoss().removeSessionFilters(iDiffDoc.getFiltersId());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Set<FileType> set, boolean bl) {
        LinkedList<IDiffDoc> linkedList = new LinkedList<IDiffDoc>();
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            for (IDiffDoc iDiffDoc : this.docs) {
                if ((!set.contains(FileType.FILE) || iDiffDoc.fileType() != FileType.FILE) && (!set.contains(FileType.FOLDER) || iDiffDoc.fileType() != FileType.FOLDER) || !bl && iDiffDoc.isFavorite()) continue;
                linkedList.add(iDiffDoc);
                UUID uUID = iDiffDoc.getFiltersId();
                assert (uUID != null);
                if (iDiffDoc.getHasOpenView() || uUID == null) continue;
                app.filterBoss().removeSessionFilters(iDiffDoc.getFiltersId());
            }
            if (!linkedList.isEmpty()) {
                this.docs.removeAll(linkedList);
                if (LOG.isInfoEnabled()) {
                    LOG.info(DocBoss.toStr(new StringBuilder("Removed docs by types:\n"), linkedList).toString());
                }
            }
            app.stateBoss().saveState();
        }
    }

    @Override
    public boolean remove(UUID uUID) {
        if (uUID == null) {
            throw new NullPointerException("ddid");
        }
        return this.remove(this.get(uUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<IDiffDoc> set) {
        boolean bl = false;
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            bl = this.docs.removeAll(set);
            if (LOG.isInfoEnabled()) {
                LOG.info(DocBoss.toStr(new StringBuilder("Removed docs:"), set).toString());
            }
        }
        if (bl) {
            app.stateBoss().saveState();
        }
    }

    @Override
    public void removeListener(IDocBoss.IDeltaDocListener iDeltaDocListener) {
        this.listeners.remove((Object)iDeltaDocListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSimilar(IDiffDoc iDiffDoc) {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            int n = this.docs.size() - 1;
            while (n >= 0) {
                IDiffDoc iDiffDoc2 = this.docs.get(n);
                if (iDiffDoc2 != iDiffDoc && !iDiffDoc.isEmpty() && !iDiffDoc2.isEmpty() && this.areSimilar(iDiffDoc2, iDiffDoc)) {
                    String string = iDiffDoc2.getName();
                    boolean bl = iDiffDoc2.isFavorite();
                    long l = iDiffDoc2.getTimeCreated();
                    this.docs.remove(n);
                    if (LOG.isInfoEnabled()) {
                        LOG.info(DocBoss.toStr(new StringBuilder("Removed similar doc: "), iDiffDoc2).toString());
                    }
                    iDiffDoc.setName(string);
                    iDiffDoc.setFavorite(bl);
                    iDiffDoc.setTimeCreated(l);
                }
                --n;
            }
        }
    }

    @Override
    public boolean saveEditor(IEditorPart iEditorPart) {
        if (iEditorPart == null) {
            throw new NullPointerException("saveablePart");
        }
        return this.saveEditors(new IEditorPart[]{iEditorPart});
    }

    @Override
    public boolean saveEditors(IEditorPart[] iEditorPartArray) {
        if (iEditorPartArray == null) {
            throw new NullPointerException("editors");
        }
        if (iEditorPartArray.length <= 0) {
            return true;
        }
        AdaptableList adaptableList = new AdaptableList();
        IEditorPart[] iEditorPartArray2 = iEditorPartArray;
        int n = iEditorPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart iEditorPart = iEditorPartArray2[n2];
            assert (iEditorPart.isDirty());
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IDiffDoc) {
                IDiffDoc iDiffDoc = (IDiffDoc)iEditorInput;
                Collection<IDoc> collection = iDiffDoc.dirtyDocs(0).values();
                for (IDoc iDoc : collection) {
                    adaptableList.add((IAdaptable)new DocWorkbenchAdapter((IMvcModel)iDoc));
                }
            } else if (iEditorInput instanceof IScriptDoc) {
                adaptableList.add((IAdaptable)new DocWorkbenchAdapter((IMvcModel)iEditorInput));
            } else {
                return true;
            }
            ++n2;
        }
        return DiffDoc.saveDirtyDocs(adaptableList);
    }

    @Override
    public boolean saveEditors(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage[] iWorkbenchPageArray;
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        LinkedList<IEditorPart> linkedList = new LinkedList<IEditorPart>();
        IWorkbenchPage[] iWorkbenchPageArray2 = iWorkbenchPageArray = iWorkbenchWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray2[n2];
            linkedList.addAll(Arrays.asList(iWorkbenchPage.getDirtyEditors()));
            ++n2;
        }
        return this.saveEditors(linkedList.toArray(new IEditorPart[linkedList.size()]));
    }

    private void setMaxHistorySize(int n) {
        if (this.maxHistorySize != n) {
            this.maxHistorySize = n;
            this.maxUriHistorySize = Math.min(10, this.maxHistorySize);
            this.ensureMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            return this.docs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDiffDoc[] toArray() {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            return this.docs.toArray(new IDiffDoc[this.docs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(JsonWriter jsonWriter) throws IOException {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            jsonWriter.beginArray();
            for (IDiffDoc iDiffDoc : this.docs) {
                if (iDiffDoc.isEmpty()) continue;
                jsonWriter.beginObject();
                ((IJsonState)iDiffDoc).toJson(jsonWriter);
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
    }

    @Override
    public int uriCount(FileType fileType) {
        int n = this.count(fileType);
        return n < this.maxUriHistorySize ? n : this.maxUriHistorySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<IDiffDoc> list = this.docs;
        synchronized (list) {
            return DocBoss.toStr(new StringBuilder(), this.docs).toString();
        }
    }

    private static final StringBuilder toStr(StringBuilder stringBuilder, IDiffDoc iDiffDoc) {
        if (iDiffDoc != null) {
            stringBuilder.append(iDiffDoc.getId()).append(' ');
            stringBuilder.append('\'').append(iDiffDoc.displayName()).append("' ");
            stringBuilder.append(iDiffDoc);
        } else {
            stringBuilder.append("<NULL>");
        }
        return stringBuilder;
    }

    private static final StringBuilder toStr(StringBuilder stringBuilder, Collection<IDiffDoc> collection) {
        if (collection != null) {
            for (IDiffDoc iDiffDoc : collection) {
                stringBuilder.append("\n\t");
                DocBoss.toStr(stringBuilder, iDiffDoc);
            }
        } else {
            stringBuilder.append("<NULL>");
        }
        return stringBuilder;
    }

    public static DocBoss[] values() {
        DocBoss[] docBossArray = ENUM$VALUES;
        int n = docBossArray.length;
        DocBoss[] docBossArray2 = new DocBoss[n];
        System.arraycopy(ENUM$VALUES, 0, docBossArray2, 0, n);
        return docBossArray2;
    }

    public static DocBoss valueOf(String string) {
        return Enum.valueOf(DocBoss.class, string);
    }
}

