/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.script;

import org.eclipse.swt.SWT;

public final class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;
    static final long serialVersionUID = 3256439218279428914L;

    public Rectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void add(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error((int)4);
        }
        int n = this.x < rectangle.x ? this.x : rectangle.x;
        int n2 = this.y < rectangle.y ? this.y : rectangle.y;
        int n3 = this.x + this.width;
        int n4 = rectangle.x + rectangle.width;
        int n5 = n3 > n4 ? n3 : n4;
        n3 = this.y + this.height;
        n4 = rectangle.y + rectangle.height;
        int n6 = n3 > n4 ? n3 : n4;
        this.x = n;
        this.y = n2;
        this.width = n5 - n;
        this.height = n6 - n2;
    }

    public boolean contains(int n, int n2) {
        return n >= this.x && n2 >= this.y && n < this.x + this.width && n2 < this.y + this.height;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)object;
        return rectangle.x == this.x && rectangle.y == this.y && rectangle.width == this.width && rectangle.height == this.height;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.width ^ this.height;
    }

    public void intersect(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error((int)4);
        }
        if (this == rectangle) {
            return;
        }
        int n = this.x > rectangle.x ? this.x : rectangle.x;
        int n2 = this.y > rectangle.y ? this.y : rectangle.y;
        int n3 = this.x + this.width;
        int n4 = rectangle.x + rectangle.width;
        int n5 = n3 < n4 ? n3 : n4;
        n3 = this.y + this.height;
        n4 = rectangle.y + rectangle.height;
        int n6 = n3 < n4 ? n3 : n4;
        this.x = n5 < n ? 0 : n;
        this.y = n6 < n2 ? 0 : n2;
        this.width = n5 < n ? 0 : n5 - n;
        this.height = n6 < n2 ? 0 : n6 - n2;
    }

    public Rectangle intersection(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error((int)4);
        }
        if (this == rectangle) {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
        int n = this.x > rectangle.x ? this.x : rectangle.x;
        int n2 = this.y > rectangle.y ? this.y : rectangle.y;
        int n3 = this.x + this.width;
        int n4 = rectangle.x + rectangle.width;
        int n5 = n3 < n4 ? n3 : n4;
        n3 = this.y + this.height;
        n4 = rectangle.y + rectangle.height;
        int n6 = n3 < n4 ? n3 : n4;
        return new Rectangle(n5 < n ? 0 : n, n6 < n2 ? 0 : n2, n5 < n ? 0 : n5 - n, n6 < n2 ? 0 : n6 - n2);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        return n < this.x + this.width && n2 < this.y + this.height && n + n3 > this.x && n2 + n4 > this.y;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error((int)4);
        }
        return rectangle == this || this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public String toString() {
        return "Rectangle {" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "}";
    }

    public Rectangle union(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error((int)4);
        }
        int n = this.x < rectangle.x ? this.x : rectangle.x;
        int n2 = this.y < rectangle.y ? this.y : rectangle.y;
        int n3 = this.x + this.width;
        int n4 = rectangle.x + rectangle.width;
        int n5 = n3 > n4 ? n3 : n4;
        n3 = this.y + this.height;
        n4 = rectangle.y + rectangle.height;
        int n6 = n3 > n4 ? n3 : n4;
        return new Rectangle(n, n2, n5 - n, n6 - n2);
    }
}

