/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.resources;

import com.deltawalker.UriInfo;
import com.deltawalker.internal.resources.local.LocalFileFactory;
import com.deltawalker.internal.resources.local.LocalResourceDialog;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.script.Role;
import com.deltawalker.ui.dialogs.ILocalResourceDialog;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileType;
import com.deltopia.io.IFile;
import com.deltopia.io.IO;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.jface.preference.IPreferenceStore;

public class SnapshotResourceFactory
extends ResourceFactory {
    public static final boolean caseSensitive = EFS.getLocalFileSystem().isCaseSensitive();
    private static SnapshotResourceFactory factory;

    public static SnapshotResourceFactory getInstance() {
        return factory;
    }

    public SnapshotResourceFactory() {
        factory = this;
    }

    @Override
    public IResource createResource(UriInfo uriInfo, boolean bl, boolean bl2) throws IOException {
        return null;
    }

    @Override
    public ILocalResourceDialog createResourceWindow(Role role, boolean bl, boolean bl2, String string, IPreferenceStore iPreferenceStore, UriInfo uriInfo) {
        return new LocalResourceDialog(role, bl, bl2, string, iPreferenceStore, uriInfo);
    }

    @Override
    public FileType getResourceType(UriInfo uriInfo) throws IOException {
        FileInfo fileInfo = IO.fileSystem().getFileInfo(new File(uriInfo.uri()));
        return fileInfo.isDirectory() ? FileType.FOLDER : FileType.FILE;
    }

    @Override
    public boolean isCaseSensitive() {
        return caseSensitive;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public IFile resolveFile(UriInfo uriInfo) throws NullPointerException, IOException {
        return LocalFileFactory.createFile(new File(uriInfo.uri()));
    }

    @Override
    public boolean resourceExists(UriInfo uriInfo) {
        try {
            IO.fileSystem().getFileInfo(new File(uriInfo.uri()));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

