/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.resources;

import com.deltopia.StringUtil;
import com.deltopia.interfaces.IPrincipal;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileInfoEx;
import com.deltopia.io.IFile;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import com.deltopia.io.Principal;
import com.deltopia.io.StructFileInfo;
import com.deltopia.io.UriInfoKey;
import com.deltopia.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFile
implements IFile {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotFile.class);
    private File file;
    private FileInfo fileInfo;
    private final IFile parent;
    private String parentPath;
    private SoftReference<String> pathRef;
    private StructFileInfo sfi;

    public SnapshotFile(StructFileInfo structFileInfo, IFile iFile) {
        this.sfi = structFileInfo;
        this.fileInfo = structFileInfo.fileInfo();
        this.parent = iFile;
        this.parentPath = null;
    }

    private String constructPath(boolean bl) {
        String string = this.parentPath(bl);
        String string2 = this.getName();
        if (!StringUtil.isEmpty((String)string)) {
            if (!string.endsWith(File.separator)) {
                return String.valueOf(string) + File.separator + string2;
            }
            return String.valueOf(string) + string2;
        }
        return bl && this.parent == null ? "" : string2;
    }

    public long createdTime() {
        if (this.fileInfo instanceof FileInfoEx) {
            return ((FileInfoEx)this.fileInfo).createdTime();
        }
        return this.getLastModifiedTime();
    }

    public InputStream createInputStream(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void createNewFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public OutputStream createOutputStream(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void createSymbolicLink(IFile iFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        return this.file().exists();
    }

    public File file() {
        if (this.file == null) {
            this.file = new File(this.constructPath(false));
        }
        return this.file;
    }

    public int getAttributes() {
        return this.getFileInfo().attributes();
    }

    public String getDisplayUri() {
        return this.getPath();
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public IPrincipal getGroup() {
        if (this.fileInfo instanceof FileInfoEx) {
            FileInfoEx fileInfoEx = (FileInfoEx)this.fileInfo;
            try {
                return IO.fileSystem().getGroup(fileInfoEx.getGid());
            }
            catch (IOException iOException) {
                LOG.error("Couldn't get group name from group ID", (Throwable)iOException);
                return new Principal(fileInfoEx.getGid());
            }
        }
        return null;
    }

    public long getLastModifiedTime() {
        return this.fileInfo.lastModifiedTime();
    }

    public String getName() {
        return this.fileInfo.name();
    }

    public IPrincipal getOwner() {
        if (this.fileInfo instanceof FileInfoEx) {
            FileInfoEx fileInfoEx = (FileInfoEx)this.fileInfo;
            try {
                return IO.fileSystem().getUser(fileInfoEx.getUid());
            }
            catch (IOException iOException) {
                LOG.error("Couldn't get user name from user ID", (Throwable)iOException);
                return new Principal(fileInfoEx.getUid());
            }
        }
        return null;
    }

    public String getParentUri() {
        return this.parentPath(false);
    }

    public String getPath() {
        if (this.isDirectory(true)) {
            String string;
            if (this.pathRef == null) {
                this.pathRef = new SoftReference<String>(this.constructPath(false));
            }
            if ((string = this.pathRef.get()) != null) {
                return string;
            }
        }
        return this.constructPath(false);
    }

    public String getUri() {
        return this.getPath();
    }

    public boolean isDirectory(boolean bl) {
        if (bl && this.isSymbolicLink()) {
            return this.file().isDirectory();
        }
        return this.fileInfo.isDirectory();
    }

    public boolean isHidden() {
        return this.fileInfo.isHidden();
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isMoveToTrashSupported() {
        return false;
    }

    public boolean isReadable() {
        return this.fileInfo.isReadable();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isSymbolicLink() {
        return this.fileInfo.isSymbolicLink();
    }

    public boolean isWritable() {
        return this.fileInfo.isWritable();
    }

    public long lastOpenedTime() {
        if (this.fileInfo instanceof FileInfoEx) {
            return ((FileInfoEx)this.fileInfo).lastAccessedTime();
        }
        return this.getLastModifiedTime();
    }

    public IFile[] listFiles(int n, IProgressMonitor iProgressMonitor) throws IOException {
        IFile[] iFileArray;
        List list = this.sfi.getChildren();
        int n2 = list.size();
        if (list.isEmpty()) {
            iFileArray = NO_FILES;
        } else {
            iFileArray = new IFile[n2];
            int n3 = 0;
            while (n3 < n2) {
                iFileArray[n3] = new SnapshotFile((StructFileInfo)list.get(n3), this);
                ++n3;
            }
        }
        return iFileArray;
    }

    public void mkdir() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean moveToTrash() {
        throw new UnsupportedOperationException();
    }

    public IFile parent() {
        return this.parent;
    }

    private String parentPath(boolean bl) {
        if (this.parent != null) {
            return bl ? this.parent.rootlessPath() : this.parent.getPath();
        }
        return bl ? "" : StringUtil.makeSafe((String)this.parentPath);
    }

    public String readSymbolicLink() throws IOException {
        IFileSystem iFileSystem = IO.fileSystem();
        assert (iFileSystem.isReadSymbolicLinkSupported() && this.isSymbolicLink());
        return IO.fileSystem().readSymbolicLink(this.getPath());
    }

    public void renameTo(String string, Map<UriInfoKey, Object> map, boolean bl) throws IOException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("name");
        }
        this.fileInfo = this.fileInfo.cloneUsingNewName(string);
    }

    public IFile resolveFile(String string, IFile iFile, boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long resourceForkSize() {
        long l = 0L;
        if (OS.OSX) {
            l = new File(String.valueOf(this.getPath()) + "/..namedfork/rsrc").length();
        }
        return l;
    }

    public String rootlessPath() {
        String string = this.constructPath(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Local rootless path: " + string);
        }
        return string;
    }

    public String scheme() {
        return "";
    }

    public void setAttributes(int n) throws IOException {
        this.setFileInfo(this.fileInfo.cloneUsingNewAttributes(n));
    }

    public void setFileInfo(FileInfo fileInfo) throws IOException {
        this.fileInfo = fileInfo;
    }

    public void setHidden(boolean bl) throws IOException {
        if (OS.WIN && this.fileInfo.isHidden() != bl) {
            int n = this.fileInfo.attributes();
            int n2 = bl ? n | 0x20 : n & 0xFFFFFFDF;
            this.fileInfo = this.fileInfo.cloneUsingNewAttributes(n2);
        }
    }

    public void setLastModifiedTime(long l) throws IOException {
        this.fileInfo = this.fileInfo.cloneUsingNewLastModifiedTime(l);
    }

    public void setWritable(boolean bl) throws IOException {
        if (this.fileInfo.isWritable() != bl) {
            int n = this.fileInfo.attributes();
            int n2 = bl ? n | 0x20000 : n & 0xFFFDFFFF;
            this.fileInfo = this.fileInfo.cloneUsingNewAttributes(n2);
        }
    }

    public long size() {
        return this.fileInfo.size();
    }

    public String toString() {
        return this.getUri();
    }

    public void updateFileInfo() {
    }
}

