/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.resources;

import com.deltawalker.UriInfo;
import com.deltawalker.internal.resources.ResourceFactoryInfo;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.IResourceFactory;
import com.deltopia.eclipse.util.FactoryFinder;
import com.deltopia.io.FileType;
import com.deltopia.io.VfsUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceFactory
implements IResourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFactory.class);
    private static ResourceFactoryInfo[] rfInfoCache;

    private static Set<IResourceFactory> getFactories(UriInfo uriInfo) {
        String string;
        File file;
        boolean bl;
        String string2;
        IResourceFactory iResourceFactory;
        ResourceFactoryInfo[] resourceFactoryInfoArray = ResourceFactory.getInfos();
        LinkedHashSet<IResourceFactory> linkedHashSet = new LinkedHashSet<IResourceFactory>(resourceFactoryInfoArray.length);
        if (!uriInfo.snapshotPath().isEmpty()) {
            ResourceFactory.getFactory("com.deltawalker.snapshotResourceFactory");
        }
        if ((iResourceFactory = ResourceFactory.getFactory(string2 = (bl = !(file = new File(string = uriInfo.uri())).isDirectory() && (uriInfo.hasArchiveUri() || VfsUtil.hasVfsScheme((String)string))) ? "com.deltawalker.vfs.vfsResourceFactory" : "com.deltawalker.localResourceFactory")) != null) {
            linkedHashSet.add(iResourceFactory);
        }
        return linkedHashSet;
    }

    public static IResourceFactory getFactory(String string) {
        ResourceFactoryInfo[] resourceFactoryInfoArray;
        if (string == null) {
            throw new NullPointerException("factoryId");
        }
        ResourceFactoryInfo[] resourceFactoryInfoArray2 = resourceFactoryInfoArray = ResourceFactory.getInfos();
        int n = resourceFactoryInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceFactoryInfo resourceFactoryInfo = resourceFactoryInfoArray2[n2];
            if (string.equals(resourceFactoryInfo.id())) {
                return resourceFactoryInfo.getResourceFactory();
            }
            ++n2;
        }
        assert (false);
        LOG.error("Cannot load: " + string);
        return null;
    }

    private static ResourceFactoryInfo[] getInfos() {
        if (rfInfoCache == null && (rfInfoCache = (ResourceFactoryInfo[])FactoryFinder.loadInfos("com.deltawalker.resourceFactories", ResourceFactoryInfo.class)) == null) {
            rfInfoCache = new ResourceFactoryInfo[0];
        }
        return rfInfoCache;
    }

    public static IResource staticCreateResource(UriInfo uriInfo) throws IOException {
        return ResourceFactory.staticCreateResource(uriInfo, false, true);
    }

    public static IResource staticCreateResource(UriInfo uriInfo, boolean bl, boolean bl2) throws IOException {
        if (uriInfo.isEmpty()) {
            return null;
        }
        Set<IResourceFactory> set = ResourceFactory.getFactories(uriInfo);
        IOException iOException = null;
        for (IResourceFactory iResourceFactory : set) {
            try {
                return iResourceFactory.createResource(uriInfo, bl, bl2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        return null;
    }

    public static FileType staticGetResourceType(UriInfo uriInfo) throws IOException {
        String string = uriInfo.uri();
        if (!string.isEmpty() && !UriInfo.isHintUri(string)) {
            Set<IResourceFactory> set = ResourceFactory.getFactories(uriInfo);
            IOException iOException = null;
            for (IResourceFactory iResourceFactory : set) {
                try {
                    return iResourceFactory.getResourceType(uriInfo);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            if (iOException != null) {
                throw iOException;
            }
        }
        return FileType.UNKNOWN;
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }
}

