/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.resources;

import com.deltawalker.IStruct;
import com.deltawalker.IStructElement;
import com.deltawalker.NotifyUtil;
import com.deltawalker.internal.resources.local.ResourceStructComparator;
import com.deltawalker.resources.AbstractResource;
import com.deltawalker.resources.FolderResource;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Resource;
import com.deltawalker.structure.IStructComparator;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IPrincipal;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileInfo;
import com.deltopia.io.IFile;
import com.deltopia.io.UriInfoKey;
import com.deltopia.util.BitUtil;
import com.deltopia.util.OS;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class Resource
extends AbstractResource
implements IAdaptable,
IPersistableResource {
    static final byte FLAG_EXCLUDED = 2;
    private static final byte FLAG_FOLLOW_LINKS = 1;
    static final byte FLAG_USE_EXTENDED_MASK = 4;
    private IFile file;
    private volatile byte flags = 0;

    public Resource(IFile iFile, FolderResource folderResource, boolean bl) {
        super(folderResource);
        this.file = iFile;
        this.setFlags((byte)1, bl);
    }

    protected final boolean areFlagsSet(byte by) {
        return BitUtil.areBitsSet((byte)this.flags, (byte)by);
    }

    @Override
    public int attributes() {
        return this.file.getAttributes();
    }

    private int attributesAsInt(Resource.Attribute[] attributeArray) {
        assert (attributeArray != null);
        int n = 0;
        if (attributeArray.length == 0) {
            return n;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.HIDDEN)) {
            n |= 0x20;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.ARCHIVE)) {
            n |= 0x100;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.FOLDER)) {
            n |= 1;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.SYMBOLIC_LINK)) {
            n |= 0x40;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.SYSTEM)) {
            n |= 0x80;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.EXECUTABLE)) {
            n |= 0x40000;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.READABLE)) {
            n |= 0x10000;
        }
        if (this.hasAttribute(attributeArray, Resource.Attribute.WRITABLE)) {
            n |= 0x20000;
        }
        return n;
    }

    private Set<Resource.Attribute> attributesAsSet() {
        EnumSet<Resource.Attribute> enumSet = EnumSet.noneOf(Resource.Attribute.class);
        int n = this.attributes();
        if (FileInfo.isSet((int)n, (int)32)) {
            enumSet.add(Resource.Attribute.HIDDEN);
        }
        if (FileInfo.isSet((int)n, (int)256)) {
            enumSet.add(Resource.Attribute.ARCHIVE);
        }
        if (FileInfo.isSet((int)n, (int)1)) {
            enumSet.add(Resource.Attribute.FOLDER);
        }
        if (FileInfo.isSet((int)n, (int)64)) {
            enumSet.add(Resource.Attribute.SYMBOLIC_LINK);
        }
        if (FileInfo.isSet((int)n, (int)128)) {
            enumSet.add(Resource.Attribute.SYSTEM);
        }
        if (FileInfo.isSet((int)n, (int)262144)) {
            enumSet.add(Resource.Attribute.EXECUTABLE);
        }
        if (FileInfo.isSet((int)n, (int)65536)) {
            enumSet.add(Resource.Attribute.READABLE);
        }
        if (FileInfo.isSet((int)n, (int)131072)) {
            enumSet.add(Resource.Attribute.WRITABLE);
        }
        return enumSet;
    }

    @Override
    public boolean canEverWrite() throws IOException {
        ContentType contentType = this.contentType();
        boolean bl = contentType.isArchive() || contentType.isCompoundDoc() || this.followLinks() && this.isSymbolicLink();
        return !bl;
    }

    @Override
    public long createdTime() {
        return this.file.createdTime();
    }

    @Override
    public void dispose() {
        this.file = null;
        super.dispose();
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.isUriEqual(((Resource)object).getUri());
    }

    @Override
    public final int compareTo(IResource iResource) {
        if (iResource == null) {
            return 1;
        }
        boolean bl = this.factory().isCaseSensitive();
        int n = StringUtil.compare((String)this.getClass().getName(), (String)iResource.getClass().getName(), (boolean)bl, (boolean)true);
        if (n == 0) {
            n = StringUtil.compare((String)this.getUri(), (String)iResource.getUri(), (boolean)bl, (boolean)true);
        }
        return n;
    }

    @Override
    public IFile file() {
        return this.file;
    }

    private Resource findResource(IPath iPath) {
        if (iPath.segmentCount() == 0) {
            return this;
        }
        if (this instanceof IStruct) {
            IStructElement[] iStructElementArray;
            try {
                iStructElementArray = ((IStruct)((Object)this)).getChildren(null);
            }
            catch (IOException iOException) {
                return null;
            }
            if (iStructElementArray != null && iStructElementArray.length > 0) {
                File file = new File(iPath.segment(0));
                IStructElement[] iStructElementArray2 = iStructElementArray;
                int n = iStructElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStructElement iStructElement = iStructElementArray2[n2];
                    if (new File(iStructElement.getName()).equals(file)) {
                        if (!(iStructElement instanceof Resource)) break;
                        return ((Resource)iStructElement).findResource(iPath.removeFirstSegments(1));
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    protected void fireReadOnlyPropertyChanged(boolean bl, boolean bl2) {
        if (bl != bl2) {
            NotifyUtil.firePropertyChange(this.getListeners(), new PropertyChangeEvent((Object)this, "READ_ONLY", (Object)bl2, (Object)bl));
        }
    }

    protected final boolean followLinks() {
        return this.areFlagsSet((byte)1);
    }

    public Object getAdapter(Class clazz) {
        if (IStructComparator.class.equals((Object)clazz)) {
            return new ResourceStructComparator(this);
        }
        return null;
    }

    @Override
    public Resource.Attribute[] getAttributes() {
        Set<Resource.Attribute> set = this.attributesAsSet();
        return set.toArray(new Resource.Attribute[set.size()]);
    }

    @Override
    public String getDisplayUri() {
        return this.file.getDisplayUri();
    }

    @Override
    public IPrincipal getGroup() {
        return this.file.getGroup();
    }

    @Override
    public long getLastModifiedTime() {
        return this.file.getLastModifiedTime();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public IPrincipal getOwner() {
        return this.file.getOwner();
    }

    @Override
    public String getParentUri() {
        return this.file.getParentUri();
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getUri() {
        return this.file.getUri();
    }

    @Override
    public boolean hasAttribute(Resource.Attribute attribute) {
        return this.attributesAsSet().contains((Object)attribute);
    }

    private boolean hasAttribute(Resource.Attribute[] attributeArray, Resource.Attribute attribute) {
        Resource.Attribute[] attributeArray2 = attributeArray;
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource.Attribute attribute2 = attributeArray2[n2];
            if (attribute2 == attribute) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory(this.followLinks());
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    protected boolean isNameEqual(String string) {
        String string2 = this.getName();
        if (this.factory().isCaseSensitive()) {
            return string2.equals(string);
        }
        return string2.equalsIgnoreCase(string);
    }

    @Override
    public boolean isSymbolicLink() {
        return this.file.isSymbolicLink();
    }

    protected boolean isUriEqual(String string) {
        String string2 = this.getUri();
        if (this.factory().isCaseSensitive()) {
            return string2.equals(string);
        }
        return string2.equalsIgnoreCase(string);
    }

    @Override
    public boolean isWritable() {
        return this.file.isWritable();
    }

    @Override
    public long lastOpenedTime() {
        return this.file.lastOpenedTime();
    }

    @Override
    public void renameTo(String string, Map<UriInfoKey, Object> map, boolean bl) throws IOException {
        this.file.renameTo(string, map, bl);
    }

    @Override
    public String rootlessPath() {
        return this.file.rootlessPath();
    }

    @Override
    public void setAttributes(Resource.Attribute[] attributeArray) throws IOException {
        if (attributeArray == null) {
            throw new NullPointerException("'attributes' cannot be null.");
        }
        int n = this.attributesAsInt(attributeArray);
        this.file().setAttributes(n);
    }

    final boolean setFlags(byte by, boolean bl) {
        byte by2 = this.flags;
        if (bl == BitUtil.areBitsSet((byte)by2, (byte)by)) {
            return false;
        }
        this.flags = BitUtil.setBits((byte)by2, (byte)by, (boolean)bl);
        return true;
    }

    @Override
    public void setHidden(boolean bl) throws IOException {
        if (OS.WIN && bl != this.file.isHidden()) {
            this.file.setHidden(bl);
        }
    }

    @Override
    public void setLastModifiedTime(long l) throws IOException {
        this.file.setLastModifiedTime(l);
    }

    @Override
    public void setWritable(boolean bl) throws IOException {
        boolean bl2 = this.isWritable();
        if (bl != bl2) {
            this.file.setWritable(bl);
            this.fireReadOnlyPropertyChanged(bl, bl2);
        }
    }

    public String toString() {
        return this.getUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFileInfo() {
        Resource resource = this;
        synchronized (resource) {
            this.file.updateFileInfo();
        }
    }
}

