/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.resources;

import com.deltawalker.IStruct;
import com.deltawalker.IStructElement;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.NotifyUtil;
import com.deltawalker.interfaces.IContentChangeNotifier;
import com.deltawalker.interfaces.IEditableStruct;
import com.deltawalker.interfaces.IExceptionHandler;
import com.deltawalker.interfaces.IFileContentListener;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.Resource;
import com.deltawalker.resources.ResourceByNameComparator;
import com.deltawalker.text.Filters;
import com.deltopia.collection.ISortedSetList;
import com.deltopia.collection.SortedSetListFactory;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileType;
import com.deltopia.io.IByteSequence;
import com.deltopia.io.IFile;
import com.deltopia.io.IO;
import com.deltopia.util.Checker;
import com.deltopia.util.LifecycleUtil;
import com.deltopia.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FolderResource
extends Resource
implements IEditableStruct,
IContentChangeNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(FolderResource.class);
    private final ISortedSetList<IResource> children = SortedSetListFactory.mostMemoryOptimal((int)0, (Comparator)ResourceByNameComparator.INSTANCE);
    private List<IFolderFilter> filters = new ArrayList<IFolderFilter>();
    private long size = 0L;

    public FolderResource(IFile iFile, FolderResource folderResource, boolean bl, boolean bl2) {
        super(iFile, folderResource, bl);
        this.setExcluded(bl2);
    }

    @Override
    public IStructElement addChild(IStructElement iStructElement, boolean bl, boolean bl2, boolean bl3, ISyncProgressMonitor iSyncProgressMonitor, IExceptionHandler iExceptionHandler) throws IOException {
        if (iExceptionHandler == null) {
            return this.addChildImpl(iStructElement, bl, bl2, bl3, iSyncProgressMonitor, iExceptionHandler);
        }
        try {
            return this.addChildImpl(iStructElement, bl, bl2, bl3, iSyncProgressMonitor, iExceptionHandler);
        }
        catch (IOException iOException) {
            LOG.warn("Add child failed " + iStructElement, (Throwable)iOException);
            if (!iExceptionHandler.handleException(iOException)) {
                throw iOException;
            }
            return null;
        }
    }

    private IStructElement addChildImpl(IStructElement iStructElement, boolean bl, boolean bl2, boolean bl3, ISyncProgressMonitor iSyncProgressMonitor, IExceptionHandler iExceptionHandler) throws IOException {
        Object object;
        IResource iResource;
        IStructElement[] iStructElementArray;
        if (iSyncProgressMonitor.isCanceled()) {
            return null;
        }
        IResource iResource2 = (IResource)iStructElement;
        IResource[] iResourceArray = new IResource[1];
        boolean bl4 = iResource2.isSymbolicLink();
        int n = 0;
        boolean bl5 = this.isWritable();
        if (!bl5) {
            n = this.attributes();
            this.setWritable(true);
        }
        boolean bl6 = false;
        boolean bl7 = bl4 ? false : iResource2 instanceof IStruct;
        try {
            boolean bl8;
            iStructElementArray = this.findChildByName(iStructElement.getName(), (IProgressMonitor)iSyncProgressMonitor);
            if (iStructElementArray != null) {
                bl8 = iStructElementArray.isSymbolicLink();
                boolean bl9 = iStructElementArray.isDirectory();
                if (bl7 != bl9 || bl4 != bl8) {
                    String string = NLS.bind((String)"Couldn't copy ''{0}'' - resource of different type with the same name already exists in the destination.", (Object)iResource2.getPath());
                    throw new IOException(string);
                }
                iResourceArray[0] = iStructElementArray;
            }
            if (!bl4 && iResourceArray[0] != null) {
                if (!iResourceArray[0].isWritable()) {
                    iResourceArray[0].setWritable(true);
                }
                if (OS.WIN && (bl8 = iResourceArray[0].isHidden())) {
                    iResourceArray[0].setHidden(false);
                }
            }
            iResource = this.findChildByName(iStructElement.getName());
            object = null;
            object = iResource != null ? iResource.file() : this.file().resolveFile(iStructElement.getName(), this.file(), bl);
            if (bl7) {
                this.addFolderChild(iResource2, iResourceArray, (IFile)object);
            } else {
                this.addFileChild(iResource2, iResourceArray, (IFile)object, bl3, iSyncProgressMonitor);
            }
            bl6 = true;
        }
        finally {
            if (!bl5) {
                this.file().setAttributes(n);
            }
            if (bl6 && !bl3 && iResourceArray[0] != null) {
                iResourceArray[0].updateFileInfo();
            }
        }
        if (bl7 && bl2) {
            iStructElementArray = ((IStruct)iStructElement).getChildren((IProgressMonitor)iSyncProgressMonitor);
            iResource = (FolderResource)iResourceArray[0];
            IStructElement[] iStructElementArray2 = iStructElementArray;
            int n2 = iStructElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = iStructElementArray2[n3];
                IResource iResource3 = (IResource)object;
                boolean bl10 = Filters.matches(this.getFilters(), iResource3.file(), iResource3.isDirectory());
                if (bl10) {
                    ((FolderResource)iResource).addChild((IStructElement)object, bl, true, bl3, iSyncProgressMonitor, iExceptionHandler);
                }
                ++n3;
            }
            if (bl3) {
                ((FolderResource)iResource2).removeChildren(false);
            }
        }
        return iResourceArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildResource(IResource iResource) {
        ISortedSetList<IResource> iSortedSetList = this.children;
        synchronized (iSortedSetList) {
            boolean bl = this.children.add((Object)iResource);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.valueOf(bl ? "Add child: " : "Cannot add child: ") + iResource);
            }
        }
    }

    @Override
    public void addContentChangeListener(IFileContentListener iFileContentListener) {
        this.addListenerObject(iFileContentListener);
    }

    private void addFileChild(IResource iResource, IResource[] iResourceArray, IFile iFile, boolean bl, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        block21: {
            IFile iFile2 = iResource.file();
            boolean bl2 = true;
            iSyncProgressMonitor.subTask(iFile2.getPath());
            boolean bl3 = iFile2.isSymbolicLink();
            if (iResourceArray[0] == null) {
                if (bl3) {
                    iFile.createSymbolicLink(iFile2);
                }
                iResourceArray[0] = this.createChildResource(iFile, false, false);
            }
            try {
                if (!bl) {
                    if (!bl3) {
                        try {
                            IO.fileSystem().copyFile(iFile2, iFile, iSyncProgressMonitor);
                            break block21;
                        }
                        catch (IOException iOException) {
                            bl2 = false;
                            throw iOException;
                        }
                    }
                    iResourceArray[0].file().setFileInfo(iFile2.getFileInfo());
                    break block21;
                }
                boolean bl4 = true;
                int n = 0;
                IResource iResource2 = iResource.getParent();
                if (iResource2 != null) {
                    try {
                        bl4 = iResource2.isWritable();
                        if (!bl4) {
                            n = this.attributes();
                            iResource2.setWritable(true);
                        }
                    }
                    catch (IOException iOException) {
                        LOG.error("Couldn't make source parent folder writable", (Throwable)iOException);
                    }
                }
                try {
                    if (!bl3) {
                        try {
                            IO.fileSystem().moveFile(iFile2, iFile, iSyncProgressMonitor);
                            break block21;
                        }
                        catch (IOException iOException) {
                            bl2 = false;
                            throw iOException;
                        }
                    }
                    IO.fileSystem().delete(new File(iFile2.getPath()), true);
                }
                finally {
                    if (!bl4) {
                        iResource2.file().setAttributes(n);
                    }
                }
            }
            finally {
                if (bl2) {
                    this.addChildResource(iResourceArray[0]);
                }
            }
        }
    }

    private void addFolderChild(IResource iResource, IResource[] iResourceArray, IFile iFile) throws IOException {
        if (iResourceArray[0] == null) {
            this.createNewFile(iFile, true);
            iResourceArray[0] = this.createChildResource(iFile, true, false);
            if (iResourceArray[0].file().isLocal()) {
                iResourceArray[0].file().setFileInfo(iResource.file().getFileInfo());
            }
        }
        if (iResourceArray[0] != null) {
            this.addChildResource(iResourceArray[0]);
        }
    }

    @Override
    public ContentType contentType() {
        return ContentType.FOLDER;
    }

    protected abstract IResource createChildResource(IFile var1, boolean var2, boolean var3);

    private void createNewFile(IFile iFile, boolean bl) throws IOException {
        block18: {
            boolean bl2 = this.isWritable();
            boolean bl3 = false;
            int n = 0;
            String string = null;
            try {
                try {
                    if (!bl2) {
                        n = this.attributes();
                        this.setWritable(true);
                    }
                    if (OS.WIN && (bl3 = this.isHidden())) {
                        this.setHidden(false);
                    }
                    if (bl) {
                        iFile.mkdir();
                    } else {
                        iFile.createNewFile();
                    }
                }
                catch (IOException iOException) {
                    string = iOException.getLocalizedMessage();
                    if (!bl2) {
                        this.file().setAttributes(n);
                    }
                    if (OS.WIN && bl3) {
                        this.setHidden(true);
                    }
                    if (string != null) {
                        String string2 = NLS.bind((String)Msg.FolderResource_errCreate, (Object[])new String[]{iFile.getName(), this.getUri(), string});
                        throw new IOException(string2);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (!bl2) {
                    this.file().setAttributes(n);
                }
                if (OS.WIN && bl3) {
                    this.setHidden(true);
                }
                if (string != null) {
                    String string3 = NLS.bind((String)Msg.FolderResource_errCreate, (Object[])new String[]{iFile.getName(), this.getUri(), string});
                    throw new IOException(string3);
                }
                throw throwable;
            }
            if (!bl2) {
                this.file().setAttributes(n);
            }
            if (OS.WIN && bl3) {
                this.setHidden(true);
            }
            if (string != null) {
                String string4 = NLS.bind((String)Msg.FolderResource_errCreate, (Object[])new String[]{iFile.getName(), this.getUri(), string});
                throw new IOException(string4);
            }
        }
    }

    @Override
    public IStructElement deleteChild(IStructElement iStructElement, boolean bl, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        IResource iResource = (IResource)iStructElement;
        IFile iFile = iResource.file();
        if (iSyncProgressMonitor != null) {
            iSyncProgressMonitor.subTask(iFile.getUri());
        }
        if (iFile.exists()) {
            boolean bl2 = this.isWritable();
            int n = 0;
            try {
                boolean bl3;
                if (!bl2) {
                    n = this.attributes();
                    this.setWritable(true);
                }
                if (!(bl3 = iFile.moveToTrash())) {
                    String string = NLS.bind((String)Msg.FolderResource_errDelete, (Object)iFile.getUri());
                    throw new IOException(string);
                }
            }
            finally {
                if (!bl2) {
                    FileInfo fileInfo = this.file().getFileInfo().cloneUsingNewAttributes(n);
                    this.file().setFileInfo(fileInfo);
                }
            }
        }
        this.removeChildResource(iResource);
        if (iSyncProgressMonitor != null) {
            iSyncProgressMonitor.itemTransferred();
        }
        if (bl) {
            this.fireContentChanged(iStructElement, true);
        }
        return iStructElement;
    }

    @Override
    public void dispose() {
        this.removeChildren(true);
        this.filters.clear();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResource findChildByName(String string) {
        Checker.notEmpty((String)string, (String)"name");
        IResource iResource = null;
        ISortedSetList<IResource> iSortedSetList = this.children;
        synchronized (iSortedSetList) {
            for (IResource iResource2 : this.children) {
                if (!((Resource)iResource2).isNameEqual(string)) continue;
                iResource = iResource2;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            if (iResource != null) {
                LOG.debug("Find resource by name '" + string + "': " + iResource);
            } else {
                LOG.debug("Cannot find resource by name '" + string + "'");
            }
        }
        return iResource;
    }

    private IResource findChildByName(String string, IProgressMonitor iProgressMonitor) throws IOException {
        IResource[] iResourceArray;
        IResource[] iResourceArray2 = iResourceArray = this.getChildren(iProgressMonitor);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (((Resource)iResource).isNameEqual(string)) {
                return iResource;
            }
            ++n2;
        }
        return null;
    }

    private void fireContentChanged(IStructElement iStructElement, boolean bl) {
        NotifyUtil.fireContentChanged(this.getListeners(), iStructElement, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] getChildren(IProgressMonitor iProgressMonitor) throws IOException {
        IResource[] iResourceArray = this.children;
        synchronized (this.children) {
            boolean bl = this.children.isEmpty();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (bl) {
                this.loadChildren((IProgressMonitor)(iProgressMonitor != null ? iProgressMonitor : new NullProgressMonitor()), false);
            }
            ISortedSetList<IResource> iSortedSetList = this.children;
            synchronized (iSortedSetList) {
                iResourceArray = (IResource[])this.children.toArray((Object[])new IResource[this.children.size()]);
            }
            return iResourceArray;
        }
    }

    @Override
    public String getExtension() {
        return "";
    }

    @Override
    public List<IFolderFilter> getFilters() {
        return this.root() == this ? this.filters : ((IStruct)((Object)this.root())).getFilters();
    }

    @Override
    public final Image getImage() {
        EnumSet<ImageCache.Type> enumSet = EnumSet.noneOf(ImageCache.Type.class);
        if (!this.file().isReadable()) {
            enumSet.add(ImageCache.Type.NO_PERMISSION);
        }
        if (this.file().isSymbolicLink()) {
            enumSet.add(ImageCache.Type.SYM_LINK);
        }
        return ImageCache.getProcessedImage(ImageConst.FOLDER, enumSet);
    }

    public int getListFieldMask() {
        int n = this.areFlagsSet((byte)4) ? 127 : 7;
        return n;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public FileType getType() {
        return FileType.FOLDER;
    }

    @Override
    public boolean isExcluded() {
        return this.areFlagsSet((byte)2);
    }

    private boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public IByteSequence load(String string, IProgressMonitor iProgressMonitor) throws IOException {
        this.loadChildren(iProgressMonitor, false);
        return null;
    }

    private void loadChildren(IProgressMonitor iProgressMonitor, boolean bl) throws IOException {
        IFile[] iFileArray;
        block8: {
            this.removeChildren(false);
            if (this.isExcluded()) {
                return;
            }
            iFileArray = null;
            try {
                if (this.file().isReadable()) {
                    int n = ((FolderResource)this.root()).getListFieldMask();
                    iFileArray = this.file().listFiles(n, iProgressMonitor);
                }
            }
            catch (IOException iOException) {
                LOG.error("Cannot list files for " + this.getDisplayUri(), (Throwable)iOException);
                if (!this.isRoot()) break block8;
                throw iOException;
            }
        }
        if (iFileArray != null && !iProgressMonitor.isCanceled()) {
            IFile[] iFileArray2 = iFileArray;
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile iFile = iFileArray2[n2];
                boolean bl2 = false;
                bl2 = !this.followLinks() && iFile.isSymbolicLink() ? false : iFile.isDirectory(this.followLinks());
                if (bl2) {
                    boolean bl3 = !Filters.matches(this.getFilters(), iFile, bl2);
                    this.addChildResource(this.createChildResource(iFile, bl2, bl3));
                } else {
                    this.addChildResource(this.createChildResource(iFile, bl2, false));
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildren(boolean bl) {
        HashSet<IResource> hashSet;
        ISortedSetList<IResource> iSortedSetList = this.children;
        synchronized (iSortedSetList) {
            hashSet = bl ? new HashSet<IResource>((Collection<IResource>)this.children) : null;
            if (LOG.isInfoEnabled()) {
                LOG.info("Remove children: " + this.children.size());
            }
            this.children.clear();
        }
        if (bl) {
            LifecycleUtil.disposeAll(hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildResource(IResource iResource) {
        ISortedSetList<IResource> iSortedSetList = this.children;
        synchronized (iSortedSetList) {
            boolean bl = this.children.remove((Object)iResource);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.valueOf(bl ? "Removed child: " : "No child to remove: ") + iResource);
            }
        }
    }

    @Override
    public void removeContentChangeListener(IFileContentListener iFileContentListener) {
        this.removeListenerObject(iFileContentListener);
    }

    private IResource root() {
        IResource iResource = this;
        while (iResource.getParent() != null) {
            iResource = iResource.getParent();
        }
        return iResource;
    }

    @Override
    public boolean save(String string, InputStream inputStream, IProgressMonitor iProgressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExcluded(boolean bl) {
        this.setFlags((byte)2, bl);
    }

    @Override
    public void setFilters(List<IFolderFilter> list) {
        this.filters = list;
    }

    public void setListFieldMask(boolean bl) {
        this.setFlags((byte)4, bl);
    }

    @Override
    public void setSize(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Resource size cannot be a negative number; size=" + l);
        }
        this.size = l;
    }
}

