/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.resources;

import com.deltawalker.App;
import com.deltawalker.IStreamContentAccessor;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.InputStreamUtil;
import com.deltawalker.resources.FolderResource;
import com.deltawalker.resources.Resource;
import com.deltopia.io.ByteBuffer;
import com.deltopia.io.ByteSequenceInputStream;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.IByteSequence;
import com.deltopia.io.IFile;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import com.deltopia.io.IStreamProvider;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.UriInfoKey;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class FileResource
extends Resource
implements IStreamProvider,
IStreamContentAccessor {
    private static final byte[] buffer = new byte[65536];
    private static Point szImage;
    private ContentType cType;

    public static Point getImageSize() {
        if (szImage == null) {
            Rectangle rectangle = ImageCache.getImage(ImageConst.FILE).getBounds();
            szImage = new Point(rectangle.width, rectangle.height);
        }
        return szImage;
    }

    public FileResource(IFile iFile, FolderResource folderResource, ContentType contentType, boolean bl) {
        super(iFile, folderResource, bl);
        if (contentType == null) {
            throw new NullPointerException("cType");
        }
        this.cType = contentType;
    }

    @Override
    public ContentType contentType() throws IOException {
        if (this.cType.isUnknown()) {
            this.cType = App.instance().contentTypeBoss().detectType(this);
        }
        return this.cType;
    }

    public InputStream createInputStream(boolean bl) throws IOException {
        return this.file().createInputStream(bl);
    }

    public OutputStream createOutputStream(boolean bl) throws IOException {
        return this.file().createOutputStream(bl);
    }

    @Override
    public InputStream getContents() throws IOException {
        if (this.getParent() == null) {
            IByteSequence iByteSequence = this.load(null, null);
            return new ByteSequenceInputStream(iByteSequence);
        }
        return this.file().createInputStream(true);
    }

    @Override
    public String getExtension() {
        return FileUtil.getExtension((String)this.getName());
    }

    @Override
    public final Image getImage() {
        String string = this.getExtension();
        FileUtil.ProgramInfo programInfo = FileUtil.getImageFromExtension((String)string, (Point)FileResource.getImageSize());
        EnumSet<ImageCache.Type> enumSet = EnumSet.noneOf(ImageCache.Type.class);
        if (!this.file().isReadable()) {
            enumSet.add(ImageCache.Type.NO_PERMISSION);
        }
        if (this.file().isSymbolicLink()) {
            enumSet.add(ImageCache.Type.SYM_LINK);
        }
        if (programInfo != null) {
            return ImageCache.getProcessedImage(programInfo.image, string, enumSet);
        }
        return ImageCache.getProcessedImage(ImageConst.FILE, enumSet);
    }

    @Override
    public String getName() {
        return this.file().getName();
    }

    @Override
    public long getSize() {
        return this.file().size();
    }

    @Override
    public FileType getType() {
        return FileType.FILE;
    }

    @Override
    public IByteSequence load(String string, IProgressMonitor iProgressMonitor) throws IOException {
        int n;
        byte[] byArray;
        boolean bl;
        IFileSystem iFileSystem = IO.fileSystem();
        boolean bl2 = bl = iFileSystem.isReadSymbolicLinkSupported() && !this.followLinks() && this.isSymbolicLink();
        if (bl) {
            byArray = iFileSystem.readSymbolicLinkData(this.file().getPath());
            n = byArray.length;
        } else {
            byArray = null;
            n = (int)this.file().size();
        }
        int n2 = n;
        if (n2 <= 0 || n2 > 65536) {
            n2 = 65536;
        }
        if (n <= 0) {
            n = 0;
        }
        ByteBuffer byteBuffer = new ByteBuffer(n2, n);
        if (bl) {
            byteBuffer.append(byArray, 0, byArray.length);
            return byteBuffer;
        }
        InputStream inputStream = this.file().createInputStream(true);
        try {
            InputStreamUtil.readStream(inputStream, byteBuffer);
        }
        finally {
            StreamUtil.closeSilently((Closeable)inputStream);
        }
        return byteBuffer;
    }

    @Override
    public void renameTo(String string, Map<UriInfoKey, Object> map, boolean bl) throws IOException {
        this.file().renameTo(string, map, bl);
    }

    @Override
    public long resourceForkSize() {
        return this.file().resourceForkSize();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean save(String var1_1, InputStream var2_2, IProgressMonitor var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setSize(long l) {
        throw new UnsupportedOperationException("com.deltawalker.resources.FileResource#setSize");
    }
}

