/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.resources;

import com.deltawalker.IStructPropertyProvider;
import com.deltawalker.StructProperty;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.Resource;
import com.deltopia.eclipse.util.IPropertyChangeNotifier;
import com.deltopia.interfaces.IPrincipal;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResource
extends EventManager
implements IResource,
IPropertyChangeNotifier,
IStructPropertyProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(Resource.class);
    protected static final boolean LOG_DBG = LOG.isDebugEnabled();
    private static final List<StructProperty> PROPS = new LinkedList<StructProperty>();
    public static final List<StructProperty> umPROPS = Collections.unmodifiableList(PROPS);
    private final IResource parent;

    static {
        PROPS.add(StructProperty.NAME);
        PROPS.add(StructProperty.GROUP);
        PROPS.add(StructProperty.OWNER);
        PROPS.add(StructProperty.ATTRIBUTES);
        PROPS.add(StructProperty.DATE_OPENED);
        PROPS.add(StructProperty.DATE_CREATED);
        PROPS.add(StructProperty.DATE_MODIFIED);
        PROPS.add(StructProperty.SIZE);
    }

    protected AbstractResource() {
        this(null);
    }

    protected AbstractResource(IResource iResource) {
        this.parent = iResource;
    }

    @Override
    public void addPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        if (this == iSchedulingRule) {
            return true;
        }
        if (iSchedulingRule instanceof MultiRule) {
            MultiRule multiRule = (MultiRule)iSchedulingRule;
            ISchedulingRule[] iSchedulingRuleArray = multiRule.getChildren();
            int n = 0;
            while (n < iSchedulingRuleArray.length) {
                if (!this.contains(iSchedulingRuleArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (!(iSchedulingRule instanceof IResource)) {
            return false;
        }
        String string = ((IResource)iSchedulingRule).getPath();
        String string2 = this.getPath();
        return string.startsWith(string2);
    }

    public void dispose() {
    }

    @Override
    public IResource getParent() {
        return this.parent;
    }

    @Override
    public List<StructProperty> getProperties() {
        return umPROPS;
    }

    @Override
    public IResource getRoot() {
        IResource iResource = this;
        while (iResource.getParent() != null) {
            iResource = iResource.getParent();
        }
        return iResource;
    }

    @Override
    public Object getValue(StructProperty structProperty) {
        if (structProperty == null) {
            throw new NullPointerException("prop");
        }
        switch (structProperty) {
            case NAME: {
                return this.getName();
            }
            case SIZE: {
                return this.getSize();
            }
            case DATE_MODIFIED: {
                return this.getLastModifiedTime();
            }
            case DATE_CREATED: {
                return this.createdTime();
            }
            case DATE_OPENED: {
                return this.lastOpenedTime();
            }
            case ATTRIBUTES: {
                return this.attributes();
            }
            case OWNER: {
                IPrincipal iPrincipal = this.getOwner();
                return iPrincipal != null ? iPrincipal.getName() : "";
            }
            case GROUP: {
                IPrincipal iPrincipal = this.getGroup();
                return iPrincipal != null ? iPrincipal.getName() : "";
            }
            case RESOURCE_FORK_SIZE: {
                return this.resourceForkSize();
            }
        }
        throw new IllegalArgumentException("prop");
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        String string;
        if (!(iSchedulingRule instanceof IResource)) {
            return false;
        }
        String string2 = ((IResource)iSchedulingRule).getPath();
        boolean bl = string2.startsWith(string = this.getPath()) || string.startsWith(string2);
        return bl;
    }

    @Override
    public void removePropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    @Override
    public long resourceForkSize() {
        return 0L;
    }
}

