/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing.dialogs;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IPrintBoss;
import com.deltawalker.script.MarginUnit;
import com.deltawalker.ui.printing.PageSetup;
import com.deltawalker.ui.printing.PrinterUtil;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PageSetupPreview
extends Composite {
    private Color clrBg;
    private Color clrBorder;
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!PageSetupPreview.this.isDisposed()) {
                PageSetupPreview.this.propertyChange(propertyChangeEvent.getProperty());
            }
        }
    };
    private Canvas page;
    private Point pageDpi;
    private Point pageSize;
    IPrintBoss printBoss = App.instance().printBoss();

    public PageSetupPreview(Composite composite, int n) {
        super(composite, n);
        Display display = this.getDisplay();
        this.clrBg = new Color((Device)display, 255, 255, 255);
        this.clrBorder = new Color((Device)display, 0, 0, 0);
        this.page = new Canvas((Composite)this, 0x20000000);
        this.page.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                PageSetupPreview.this.paintPage(event.gc);
            }
        });
        this.setLayout(new Layout(){
            private static final int DEFAULT_HEIGHT = 64;

            protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
                float f = 0.75f;
                if (PageSetupPreview.this.pageSize != null && ((PageSetupPreview)PageSetupPreview.this).pageSize.y != 0) {
                    f = (float)((PageSetupPreview)PageSetupPreview.this).pageSize.x / (float)((PageSetupPreview)PageSetupPreview.this).pageSize.y;
                }
                int n3 = n2 == -1 ? 64 : n2;
                int n4 = (int)Math.floor((float)n3 * f);
                Point point = new Point(n4, n3);
                if (PageSetupPreview.this.printBoss.getPageSetup().getOrientation() == 2) {
                    point.x = n3;
                    point.y = n4;
                }
                return point;
            }

            protected void layout(Composite composite, boolean bl) {
                ((PageSetupPreview)composite).layoutPage(this.computeSize(composite, -1, -1, bl));
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                PageSetupPreview.this.handleDispose();
            }
        });
        PrefUtil.getGlobalPrefs().addPropertyChangeListener(this.onProp);
        this.initializeFromPageSetup();
    }

    protected Canvas getPage() {
        return this.page;
    }

    protected void handleDispose() {
        PrefUtil.getGlobalPrefs().removePropertyChangeListener(this.onProp);
        if (this.clrBg != null) {
            this.clrBg.dispose();
            this.clrBg = null;
        }
        if (this.clrBorder != null) {
            this.clrBorder.dispose();
            this.clrBorder = null;
        }
    }

    private void initializeFromPageSetup() {
        this.propertyChange(null);
    }

    protected void layoutPage(Point point) {
        int n;
        Rectangle rectangle = this.getClientArea();
        int n2 = Math.min(rectangle.width, rectangle.height);
        if (n2 != (n = Math.max(point.x, point.y))) {
            double d = Math.floor((float)n2 / (float)n);
            point.x = (int)((double)point.x * d);
            point.y = (int)((double)point.y * d);
        }
        Rectangle rectangle2 = new Rectangle(0, 0, point.x, point.y);
        rectangle2.x = (rectangle.width - rectangle2.width) / 2;
        rectangle2.y = (rectangle.height - rectangle2.height) / 2;
        this.page.setBounds(rectangle2);
    }

    private void paintPage(GC gC) {
        Point point;
        Rectangle rectangle = this.getPage().getClientArea();
        gC.setBackground(this.clrBg);
        gC.fillRectangle(rectangle);
        PageSetup pageSetup = this.printBoss.getPageSetup();
        int n = this.printBoss.getPageSetup().getOrientation();
        float f = pageSetup.getMarginTop();
        float f2 = pageSetup.getMarginLeft();
        float f3 = pageSetup.getMarginRight();
        float f4 = pageSetup.getMarginBottom();
        MarginUnit marginUnit = pageSetup.getMarginUnits();
        Point point2 = this.pageSize;
        if (point2 == null) {
            point2 = new Point(900, 1200);
        }
        if (n == 2) {
            point2 = new Point(point2.y, point2.x);
        }
        if ((point = this.pageDpi) == null) {
            point = this.getDisplay().getDPI();
        }
        float f5 = point.x * rectangle.width / point2.x;
        float f6 = point.y * rectangle.height / point2.y;
        int n2 = rectangle.y + (int)Math.floor(PrinterUtil.getInches(f, marginUnit) * f6);
        int n3 = rectangle.x + (int)Math.floor(PrinterUtil.getInches(f2, marginUnit) * f5);
        int n4 = rectangle.x + rectangle.width - (int)Math.floor(PrinterUtil.getInches(f3, marginUnit) * f5);
        int n5 = rectangle.y + rectangle.height - (int)Math.floor(PrinterUtil.getInches(f4, marginUnit) * f6);
        this.paintPage(gC, n2, n3, n5, n4);
        gC.setForeground(this.clrBorder);
        gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    protected void paintPage(GC gC, int n, int n2, int n3, int n4) {
    }

    protected void propertyChange(String string) {
        if (string == null || string.equals(PrefKey.P_ORIENTATION.toString())) {
            this.layout();
        }
        if (string == null || string.equals(PrefKey.P_MARGIN_LEFT.toString()) || string.equals(PrefKey.P_MARGIN_RIGHT.toString()) || string.equals(PrefKey.P_MARGIN_TOP.toString()) || string.equals(PrefKey.P_MARGIN_BOTTOM.toString()) || string.equals(PrefKey.P_MARGIN_UNIT.toString())) {
            this.page.redraw();
        }
    }

    public void setPageSetup(PageSetup pageSetup) {
        this.initializeFromPageSetup();
    }
}

