/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing.dialogs;

import com.deltawalker.App;
import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IPrintBoss;
import com.deltawalker.internal.ContextId;
import com.deltawalker.internal.ui.TagEntry;
import com.deltawalker.internal.ui.printing.dialogs.HeaderFooterPreview;
import com.deltawalker.internal.ui.printing.dialogs.PageMiniPreview;
import com.deltawalker.script.MarginUnit;
import com.deltawalker.script.Role;
import com.deltawalker.ui.ButtonFactory;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.printing.PageSetup;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class PageSetupDialog
extends TrayDialog {
    public static final String _PREFIX = PageSetupDialog.class.getName();
    private static final String HDR_FTR_COMBO_HINT = UIMsg.PageSetupDlg_typeText;
    public static final Map<Role, String> NAME_TAGS = new EnumMap<Role, String>(Role.class);
    public static final Map<Role, String> PATH_TAGS = new EnumMap<Role, String>(Role.class);
    private static final int SPINNER_DIGITS = 2;
    private static final int SPINNER_MAXIMUM = 1000;
    public static final String TAB_SELECTION = String.valueOf(_PREFIX) + ".tabSelection";
    public static final String TAG_DATE_TIME = "<DateTime/>";
    public static final String TAG_NAME_0 = "<AncestorFile/>";
    public static final String TAG_NAME_1 = "<FirstFile/>";
    public static final String TAG_NAME_2 = "<SecondFile/>";
    public static final String TAG_PAGE_COUNT = "<PageCount/>";
    public static final String TAG_PAGE_NUM = "<PageNumber/>";
    public static final String TAG_PATH_0 = "<AncestorPath/>";
    public static final String TAG_PATH_1 = "<FirstPath/>";
    public static final String TAG_PATH_2 = "<SecondPath/>";
    public static final List<String> TAGS_ALL = new LinkedList<String>();
    public static final List<String> TAGS_FTR = new LinkedList<String>();
    public static final List<String> TAGS_HDR = new LinkedList<String>();
    private static Map<String, String> TEMPL_2_TEXT_FTR = new LinkedHashMap<String, String>();
    private static Map<String, String> TEMPL_2_TEXT_HDR = new LinkedHashMap<String, String>();
    private static Map<String, String> TEMPL_2_TEXT_HDR_0 = new LinkedHashMap<String, String>();
    private static Map<String, String> TEMPL_2_TEXT_HDR_1 = new LinkedHashMap<String, String>();
    private static Map<String, String> TEMPL_2_TEXT_HDR_2 = new LinkedHashMap<String, String>();
    public static final String TEMPL_DATE_TIME = "<DateTime/>";
    public static final String TEMPL_PG_NUM = NLS.bind((String)UIMsg.PageSetupDlg_pgNum, (Object)"<PageNumber/>");
    public static final String TEMPL_PG_NUM_OF_COUNT = NLS.bind((String)Msg.Common_pageNumberOf, (Object)"<PageNumber/>", (Object)"<PageCount/>");
    private Button btnFooter;
    private Button btnHeader;
    private Button btnLandscape;
    private Button btnPortrait;
    private Button btnUnitCm;
    private Button btnUnitInch;
    private final ButtonFactory buttonFactory;
    private Composite cmpFooter;
    private Composite cmpHeader;
    private Font fontPreview;
    private HeaderFooterPreview ftrPreview;
    private HeaderFooterPreview hdrPreview;
    private PageMiniPreview miniPreview;
    private final FocusListener onFocus = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            TagEntry tagEntry = (TagEntry)focusEvent.widget;
            if (tagEntry.getText().equals(HDR_FTR_COMBO_HINT)) {
                tagEntry.setText("");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            TagEntry tagEntry = (TagEntry)focusEvent.widget;
            if (StringUtil.isEmpty((String)tagEntry.getText())) {
                tagEntry.setText(HDR_FTR_COMBO_HINT);
            }
        }
    };
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PageSetupDialog.this.handlePropertyChange(propertyChangeEvent.getProperty());
        }
    };
    private IPrintBoss printBoss = App.instance().printBoss();
    private Spinner spnBottom;
    private Spinner spnLeft;
    private Spinner spnRight;
    private Spinner spnTop;
    private TabFolder tabFolder;
    private TagEntry teFtrCenter;
    private TagEntry teFtrLeft;
    private TagEntry teFtrRight;
    private TagEntry teHdrCenter;
    private TagEntry teHdrLeft;
    private TagEntry teHdrRight;

    static {
        TAGS_HDR.add(TAG_NAME_0);
        TAGS_HDR.add(TAG_NAME_1);
        TAGS_HDR.add(TAG_NAME_2);
        TAGS_HDR.add(TAG_PATH_0);
        TAGS_HDR.add(TAG_PATH_1);
        TAGS_HDR.add(TAG_PATH_2);
        TAGS_FTR.add("<DateTime/>");
        TAGS_FTR.add(TAG_PAGE_NUM);
        TAGS_FTR.add(TAG_PAGE_COUNT);
        TAGS_ALL.addAll(TAGS_HDR);
        TAGS_ALL.addAll(TAGS_FTR);
        NAME_TAGS.put(Role.REF, TAG_NAME_0);
        NAME_TAGS.put(Role.ONE, TAG_NAME_1);
        NAME_TAGS.put(Role.TWO, TAG_NAME_2);
        PATH_TAGS.put(Role.REF, TAG_PATH_0);
        PATH_TAGS.put(Role.ONE, TAG_PATH_1);
        PATH_TAGS.put(Role.TWO, TAG_PATH_2);
        TEMPL_2_TEXT_HDR_0.put(TAG_NAME_0, UIMsg.PageSetupDlg_tagName);
        TEMPL_2_TEXT_HDR_0.put(TAG_PATH_0, UIMsg.PageSetupDlg_tagPath);
        TEMPL_2_TEXT_HDR_1.put(TAG_NAME_1, UIMsg.PageSetupDlg_tagName);
        TEMPL_2_TEXT_HDR_1.put(TAG_PATH_1, UIMsg.PageSetupDlg_tagPath);
        TEMPL_2_TEXT_HDR_2.put(TAG_NAME_2, UIMsg.PageSetupDlg_tagName);
        TEMPL_2_TEXT_HDR_2.put(TAG_PATH_2, UIMsg.PageSetupDlg_tagPath);
        TEMPL_2_TEXT_HDR.putAll(TEMPL_2_TEXT_HDR_0);
        TEMPL_2_TEXT_HDR.putAll(TEMPL_2_TEXT_HDR_1);
        TEMPL_2_TEXT_HDR.putAll(TEMPL_2_TEXT_HDR_2);
        TEMPL_2_TEXT_FTR.put("<DateTime/>", UIMsg.PageSetupDlg_tagDateTime);
        TEMPL_2_TEXT_FTR.put(TEMPL_PG_NUM, UIMsg.PageSetupDlg_tagPgNum);
        TEMPL_2_TEXT_FTR.put(TEMPL_PG_NUM_OF_COUNT, UIMsg.PageSetupDlg_tagPgNumOfCount);
    }

    public static String templateFromText(Map<String, String> map, String string, String string2, boolean bl) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return string2;
    }

    private static Map<String, String> templates(PrefKey prefKey) {
        switch (prefKey) {
            case P_HEADER_LEFT: {
                return TEMPL_2_TEXT_HDR_1;
            }
            case P_HEADER_CENTER: {
                return TEMPL_2_TEXT_HDR_0;
            }
            case P_HEADER_RIGHT: {
                return TEMPL_2_TEXT_HDR_2;
            }
            case P_FOOTER_CENTER: 
            case P_FOOTER_LEFT: 
            case P_FOOTER_RIGHT: {
                return TEMPL_2_TEXT_FTR;
            }
        }
        throw new IllegalArgumentException("prefKey");
    }

    public static String textFromTemplate(String string, String string2, boolean bl) {
        Map<String, String> map = bl ? TEMPL_2_TEXT_HDR : TEMPL_2_TEXT_FTR;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().equals(string)) continue;
            return entry.getValue();
        }
        return string2;
    }

    public PageSetupDialog(IShellProvider iShellProvider, final IAction iAction, final IAction iAction2) {
        super(iShellProvider);
        this.buttonFactory = new ButtonFactory(){

            @Override
            protected IAction createButtonAction(int n) {
                switch (n) {
                    case 4: {
                        return iAction;
                    }
                    case 8: {
                        return iAction2;
                    }
                }
                throw new IllegalArgumentException("id");
            }
        };
        PrefUtil.getGlobalPrefs().addPropertyChangeListener(this.onProp);
    }

    public boolean close() {
        boolean bl = super.close();
        if (bl) {
            PrefUtil.getGlobalPrefs().removePropertyChangeListener(this.onProp);
            if (this.fontPreview != null) {
                this.fontPreview.dispose();
                this.fontPreview = null;
            }
        }
        return bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UIUtil.setHelpContextId((Control)shell, ContextId.PAGE_SETUP_DIALOG);
        shell.setText(Msg.Common_pageSetup);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        Button button;
        composite.setLayoutData((Object)new GridData(768));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PageSetupDialog.this.handleButtonSelection(event);
            }
        };
        Button button2 = this.buttonFactory.createButton(composite, 8, UIMsg.PageSetupDlg_printPreview, false);
        if (button2 != null) {
            this.setButtonLayoutData(button2);
            button2.addListener(13, listener);
        }
        if ((button = this.buttonFactory.createButton(composite, 4, Msg.Common_print, false)) != null) {
            this.setButtonLayoutData(button);
            button.addListener(13, listener);
        }
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(composite);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.tabFolder = new TabFolder(composite2, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPageTabItem(this.tabFolder);
        this.createHeaderFooterTabItem(this.tabFolder);
        this.tabFolder.setSelection(PrefUtil.getGlobalPrefs().getInt(TAB_SELECTION));
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrefUtil.getGlobalPrefs().setValue(TAB_SELECTION, PageSetupDialog.this.tabFolder.getSelectionIndex());
            }
        });
        this.initialize();
        PageSetupDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createHeaderFooterTabItem(TabFolder tabFolder) {
        FontData fontData;
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PageSetup pageSetup = PageSetupDialog.this.printBoss.getPageSetup();
                if (event.widget == PageSetupDialog.this.btnHeader) {
                    pageSetup.setPrintHeader(!pageSetup.getPrintHeader());
                } else if (event.widget == PageSetupDialog.this.btnFooter) {
                    pageSetup.setPrintFooter(!pageSetup.getPrintFooter());
                }
            }
        };
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnHeader = new Button(composite3, 32);
        this.btnHeader.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnHeader.setSelection(true);
        this.btnHeader.setText(UIMsg.PageSetupDlg_header);
        this.btnHeader.addListener(13, listener);
        Label label = new Label(composite3, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.cmpHeader = new Composite(composite2, 0);
        this.cmpHeader.setLayout((Layout)gridLayout);
        this.cmpHeader.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2 * this.convertHorizontalDLUsToPixels(4);
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        Composite composite4 = new Composite(this.cmpHeader, 0);
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(4, 1, true, false));
        Label label2 = new Label(composite4, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(UIMsg.PageSetupDlg_left);
        label2 = new Label(composite4, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(UIMsg.PageSetupDlg_center);
        label2 = new Label(composite4, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(UIMsg.PageSetupDlg_right);
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                String string = ((TagEntry)event.widget).getText();
                PrefKey prefKey = (PrefKey)((Object)event.widget.getData());
                string = string.equals(HDR_FTR_COMBO_HINT) ? null : PageSetupDialog.templateFromText(PageSetupDialog.templates(prefKey), string, string, true);
                String string2 = ((PrefKey)((Object)event.widget.getData())).toString();
                PageSetupDialog.this.printBoss.getPageSetup().setHeader(string2, string);
            }
        };
        this.teHdrLeft = this.createTagEntry(composite4, PrefKey.P_HEADER_LEFT, listener2);
        this.teHdrCenter = this.createTagEntry(composite4, PrefKey.P_HEADER_CENTER, listener2);
        this.teHdrRight = this.createTagEntry(composite4, PrefKey.P_HEADER_RIGHT, listener2);
        List<TagEntry> list = Arrays.asList(this.teHdrLeft, this.teHdrCenter, this.teHdrRight);
        this.teHdrLeft.setSiblings(list);
        this.teHdrCenter.setSiblings(list);
        this.teHdrRight.setSiblings(list);
        Font font = JFaceResources.getFont((String)"com.deltawalker.ui.editorFont");
        if (font != null) {
            fontData = font.getFontData()[0];
            this.fontPreview = new Font((Device)composite.getDisplay(), fontData.getName(), fontData.getHeight() - 1, fontData.getStyle());
        }
        this.hdrPreview = new HeaderFooterPreview(this.cmpHeader, 0, 4);
        this.hdrPreview.setFont(this.fontPreview);
        this.hdrPreview.setLayoutData(new GridData(4, 4, true, true));
        fontData = new GridLayout();
        fontData.marginHeight = 0;
        fontData.marginWidth = 0;
        fontData.numColumns = 1;
        Composite composite5 = new Composite(composite, 0);
        composite5.setLayout((Layout)fontData);
        composite5.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        gridLayout3.numColumns = 2;
        Composite composite6 = new Composite(composite5, 0);
        composite6.setLayout((Layout)gridLayout3);
        composite6.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnFooter = new Button(composite6, 32);
        this.btnFooter.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnFooter.setSelection(true);
        this.btnFooter.setText(UIMsg.PageSetupDlg_footer);
        this.btnFooter.addListener(13, listener);
        Label label3 = new Label(composite6, 258);
        label3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.marginHeight = 0;
        gridLayout4.marginWidth = 0;
        gridLayout4.numColumns = 1;
        this.cmpFooter = new Composite(composite5, 0);
        this.cmpFooter.setLayout((Layout)gridLayout4);
        this.cmpFooter.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2 * this.convertHorizontalDLUsToPixels(4);
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        Composite composite7 = new Composite(this.cmpFooter, 0);
        composite7.setLayout((Layout)gridLayout);
        composite7.setLayoutData((Object)new GridData(4, 1, true, false));
        label2 = new Label(composite7, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(UIMsg.PageSetupDlg_left);
        label2 = new Label(composite7, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(UIMsg.PageSetupDlg_center);
        label2 = new Label(composite7, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setText(UIMsg.PageSetupDlg_right);
        Listener listener3 = new Listener(){

            public void handleEvent(Event event) {
                String string = ((TagEntry)event.widget).getText();
                string = string.equals(HDR_FTR_COMBO_HINT) ? "" : PageSetupDialog.templateFromText(TEMPL_2_TEXT_FTR, string, string, false);
                String string2 = ((PrefKey)((Object)event.widget.getData())).toString();
                PageSetupDialog.this.printBoss.getPageSetup().setFooter(string2, string);
            }
        };
        this.teFtrLeft = this.createTagEntry(composite7, PrefKey.P_FOOTER_LEFT, listener3);
        this.teFtrCenter = this.createTagEntry(composite7, PrefKey.P_FOOTER_CENTER, listener3);
        this.teFtrRight = this.createTagEntry(composite7, PrefKey.P_FOOTER_RIGHT, listener3);
        this.ftrPreview = new HeaderFooterPreview(this.cmpFooter, 0, 2);
        this.ftrPreview.setFont(this.hdrPreview.getFont());
        this.ftrPreview.setLayoutData(new GridData(4, 4, true, true));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setControl((Control)composite);
        tabItem.setText(UIMsg.PageSetupDlg_headerFooter);
    }

    private void createPageTabItem(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(4, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(UIMsg.PageSetupDlg_orientation);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PageSetupDialog.this.handlePageTabItemEvent(event);
            }
        };
        this.btnPortrait = new Button((Composite)group, 16);
        this.btnPortrait.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnPortrait.setText(UIMsg.PageSetupDlg_portrait);
        this.btnPortrait.addListener(13, listener);
        this.btnLandscape = new Button((Composite)group, 16);
        this.btnLandscape.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnLandscape.setText(UIMsg.PageSetupDlg_landscape);
        this.btnLandscape.addListener(13, listener);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        Group group2 = new Group(composite, 0);
        group2.setLayout((Layout)new GridLayout(1, false));
        group2.setLayoutData((Object)gridData);
        group2.setText(UIMsg.PageSetupDlg_preview);
        this.miniPreview = new PageMiniPreview((Composite)group2, 0);
        this.miniPreview.setLayoutData(new GridData(4, 4, true, true));
        Group group3 = new Group(composite, 0);
        group3.setLayout((Layout)new GridLayout(1, false));
        group3.setLayoutData((Object)new GridData(4, 4, true, true));
        group3.setText(UIMsg.PageSetupDlg_margins);
        Composite composite2 = new Composite((Composite)group3, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, false, false));
        Label label = new Label(composite2, 0);
        this.spnLeft = new Spinner(composite2, 2048);
        this.initializeMarginWidget(label, UIMsg.PageSetupDlg_left, this.spnLeft, PrefKey.P_MARGIN_LEFT.toString(), listener);
        Label label2 = new Label(composite2, 0);
        this.spnRight = new Spinner(composite2, 2048);
        this.initializeMarginWidget(label2, UIMsg.PageSetupDlg_right, this.spnRight, PrefKey.P_MARGIN_RIGHT.toString(), listener);
        Label label3 = new Label(composite2, 0);
        this.spnTop = new Spinner(composite2, 2048);
        this.initializeMarginWidget(label3, UIMsg.PageSetupDlg_top, this.spnTop, PrefKey.P_MARGIN_TOP.toString(), listener);
        Label label4 = new Label(composite2, 0);
        this.spnBottom = new Spinner(composite2, 2048);
        this.initializeMarginWidget(label4, UIMsg.PageSetupDlg_bottom, this.spnBottom, PrefKey.P_MARGIN_BOTTOM.toString(), listener);
        Composite composite3 = new Composite((Composite)group3, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnUnitInch = new Button(composite3, 16);
        this.btnUnitInch.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnUnitInch.setSelection(true);
        this.btnUnitInch.setText(UIMsg.PageSetupDlg_inches);
        this.btnUnitInch.addListener(13, listener);
        this.btnUnitCm = new Button(composite3, 16);
        this.btnUnitCm.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnUnitCm.setText(UIMsg.PageSetupDlg_centimeters);
        this.btnUnitCm.addListener(13, listener);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setControl((Control)composite);
        tabItem.setText(Msg.Common_page);
    }

    private TagEntry createTagEntry(Composite composite, PrefKey prefKey, Listener listener) {
        boolean bl = this.isHeaderKey(prefKey);
        TagEntry tagEntry = new TagEntry(composite, 2048, bl);
        tagEntry.setData((Object)prefKey);
        tagEntry.setLayoutData(new GridData(4, 4, true, false));
        List<String> list = bl ? TAGS_HDR : TAGS_FTR;
        tagEntry.setTags(list);
        Collection<String> collection = PageSetupDialog.templates(prefKey).values();
        tagEntry.setTemplates(collection);
        tagEntry.addListener(24, listener);
        tagEntry.addFocusListener(this.onFocus);
        return tagEntry;
    }

    private float getSelection(Spinner spinner) {
        int n = 1;
        int n2 = spinner.getDigits() - 1;
        while (n2 >= 0) {
            n *= 10;
            --n2;
        }
        return (float)spinner.getSelection() / (float)n;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void handleButtonSelection(Event event) {
        Button button = (Button)event.widget;
        IAction iAction = this.buttonFactory.getButtonAction(button);
        Button button2 = this.getButton(0);
        if (button2 != null) {
            button2.notifyListeners(13, null);
        }
        if (iAction != null && iAction.isEnabled()) {
            iAction.run();
        }
    }

    private void handlePageTabItemEvent(Event event) {
        Button button;
        Widget widget = event.widget;
        if (widget == null || widget.isDisposed()) {
            return;
        }
        PageSetup pageSetup = this.printBoss.getPageSetup();
        if (widget == this.btnLandscape || widget == this.btnPortrait) {
            Button button2 = (Button)widget;
            if (button2.getSelection()) {
                pageSetup.setOrientation(this.btnLandscape.getSelection() ? 2 : 1);
            }
        } else if (widget == this.spnBottom || widget == this.spnLeft || widget == this.spnRight || widget == this.spnTop) {
            Spinner spinner = (Spinner)widget;
            pageSetup.setMargin((String)spinner.getData(), this.getSelection(spinner));
        } else if ((widget == this.btnUnitCm || widget == this.btnUnitInch) && (button = (Button)event.widget).getSelection()) {
            pageSetup.setMarginUnits(button == this.btnUnitCm ? MarginUnit.CENTIMETER : MarginUnit.INCH);
        }
    }

    private void handlePropertyChange(String string) {
        boolean bl;
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        PageSetup pageSetup = this.printBoss.getPageSetup();
        if (string == null || string.equals(PrefKey.P_ORIENTATION.toString())) {
            boolean bl2 = bl = 2 == pageSetup.getOrientation();
            if (this.btnPortrait != null && !this.btnPortrait.isDisposed()) {
                this.btnPortrait.setSelection(!bl);
            }
            if (this.btnLandscape != null && !this.btnLandscape.isDisposed()) {
                this.btnLandscape.setSelection(bl);
            }
        }
        if (string == null || string.equals(PrefKey.P_MARGIN_TOP.toString())) {
            this.setSelection(this.spnTop, pageSetup.getMarginTop());
        }
        if (string == null || string.equals(PrefKey.P_MARGIN_LEFT.toString())) {
            this.setSelection(this.spnLeft, pageSetup.getMarginLeft());
        }
        if (string == null || string.equals(PrefKey.P_MARGIN_BOTTOM.toString())) {
            this.setSelection(this.spnBottom, pageSetup.getMarginBottom());
        }
        if (string == null || string.equals(PrefKey.P_MARGIN_RIGHT.toString())) {
            this.setSelection(this.spnRight, pageSetup.getMarginRight());
        }
        if (string == null || string.equals(PrefKey.P_MARGIN_UNIT.toString())) {
            boolean bl3 = bl = pageSetup.getMarginUnits() == MarginUnit.CENTIMETER;
            if (this.btnUnitInch != null && !this.btnUnitInch.isDisposed()) {
                this.btnUnitInch.setSelection(!bl);
            }
            if (this.btnUnitCm != null && !this.btnUnitCm.isDisposed()) {
                this.btnUnitCm.setSelection(bl);
            }
        }
        if (string == null || string.equals(PrefKey.P_PRINT_HEADER.toString())) {
            bl = pageSetup.getPrintHeader();
            if (this.btnHeader != null && !this.btnHeader.isDisposed()) {
                this.btnHeader.setSelection(bl);
            }
            this.setEnabled((Control)this.cmpHeader, bl);
        }
        if (string == null || string.equals(PrefKey.P_PRINT_FOOTER.toString())) {
            bl = pageSetup.getPrintFooter();
            if (this.btnFooter != null && !this.btnFooter.isDisposed()) {
                this.btnFooter.setSelection(bl);
            }
            this.setEnabled((Control)this.cmpFooter, bl);
        }
        if (string == null || string.equals(PrefKey.P_HEADER_LEFT.toString())) {
            this.setText(this.teHdrLeft, pageSetup.getHeaderLeft(), true);
        }
        if (string == null || string.equals(PrefKey.P_HEADER_CENTER.toString())) {
            this.setText(this.teHdrCenter, pageSetup.getHeaderCenter(), true);
        }
        if (string == null || string.equals(PrefKey.P_HEADER_RIGHT.toString())) {
            this.setText(this.teHdrRight, pageSetup.getHeaderRight(), true);
        }
        if (string == null || string.equals(PrefKey.P_FOOTER_LEFT.toString())) {
            this.setText(this.teFtrLeft, pageSetup.getFooterLeft(), false);
        }
        if (string == null || string.equals(PrefKey.P_FOOTER_CENTER.toString())) {
            this.setText(this.teFtrCenter, pageSetup.getFooterCenter(), false);
        }
        if (string == null || string.equals(PrefKey.P_FOOTER_RIGHT.toString())) {
            this.setText(this.teFtrRight, pageSetup.getFooterRight(), false);
        }
    }

    protected void helpPressed() {
        String string;
        int n = this.tabFolder.getSelectionIndex();
        switch (n) {
            case 0: {
                string = "page-setup-margins";
                break;
            }
            case 1: {
                string = "page-setup-header-footer";
                break;
            }
            default: {
                assert (false);
                string = "page-setup-margins";
            }
        }
        UIUtil.showHelp(string, UIUtil.HelpContext.DIALOG);
    }

    private void initialize() {
        PageSetup pageSetup = this.printBoss.getPageSetup();
        if (this.miniPreview != null && !this.miniPreview.isDisposed()) {
            this.miniPreview.setPageSetup(pageSetup);
        }
        if (this.hdrPreview != null && !this.hdrPreview.isDisposed()) {
            this.hdrPreview.setPageSetup(pageSetup);
        }
        if (this.ftrPreview != null && !this.ftrPreview.isDisposed()) {
            this.ftrPreview.setPageSetup(pageSetup);
        }
        this.handlePropertyChange(null);
    }

    private void initializeMarginWidget(Label label, String string, Spinner spinner, String string2, Listener listener) {
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label.setText(string);
        spinner.setData((Object)string2);
        spinner.setDigits(2);
        spinner.setLayoutData((Object)new GridData(4, 4, true, false));
        spinner.setMaximum(1000);
        spinner.addListener(13, listener);
    }

    private boolean isHeaderKey(PrefKey prefKey) {
        if (prefKey == PrefKey.P_HEADER_LEFT || prefKey == PrefKey.P_HEADER_CENTER || prefKey == PrefKey.P_HEADER_RIGHT) {
            return true;
        }
        if (prefKey == PrefKey.P_FOOTER_LEFT || prefKey == PrefKey.P_FOOTER_CENTER || prefKey == PrefKey.P_FOOTER_RIGHT) {
            return false;
        }
        assert (false);
        return false;
    }

    public int open() {
        this.setShellStyle(this.getShellStyle());
        this.initialize();
        return super.open();
    }

    private void setEnabled(Control control, boolean bl) {
        if (control != null && !control.isDisposed()) {
            control.setEnabled(bl);
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length - 1;
                while (n >= 0) {
                    Control control2 = controlArray[n];
                    if (control2 != null && !control2.isDisposed()) {
                        this.setEnabled(control2, bl);
                    }
                    --n;
                }
            }
        }
    }

    private void setSelection(Spinner spinner, float f) {
        if (spinner != null && !spinner.isDisposed()) {
            int n = spinner.getDigits() - 1;
            while (n >= 0) {
                f *= 10.0f;
                --n;
            }
            spinner.setSelection(Math.round(f));
        }
    }

    private void setText(TagEntry tagEntry, String string, boolean bl) {
        if (tagEntry != null && !tagEntry.isDisposed()) {
            if (StringUtil.isEmpty((String)(string = PageSetupDialog.textFromTemplate(string, string, bl))) && !tagEntry.isFocusControl()) {
                string = HDR_FTR_COMBO_HINT;
            }
            if (!ObjectUtil.areEqual((Object)string, (Object)tagEntry.getText())) {
                tagEntry.setText(StringUtil.makeSafe((String)string));
            }
        }
    }
}

