/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing.dialogs;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.internal.ui.printing.dialogs.PageSetupDialog;
import com.deltawalker.internal.ui.printing.dialogs.PageSetupPreview;
import com.deltopia.StringUtil;
import java.util.Date;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class HeaderFooterPreview
extends PageSetupPreview {
    public static final int FOOTER = 2;
    public static final int HEADER = 4;
    private static final int MARGIN_HEIGHT = 10;
    private static final int MARGIN_WIDTH = 10;
    private Image image;
    private int what;

    public HeaderFooterPreview(Composite composite, int n, int n2) {
        super(composite, n);
        if ((n2 & 0xFFFFFFF9) != 0) {
            throw new IllegalArgumentException();
        }
        this.what = n2;
    }

    private TextLayout createTextLayout(String string, int n, int n2) {
        TextLayout textLayout = new TextLayout((Device)this.getDisplay());
        textLayout.setAlignment(n2);
        textLayout.setFont(this.getFont());
        textLayout.setText(string);
        textLayout.setWidth(n);
        return textLayout;
    }

    private void drawText(GC gC, String string, int n, int n2, int n3, int n4, int n5) {
        if (string == null || "".equals(string)) {
            return;
        }
        TextLayout textLayout = this.createTextLayout(string, n3 == -1 || n4 != -1 ? -1 : n3, n5);
        Rectangle rectangle = null;
        try {
            if (n3 != -1 && n4 != -1) {
                rectangle = gC.getClipping();
                gC.setClipping(n, n2, n3, n4);
            }
            textLayout.draw(gC, n, n2);
        }
        catch (Throwable throwable) {
            if (rectangle != null) {
                gC.setClipping(rectangle);
            }
            textLayout.dispose();
            throw throwable;
        }
        if (rectangle != null) {
            gC.setClipping(rectangle);
        }
        textLayout.dispose();
    }

    private String expandTags(String string, boolean bl) {
        if (!string.isEmpty()) {
            string = StringUtil.replace((String)string, (String)"<DateTime/>", (String)new Date().toString());
            string = StringUtil.replace((String)string, (String)"<PageCount/>", (String)Integer.toString(1));
            string = StringUtil.replace((String)string, (String)"<PageNumber/>", (String)Integer.toString(1));
            string = PageSetupDialog.textFromTemplate(string, string, bl);
        }
        return string;
    }

    private String getFooter(PrefKey prefKey) {
        String string = App.instance().printBoss().getPageSetup().getFooter(prefKey);
        return this.expandTags(string, false);
    }

    private String getHeader(PrefKey prefKey) {
        String string = App.instance().printBoss().getPageSetup().getHeader(prefKey, null);
        return this.expandTags(string, true);
    }

    private Rectangle getPageVisibleArea() {
        Canvas canvas = this.getPage();
        Rectangle rectangle = this.getClientArea();
        Point point = canvas.toControl(this.toDisplay(rectangle.x, rectangle.y));
        return canvas.getClientArea().intersection(new Rectangle(point.x, point.y, rectangle.width, rectangle.height));
    }

    @Override
    protected void layoutPage(Point point) {
        Rectangle rectangle = this.getClientArea();
        float f = 1.0f;
        if (point.x != 0) {
            f = (float)point.y / (float)point.x;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, 0, rectangle.width, Math.round((float)rectangle.width * f));
        rectangle2.y = (this.what & 2) == 2 ? rectangle.y + rectangle.height - rectangle2.height : rectangle.y;
        this.getPage().setBounds(rectangle2);
    }

    private void paintHeaderFooter(GC gC) {
        int n;
        String string;
        String string2;
        String string3;
        Rectangle rectangle = this.image.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x + 10, rectangle.y + 10, rectangle.width - 20, rectangle.height - 20);
        if ((this.what & 4) == 4) {
            string3 = this.getHeader(PrefKey.P_HEADER_LEFT);
            string2 = this.getHeader(PrefKey.P_HEADER_CENTER);
            string = this.getHeader(PrefKey.P_HEADER_RIGHT);
            n = rectangle2.y;
            this.drawText(gC, string3, rectangle2.x, n, rectangle2.width, -1, 16384);
            this.drawText(gC, string2, rectangle2.x, n, rectangle2.width, -1, 0x1000000);
            this.drawText(gC, string, rectangle2.x, n, rectangle2.width, -1, 131072);
        }
        if ((this.what & 2) == 2) {
            string3 = this.getFooter(PrefKey.P_FOOTER_LEFT);
            string2 = this.getFooter(PrefKey.P_FOOTER_CENTER);
            string = this.getFooter(PrefKey.P_FOOTER_RIGHT);
            n = Math.max(Math.max(this.textExtent((String)string3, (int)rectangle2.width, (int)16384).y, this.textExtent((String)string2, (int)rectangle2.width, (int)0x1000000).y), this.textExtent((String)string, (int)rectangle2.width, (int)131072).y);
            int n2 = rectangle2.y + rectangle2.height - n;
            this.drawText(gC, string3, rectangle2.x, n2, rectangle2.width, -1, 16384);
            this.drawText(gC, string2, rectangle2.x, n2, rectangle2.width, -1, 0x1000000);
            this.drawText(gC, string, rectangle2.x, n2, rectangle2.width, -1, 131072);
        }
    }

    @Override
    protected void paintPage(GC gC, int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl = false;
        if (this.image == null) {
            bl = true;
        } else {
            rectangle2 = this.image.getBounds();
            rectangle = this.getPage().getBounds();
            boolean bl2 = bl = rectangle2.width != rectangle.width || rectangle2.height != rectangle.height;
        }
        if (bl) {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            rectangle2 = this.getPage().getBounds();
            this.image = new Image((Device)this.getDisplay(), rectangle2.width, rectangle2.height);
            rectangle = new GC((Drawable)this.image);
            try {
                this.paintHeaderFooter((GC)rectangle);
            }
            finally {
                rectangle.dispose();
            }
        }
        rectangle2 = this.image.getBounds();
        rectangle = this.getPage().getClientArea();
        float f = 1.0f;
        if (rectangle.width != 0) {
            f = (float)rectangle2.width / (float)rectangle.width;
        }
        float f2 = 1.0f;
        if (rectangle.height != 0) {
            f2 = (float)rectangle2.height / (float)rectangle.height;
        }
        Rectangle rectangle3 = this.getPageVisibleArea();
        Rectangle rectangle4 = new Rectangle(Math.round((float)rectangle3.x * f), Math.round((float)rectangle3.y * f2), Math.round((float)rectangle3.width * f), Math.round((float)rectangle3.height * f2));
        gC.drawImage(this.image, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
    }

    @Override
    protected void propertyChange(String string) {
        super.propertyChange(string);
        if (string == null || string.equals(PrefKey.P_HEADER_LEFT.toString()) || string.equals(PrefKey.P_HEADER_CENTER.toString()) || string.equals(PrefKey.P_HEADER_RIGHT.toString()) || string.equals(PrefKey.P_FOOTER_LEFT.toString()) || string.equals(PrefKey.P_FOOTER_CENTER.toString()) || string.equals(PrefKey.P_FOOTER_RIGHT.toString()) || string.equals(PrefKey.P_PRINT_FOOTER.toString()) || string.equals(PrefKey.P_PRINT_HEADER.toString())) {
            this.image = null;
            this.getPage().redraw();
        }
    }

    private Point textExtent(String string, int n, int n2) {
        Point point = new Point(0, 0);
        if (string.isEmpty()) {
            return point;
        }
        TextLayout textLayout = this.createTextLayout(string, n, n2);
        try {
            Rectangle rectangle = textLayout.getBounds();
            point = new Point(rectangle.width, rectangle.height);
        }
        finally {
            textLayout.dispose();
        }
        return point;
    }
}

