/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing;

import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.IPrinterGC;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class UIPrinterAdapter
implements IPrinter {
    private final Display display;
    private final IPrinter printer;

    public UIPrinterAdapter(Display display, IPrinter iPrinter) {
        Assert.isNotNull((Object)display);
        this.display = display;
        Assert.isNotNull((Object)iPrinter);
        this.printer = iPrinter;
    }

    @Override
    public void dispose() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            this.printer.dispose();
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIPrinterAdapter.this.printer.dispose();
                }
            });
        }
    }

    @Override
    public void endJob() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            this.printer.endJob();
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIPrinterAdapter.this.printer.endJob();
                }
            });
        }
    }

    @Override
    public void endPage() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            this.printer.endPage();
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIPrinterAdapter.this.printer.endPage();
                }
            });
        }
    }

    @Override
    public Device getDevice() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            return this.printer.getDevice();
        }
        final Device[] deviceArray = new Device[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                deviceArray[0] = UIPrinterAdapter.this.printer.getDevice();
            }
        });
        return deviceArray[0];
    }

    @Override
    public Rectangle getDeviceBounds() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            return this.printer.getDeviceBounds();
        }
        final Rectangle[] rectangleArray = new Rectangle[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                rectangleArray[0] = UIPrinterAdapter.this.printer.getDeviceBounds();
            }
        });
        return rectangleArray[0];
    }

    @Override
    public Rectangle getDeviceClientArea() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            return this.printer.getDeviceClientArea();
        }
        final Rectangle[] rectangleArray = new Rectangle[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                rectangleArray[0] = UIPrinterAdapter.this.printer.getDeviceClientArea();
            }
        });
        return rectangleArray[0];
    }

    @Override
    public Point getDeviceDPI() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            return this.printer.getDeviceDPI();
        }
        final Point[] pointArray = new Point[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                pointArray[0] = UIPrinterAdapter.this.printer.getDeviceDPI();
            }
        });
        return pointArray[0];
    }

    @Override
    public boolean startJob(final String string) {
        if (Thread.currentThread().equals(this.display.getThread())) {
            return this.printer.startJob(string);
        }
        final boolean[] blArray = new boolean[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                blArray[0] = UIPrinterAdapter.this.printer.startJob(string);
            }
        });
        return blArray[0];
    }

    @Override
    public IPrinterGC startPage() {
        if (Thread.currentThread().equals(this.display.getThread())) {
            return this.printer.startPage();
        }
        final IPrinterGC[] iPrinterGCArray = new IPrinterGC[1];
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                iPrinterGCArray[0] = UIPrinterAdapter.this.printer.startPage();
            }
        });
        return iPrinterGCArray[0];
    }
}

