/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing;

import com.deltawalker.internal.ui.printing.IDeferredDrawable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PreviewPrinterPage
extends Canvas {
    private static final int LINE_WIDTH = 2;
    private Image image;
    private boolean imageIsDisposable;

    public PreviewPrinterPage(Composite composite, int n) {
        super(composite, n);
        final Color color = this.getDisplay().getSystemColor(23);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (PreviewPrinterPage.this.image == null) {
                    return;
                }
                Rectangle rectangle = PreviewPrinterPage.this.getClientArea();
                Rectangle rectangle2 = PreviewPrinterPage.this.image.getBounds();
                paintEvent.gc.drawImage(PreviewPrinterPage.this.image, 0, 0, rectangle2.width, rectangle2.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                paintEvent.gc.setForeground(color);
                paintEvent.gc.setLineWidth(2);
                paintEvent.gc.drawRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (PreviewPrinterPage.this.imageIsDisposable && PreviewPrinterPage.this.image != null && !PreviewPrinterPage.this.image.isDisposed()) {
                    PreviewPrinterPage.this.image.dispose();
                }
            }
        });
    }

    public void setImage(IDeferredDrawable iDeferredDrawable, int n, int n2) {
        Display display = this.getDisplay();
        Image image = new Image((Device)display, n, n2);
        GC gC = new GC((Drawable)image);
        try {
            iDeferredDrawable.draw(gC, (Device)display);
        }
        finally {
            gC.dispose();
        }
        this.setImage(image, true);
    }

    public void setImage(Image image) {
        this.setImage(image, false);
    }

    public void setImage(Image image, boolean bl) {
        if (this.image != image) {
            if (this.imageIsDisposable && this.image != null) {
                this.image.dispose();
            }
            this.image = image;
            this.imageIsDisposable = bl;
            this.redraw();
            this.setVisible(this.image != null);
        }
    }
}

