/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing;

import com.deltawalker.ui.printing.PreviewPrinterComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class PreviewPrinterLayout
extends Layout {
    private static final int DEFAULT_HEIGHT = 64;
    private static final int DEFAULT_WIDTH = 64;
    private static final int MOUSE_WHEEL_PAGE_STEPS = 7;

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        PreviewPrinterComposite previewPrinterComposite = (PreviewPrinterComposite)composite;
        Control control = previewPrinterComposite.getPage();
        if (control == null) {
            int n3 = n != -1 ? n : 64;
            int n4 = n2 != -1 ? n2 : 64;
            return new Point(n3, n4);
        }
        Point point = control.computeSize(n, n2, bl);
        if (point != null) {
            point.x += 2 * previewPrinterComposite.getMarginWidth();
            point.y += 2 * previewPrinterComposite.getMarginHeight();
        }
        return point;
    }

    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle;
        PreviewPrinterComposite previewPrinterComposite = (PreviewPrinterComposite)composite;
        int n = previewPrinterComposite.getPageCount();
        if (n > 0) {
            rectangle = previewPrinterComposite.getDeviceBounds();
            float f = previewPrinterComposite.getZoomFactor();
            rectangle.width = (int)((float)rectangle.width * f);
            rectangle.height = (int)((float)rectangle.height * f);
        } else {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle2 = composite.getBounds();
        int n2 = previewPrinterComposite.getMarginWidth();
        int n3 = previewPrinterComposite.getMarginHeight();
        rectangle2.x += n2;
        rectangle2.y += n3;
        rectangle2.width -= 2 * n2;
        rectangle2.height -= 2 * n3;
        boolean bl2 = true;
        boolean bl3 = true;
        ScrollBar scrollBar = composite.getHorizontalBar();
        ScrollBar scrollBar2 = composite.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(bl2);
            if (bl2) {
                if (bl3 && scrollBar2 != null) {
                    rectangle2.width -= scrollBar2.getSize().x;
                }
                scrollBar.setMaximum(rectangle.width);
                scrollBar.setThumb(rectangle2.width);
            }
        }
        if (scrollBar2 != null) {
            scrollBar2.setVisible(bl3);
            if (bl3) {
                if (bl2 && scrollBar != null) {
                    rectangle2.height -= scrollBar.getSize().y;
                }
                scrollBar2.setMaximum(rectangle.height);
                scrollBar2.setThumb(rectangle2.height);
                scrollBar2.setIncrement((scrollBar2.getMaximum() - scrollBar2.getMinimum()) / 7);
            }
        }
        rectangle.x = (rectangle2.width - rectangle.width) / 2;
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        rectangle.x += n2;
        if (bl2 && scrollBar != null) {
            rectangle.x -= scrollBar.getSelection();
        }
        rectangle.y = (rectangle2.height - rectangle.height) / 2;
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        rectangle.y += n3;
        if (bl3 && scrollBar2 != null) {
            rectangle.y -= scrollBar2.getSelection();
        }
        int n4 = previewPrinterComposite.getPageIndex();
        Control control = previewPrinterComposite.getPage();
        if (n4 >= 0 && n4 < n) {
            control.setBounds(rectangle);
        } else {
            control.setVisible(false);
        }
    }
}

