/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing;

import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.IPrinterGC;
import com.deltawalker.ui.printing.PrinterGC;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class PageRangePrinter
implements IPrinter {
    private final int endPage;
    private IPrinterGC gc;
    private String jobName;
    private Image nullImage;
    private int pageCount;
    private final IPrinter printer;
    private boolean printerJobStarted;
    private final int startPage;

    public PageRangePrinter(IPrinter iPrinter, int n, int n2) {
        this.printer = iPrinter;
        if (n <= n2) {
            this.startPage = n;
            this.endPage = n2;
        } else {
            this.startPage = n2;
            this.endPage = n;
        }
    }

    @Override
    public void dispose() {
        try {
            this.disposeState();
        }
        finally {
            this.printer.dispose();
        }
    }

    private void disposeNullState() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
        if (this.nullImage != null) {
            this.nullImage.dispose();
            this.nullImage = null;
        }
    }

    private void disposeState() {
        this.jobName = null;
        this.pageCount = 0;
        this.printerJobStarted = false;
        this.disposeNullState();
    }

    @Override
    public void endJob() {
        if (this.printerJobStarted) {
            this.printer.endJob();
            this.printerJobStarted = false;
        }
        this.disposeState();
    }

    @Override
    public void endPage() {
        try {
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
        }
        finally {
            if (this.printerJobStarted) {
                this.printer.endPage();
                if (this.pageCount > this.endPage) {
                    this.printer.endJob();
                    this.printerJobStarted = false;
                }
            }
        }
    }

    @Override
    public Device getDevice() {
        return this.printer.getDevice();
    }

    @Override
    public Rectangle getDeviceBounds() {
        return this.printer.getDeviceBounds();
    }

    @Override
    public Rectangle getDeviceClientArea() {
        return this.printer.getDeviceClientArea();
    }

    @Override
    public Point getDeviceDPI() {
        return this.printer.getDeviceDPI();
    }

    @Override
    public boolean startJob(String string) {
        if (this.jobName != null) {
            throw new IllegalStateException("A job has already been started.");
        }
        this.disposeState();
        this.jobName = string == null ? "" : string;
        return true;
    }

    @Override
    public IPrinterGC startPage() {
        if (this.jobName == null) {
            throw new IllegalStateException("No job has been started.");
        }
        if (this.gc != null) {
            throw new IllegalStateException("There has not been a call to PrintPrinter#endPage() after a previous call to PrintPrinter#startPage().");
        }
        int n = this.pageCount + 1;
        if (this.startPage <= n && n <= this.endPage) {
            if (!this.printerJobStarted) {
                if (!this.printer.startJob(this.jobName)) {
                    return null;
                }
                this.printerJobStarted = true;
            }
            this.disposeNullState();
            this.gc = this.printer.startPage();
        } else if (n < this.startPage) {
            if (this.nullImage == null) {
                Device device = this.getDevice();
                Rectangle rectangle = this.getDeviceBounds();
                this.nullImage = new Image(device, rectangle.width, rectangle.height);
            }
            this.gc = new PrinterGC((Drawable)this.nullImage);
        }
        if (this.gc != null) {
            this.pageCount = n;
        }
        return this.gc;
    }
}

