/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing;

import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.IPrinterGC;
import com.deltawalker.ui.printing.PrinterGC;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class NullPrinter
implements IPrinter {
    private IPrinterGC gc;
    private Image image;
    private final IPrinter printer;

    public NullPrinter(IPrinter iPrinter) {
        Assert.isNotNull((Object)iPrinter);
        this.printer = iPrinter;
    }

    @Override
    public void dispose() {
        this.disposeState();
    }

    private void disposeState() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    @Override
    public void endJob() {
        this.disposeState();
    }

    @Override
    public void endPage() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
    }

    @Override
    public Device getDevice() {
        return this.printer.getDevice();
    }

    @Override
    public Rectangle getDeviceBounds() {
        return this.printer.getDeviceBounds();
    }

    @Override
    public Rectangle getDeviceClientArea() {
        return this.printer.getDeviceClientArea();
    }

    @Override
    public Point getDeviceDPI() {
        return this.printer.getDeviceDPI();
    }

    @Override
    public boolean startJob(String string) {
        this.disposeState();
        return true;
    }

    @Override
    public IPrinterGC startPage() {
        if (this.gc == null) {
            if (this.image == null) {
                Device device = this.getDevice();
                Rectangle rectangle = this.getDeviceBounds();
                this.image = new Image(device, rectangle.width, rectangle.height);
            }
            this.gc = new PrinterGC((Drawable)this.image);
        }
        return this.gc;
    }
}

