/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing;

import com.deltawalker.internal.ui.printing.IDeferredDrawable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;

public class DeferredText
implements IDeferredDrawable {
    private final int alignment;
    private final Rectangle clipping;
    private final FontData[] fontData;
    private final RGB foreground;
    private final String text;
    private final int width;
    private final int x;
    private final int y;

    public DeferredText(TextLayout textLayout, int n, int n2, GC gC) {
        this.alignment = textLayout.getAlignment();
        this.clipping = gC.getClipping();
        this.fontData = textLayout.getFont().getFontData();
        this.foreground = gC.getForeground().getRGB();
        this.text = textLayout.getText();
        this.width = textLayout.getWidth();
        this.x = n;
        this.y = n2;
    }

    private TextLayout createTextLayout(Device device, String string, int n, int n2) {
        TextLayout textLayout = new TextLayout(device);
        textLayout.setAlignment(n2);
        textLayout.setFont(new Font(device, this.fontData));
        textLayout.setText(string);
        if (n != 0) {
            textLayout.setWidth(n);
        }
        return textLayout;
    }

    private void disposeTextLayout(TextLayout textLayout) {
        Font font = textLayout.getFont();
        textLayout.dispose();
        font.dispose();
    }

    @Override
    public void draw(GC gC, Device device) {
        Rectangle rectangle = gC.getClipping();
        Color color = gC.getForeground();
        try {
            Color color2 = new Color(device, this.foreground);
            try {
                gC.setClipping(this.clipping);
                gC.setForeground(color2);
                TextLayout textLayout = this.createTextLayout(device, this.text, this.width, this.alignment);
                try {
                    textLayout.draw(gC, this.x, this.y);
                }
                finally {
                    this.disposeTextLayout(textLayout);
                }
            }
            finally {
                color2.dispose();
            }
        }
        finally {
            gC.setClipping(rectangle);
            gC.setForeground(color);
        }
    }
}

