/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.printing;

import com.deltawalker.internal.ui.printing.IDeferredDrawable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class DeferredLineOrRectangle
implements IDeferredDrawable {
    public static final int DRAW_RECTANGLE = 2;
    public static final int FILL_RECTANGLE = 4;
    public static final int LINE = 1;
    private final RGB color;
    private final int lineWidth;
    private final int style;
    private final int x1;
    private final int x2;
    private final int y1;
    private final int y2;

    public DeferredLineOrRectangle(int n, int n2, int n3, int n4, int n5, GC gC) {
        if (n != 2 && n != 4 && n != 1) {
            throw new IllegalArgumentException("style");
        }
        this.style = n;
        this.x1 = n2;
        this.y1 = n3;
        this.x2 = n4;
        this.y2 = n5;
        this.color = (this.style == 4 ? gC.getBackground() : gC.getForeground()).getRGB();
        this.lineWidth = gC.getLineWidth();
    }

    @Override
    public void draw(GC gC, Device device) {
        Color color = this.style == 4 ? gC.getBackground() : gC.getForeground();
        int n = gC.getLineWidth();
        try {
            Color color2 = new Color(device, this.color);
            try {
                if (this.style == 4) {
                    gC.setBackground(color2);
                } else {
                    gC.setForeground(color2);
                }
                gC.setLineWidth(this.lineWidth);
                switch (this.style) {
                    case 2: {
                        gC.drawRectangle(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                        break;
                    }
                    case 4: {
                        gC.fillRectangle(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                        break;
                    }
                    case 1: {
                        gC.drawLine(this.x1, this.y1, this.x2, this.y2);
                    }
                }
            }
            finally {
                color2.dispose();
            }
        }
        finally {
            if (this.style == 4) {
                gC.setBackground(color);
            } else {
                gC.setForeground(color);
            }
            gC.setLineWidth(n);
        }
    }
}

