/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.ITrustedPathsBoss;
import com.deltawalker.ui.UIUtil;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.OSDirectoryDialog;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedPathsPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int COL_IX_EXTENSION = 0;
    private static final Logger LOG = LoggerFactory.getLogger(TrustedPathsPrefPage.class);
    private Button btnRemoveAll;
    private TableViewer tableViewer;
    private final TableColumnLayout tcLayout = new TableColumnLayout();

    public static String addPath() {
        OSDirectoryDialog oSDirectoryDialog = new OSDirectoryDialog(UIUtil.getActiveWindowShell(), 4096);
        oSDirectoryDialog.setText(Msg.TrustedPathsDirDialog_select);
        String string = oSDirectoryDialog.open();
        if (string != null) {
            try {
                App.instance().trustedPathsBoss().addPath(new File(string).getCanonicalPath());
            }
            catch (IOException iOException) {
                LOG.error("Couldn't canonicalize path", (Throwable)iOException);
            }
        }
        return string;
    }

    private void addPathUpdateUi() {
        if (TrustedPathsPrefPage.addPath() != null) {
            this.tableViewer.refresh();
        }
    }

    private Control createButtonBar(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        final Button button = new Button(composite2, 8);
        button.setLayoutData((Object)new GridData(4, 16384, true, false));
        button.setText(Msg.TrustedPathsPrefPage_add);
        final Button button2 = new Button(composite2, 8);
        button2.setLayoutData((Object)new GridData(4, 16384, true, false));
        button2.setText(Msg.TrustedPathsPrefPage_remove);
        this.btnRemoveAll = new Button(composite2, 8);
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.btnRemoveAll.setText(Msg.TrustedPathsPrefPage_removeAll);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                try {
                    Widget widget = event.widget;
                    if (widget == button) {
                        TrustedPathsPrefPage.this.addPathUpdateUi();
                    } else if (widget == button2) {
                        String string = TrustedPathsPrefPage.this.getSelection();
                        if (string != null) {
                            App.instance().trustedPathsBoss().removePath(string);
                            TrustedPathsPrefPage.this.tableViewer.refresh();
                        }
                    } else if (widget == TrustedPathsPrefPage.this.btnRemoveAll) {
                        String[] stringArray = new String[]{Msg.TrustedPathsPrefPage_removeAll, IDialogConstants.CANCEL_LABEL};
                        int n = UIUtil.showConfirmActionPrompt(TrustedPathsPrefPage.this.getShell(), Msg.TrustedPathsPrefPage_prompt, stringArray);
                        if (n != 1) {
                            App.instance().trustedPathsBoss().clearPaths();
                            TrustedPathsPrefPage.this.tableViewer.refresh();
                        }
                    }
                }
                catch (IOException iOException) {
                    LOG.error("Couldn't remove a trusted path: ", (Throwable)iOException);
                }
            }
        };
        button.addListener(13, listener);
        button2.addListener(13, listener);
        this.btnRemoveAll.addListener(13, listener);
        ISelectionChangedListener iSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                boolean bl = TrustedPathsPrefPage.this.getSelection() != null;
                button2.setEnabled(bl);
            }
        };
        this.tableViewer.addSelectionChangedListener(iSelectionChangedListener);
        iSelectionChangedListener.selectionChanged(null);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                TrustedPathsPrefPage.this.addPathUpdateUi();
            }
        });
        return composite2;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = DialogUtil.createPageComposite(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(4, 16384, true, false);
        gridData.horizontalSpan = gridLayout.numColumns;
        Label label = new Label(composite2, 64);
        label.setLayoutData((Object)gridData);
        label.setText(Msg.TrustedPathsPrefPage_label);
        this.createTable(composite2);
        Control control = this.createButtonBar(composite2);
        control.setLayoutData((Object)new GridData(131072, 4, false, true));
        ITrustedPathsBoss iTrustedPathsBoss = App.instance().trustedPathsBoss();
        this.tableViewer.setInput((Object)iTrustedPathsBoss);
        this.applyDialogFont(composite2);
        return composite2;
    }

    private void createTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.tcLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(composite2, 67588){

            protected void checkSubclass() {
            }

            public Point computeSize(int n, int n2, boolean bl) {
                if (n2 == -1) {
                    n2 = 2 * this.getBorderWidth() + this.getHeaderHeight() + this.getItemHeight();
                }
                return super.computeSize(n, n2, bl);
            }
        };
        TableColumn tableColumn = new TableColumn(table, 16384, 0);
        this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new PathContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PathLabelProvider());
    }

    public void dispose() {
        super.dispose();
    }

    private String getSelection() {
        ISelection iSelection = this.tableViewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            return (String)object;
        }
        return null;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performCancel() {
        App.instance().stateBoss().loadState(UIUtil.getActiveWindow());
        return true;
    }

    protected void performDefaults() {
        try {
            try {
                App.instance().trustedPathsBoss().clearPaths();
            }
            catch (IOException iOException) {
                LOG.error("Couldn't remove a trusted path: ", (Throwable)iOException);
            }
            App.instance().stateBoss().saveState();
            this.tableViewer.refresh();
        }
        finally {
            super.performDefaults();
        }
    }

    public void performHelp() {
        UIUtil.showHelp("general-trusted-paths", UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        App.instance().stateBoss().saveState();
        return true;
    }

    private class PathContentProvider
    implements IStructuredContentProvider {
        private PathContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            Set<String> set = ((ITrustedPathsBoss)object).paths();
            TrustedPathsPrefPage.this.btnRemoveAll.setEnabled(!set.isEmpty());
            return set.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class PathLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PathLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return (String)object;
        }
    }
}

