/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.dialogs;

import com.deltawalker.internal.ContextId;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.ui.swt.ImageCanvas;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TrialReminderDialog
extends TrayDialog {
    public static final int BUY_NOW = 1025;
    private static final int MESSAGE_WIDTH = -1;
    public static final int START_EXIT = 1027;
    public static final int UNLOCK_NOW = 1026;
    private String buyNowURL;
    private String defaultButtonText;
    private Image image;
    private ImageDescriptor imageDescriptor;
    private String message;
    private String title;

    public TrialReminderDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() & 0xFFFFFFBF);
    }

    protected void buttonPressed(int n) {
        if (n != 1025) {
            this.setReturnCode(n);
            this.close();
        } else if (!StringUtil.isEmpty((String)this.buyNowURL)) {
            Program.launch((String)this.buyNowURL);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (PlatformUI.isWorkbenchRunning()) {
            UIUtil.setHelpContextId((Control)shell, ContextId.TRIAL_REMINDER_DIALOG);
        }
        shell.setText(StringUtil.makeSafe((String)this.title));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, UIMsg.TrialReminderDlg_buyNow, false);
        this.createButton(composite, 1026, UIMsg.TrialReminderDlg_install, false);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        Canvas canvas = new Canvas(composite, 0);
        canvas.setLayoutData((Object)gridData);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.makeColumnsEqualWidth = false;
        ++gridLayout.numColumns;
        Button button = this.createButton(composite, 1027, this.defaultButtonText, true);
        button.setFocus();
    }

    protected Control createDialogArea(Composite composite) {
        GridData gridData;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        if (this.imageDescriptor != null) {
            this.image = this.imageDescriptor.createImage();
            if (this.image != null) {
                gridData = new ImageCanvas(composite2, 0);
                gridData.setImage(this.image);
                gridData.setLayoutData((Object)new GridData(16384, 128, false, false));
                gridData.addListener(12, new Listener(){

                    public void handleEvent(Event event) {
                        if (TrialReminderDialog.this.image != null) {
                            TrialReminderDialog.this.image.dispose();
                            TrialReminderDialog.this.image = null;
                        }
                    }
                });
            }
        }
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = -1;
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText(StringUtil.makeSafe((String)this.message));
        return composite2;
    }

    protected void helpPressed() {
        UIUtil.showHelp("trial-expiration-reminder", UIUtil.HelpContext.DIALOG);
    }

    public void setBuyNowURL(String string) {
        this.buyNowURL = string;
    }

    public void setDefaultButtonText(String string) {
        this.defaultButtonText = string;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

