/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.dialogs;

import com.deltawalker.Msg;
import com.deltawalker.script.Role;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.dialogs.FileDialogEx;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SnapshotFileDialog
extends FileDialogEx {
    private Map<Role, Button> buttons = new EnumMap<Role, Button>(Role.class);
    private Set<Role> roles;
    private final boolean save;

    public SnapshotFileDialog(Shell shell, int n, IPreferenceStore iPreferenceStore, Set<Role> set) {
        super(shell, n, iPreferenceStore);
        if (shell == null) {
            throw new NullPointerException("parent");
        }
        boolean bl = this.save = (n & 0x2000) == 8192;
        if (this.save) {
            if (iPreferenceStore == null) {
                throw new NullPointerException("prefs");
            }
            if (set == null) {
                throw new NullPointerException("roles");
            }
        }
        this.setTitle(this.save ? UIMsg.SnapshotFileDlg_createTitle : UIMsg.SnapshotFileDlg_openTitle);
        String string = TimeFormatter.formatShort(new Date().getTime());
        string = string.replace(" ", "_");
        string = string.replace(":", "");
        string = string.replace("/", "-");
        if (this.save) {
            String string2 = new File(Const.USER_HOME, "Snapshot_" + string + ".dwss").toString();
            this.setFilePath(string2);
        }
        this.setFilterExtensions(new String[]{UIMsg.SnapshotFileDlg_dwssFiles_extension, Msg.Common_allFiles_extension});
        this.setFilterNames(new String[]{UIMsg.SnapshotFileDlg_dwssFiles_name, Msg.Common_allFiles_name});
        if (this.save) {
            this.setUseStandaloneExtensionDialog(true);
            this.roles = new LinkedHashSet<Role>(set);
        }
    }

    @Override
    protected void configureButton(int n, Button button) {
        super.configureButton(n, button);
        if (n == 0) {
            button.setText(Msg.Common_create);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    @Override
    protected Control createDialogArea(Composite composite, int n, Object object) {
        int n2;
        Object object2;
        if (object != null) {
            object2 = (int[])object;
            n2 = object2[1];
        } else {
            n2 = -1;
        }
        object2 = new GridLayout();
        object2.marginHeight = 0;
        object2.marginWidth = 0;
        object2.numColumns = 1;
        Composite composite2 = new Composite(composite, n);
        composite2.setLayout((Layout)object2);
        if (!this.save) {
            return composite2;
        }
        GridData gridData = new GridData(4, 1024, true, false);
        if (OS.LINUX) {
            gridData.widthHint = 450;
        }
        Label label = new Label(composite2, 64);
        label.setLayoutData((Object)gridData);
        label.setText(UIMsg.SnapshotFileDlg_info);
        if (-1 == n2) {
            n2 = label.getLocation().x + label.computeSize((int)-1, (int)-1).x + object2.horizontalSpacing;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = object2.horizontalSpacing;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = object2.verticalSpacing;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 128, true, false));
        if (this.roles != null) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Button button = (Button)selectionEvent.widget;
                    Role role = (Role)((Object)button.getData());
                    if (button.getSelection()) {
                        SnapshotFileDialog.this.roles.add(role);
                    } else {
                        SnapshotFileDialog.this.roles.remove((Object)role);
                    }
                }
            };
            boolean bl = this.roles.size() > 2;
            for (Role role : this.roles) {
                Button button = new Button(composite3, 32);
                button.setText(role.getDisplayName(bl));
                button.setData((Object)role);
                button.addSelectionListener((SelectionListener)selectionAdapter);
                this.buttons.put(role, button);
                if (role != Role.REF) continue;
                button.setSelection(true);
            }
            this.roles = this.transferSelectedRoles();
        }
        return composite2;
    }

    @Override
    public String open() {
        String string = super.open();
        return string;
    }

    public Set<Role> roles() {
        return Collections.unmodifiableSet(this.roles);
    }

    private Set<Role> transferSelectedRoles() {
        for (Map.Entry<Role, Button> entry : this.buttons.entrySet()) {
            Role role = entry.getKey();
            Button button = entry.getValue();
            if (button.getSelection()) {
                this.roles.add(role);
                continue;
            }
            this.roles.remove((Object)role);
        }
        return this.roles;
    }
}

