/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.dialogs;

import com.deltawalker.LineEndingUtil;
import com.deltawalker.Msg;
import com.deltawalker.internal.ContextId;
import com.deltawalker.internal.PatchConfig;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.dialogs.FileDialogEx;
import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SavePatchDialog
extends FileDialogEx {
    private static final String AVAILABLE_FORMATS = "AVAILABLE_FORMATS";
    private final int[] contextContextLineCount = new int[1];
    private int format;
    private final PatchConfig patchConfig = new PatchConfig();
    private final int[] unifiedContextLineCount = new int[1];

    public SavePatchDialog(Shell shell, int n, IPreferenceStore iPreferenceStore) {
        super(shell, n & 0xFFFFEFFF | 0x2000, iPreferenceStore);
        int n2;
        this.setTitle(UIMsg.CreatePatchDlg_title);
        this.setUseStandaloneExtensionDialog(true);
        this.format = this.patchConfig.getFormat();
        this.contextContextLineCount[0] = n2 = this.patchConfig.getContextLineCount();
        this.unifiedContextLineCount[0] = n2;
    }

    @Override
    protected void configureButton(int n, Button button) {
        super.configureButton(n, button);
        if (n == 0) {
            button.setText(Msg.Common_create);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, ContextId.CREATE_PATCH_DIALOG);
    }

    @Override
    protected Control createDialogArea(Composite composite, int n, Object object) {
        int n2;
        Object object2;
        if (object != null) {
            object2 = (int[])object;
            n2 = object2[1];
        } else {
            n2 = -1;
        }
        object2 = new GridLayout();
        object2.marginHeight = 0;
        object2.marginWidth = 0;
        object2.numColumns = 2;
        Composite composite2 = new Composite(composite, n);
        composite2.setLayout((Layout)object2);
        int n3 = n2 - object2.horizontalSpacing;
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        if (n3 > 0) {
            gridData.widthHint = n3;
        }
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setText(UIMsg.CreatePatchDlg_format);
        if (-1 == n2) {
            n2 = label.getLocation().x + label.computeSize((int)-1, (int)-1).x + object2.horizontalSpacing;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = object2.horizontalSpacing;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = object2.verticalSpacing;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 128, true, false));
        final Combo combo = new Combo(composite3, 8);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillFormatCombo(combo);
        Label label2 = new Label(composite3, 0);
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label2.setText(UIMsg.CreatePatchDlg_preContextLineCount);
        final Spinner spinner = new Spinner(composite3, 2048);
        spinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        spinner.setMaximum(Short.MAX_VALUE);
        Label label3 = new Label(composite3, 0);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label3.setText(UIMsg.CreatePatchDlg_postContextLineCount);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                int[] nArray;
                Widget widget = event.widget;
                int n = SavePatchDialog.this.getSelectedFormat(combo);
                switch (n) {
                    case 1: {
                        nArray = SavePatchDialog.this.contextContextLineCount;
                        break;
                    }
                    case 4: {
                        nArray = SavePatchDialog.this.unifiedContextLineCount;
                        break;
                    }
                    default: {
                        nArray = null;
                    }
                }
                if (widget == combo) {
                    SavePatchDialog.this.setFormat(n);
                    if (nArray == null) {
                        spinner.setEnabled(false);
                        spinner.setSelection(0);
                    } else {
                        spinner.setEnabled(true);
                        spinner.setSelection(nArray[0]);
                    }
                } else if (widget == spinner && nArray != null) {
                    nArray[0] = spinner.getSelection();
                }
            }
        };
        combo.addListener(13, listener);
        spinner.addListener(13, listener);
        this.setSelectedFormat(combo, this.format);
        Control control = super.createDialogArea(composite2, n, new int[]{object2.verticalSpacing, n2});
        if (control != null) {
            GridData gridData2 = new GridData(4, 128, true, false);
            gridData2.horizontalSpan = object2.numColumns;
            control.setLayoutData((Object)gridData2);
        }
        return composite2;
    }

    private void fillFormatCombo(Combo combo) {
        int[] nArray = PatchConfig.getAvailableFormats();
        ResourceBundle resourceBundle = UIMsg.constructedKeyBundle();
        String string = "CreatePatchDialog.format.";
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            combo.add(resourceBundle.getString(String.valueOf(string) + n2));
            ++n;
        }
        combo.setData(AVAILABLE_FORMATS, (Object)nArray);
    }

    public PatchConfig getPatchConfiguration() {
        if (this.patchConfig.getFileName() == null) {
            return null;
        }
        this.patchConfig.setFormat(this.format);
        switch (this.format) {
            case 1: {
                this.patchConfig.setContextLineCount(this.contextContextLineCount[0]);
                break;
            }
            case 4: {
                this.patchConfig.setContextLineCount(this.unifiedContextLineCount[0]);
            }
        }
        return this.patchConfig;
    }

    private int getSelectedFormat(Combo combo) {
        int[] nArray = (int[])combo.getData(AVAILABLE_FORMATS);
        int n = combo.getSelectionIndex();
        return nArray[n];
    }

    @Override
    public String open() {
        String string = super.open();
        if (string != null) {
            this.patchConfig.setCharset(this.getSelectedEncoding(true).charset());
            this.patchConfig.setFileName(string);
            this.patchConfig.setLineDelimiter(LineEndingUtil.fromName(this.getSelectedLineEnding()));
        }
        return string;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    private void setSelectedFormat(Combo combo, int n) {
        int[] nArray = (int[])combo.getData(AVAILABLE_FORMATS);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                combo.select(n2);
                combo.notifyListeners(13, null);
                break;
            }
            ++n2;
        }
    }
}

