/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui.dialogs;

import com.deltawalker.Msg;
import com.deltawalker.internal.ContextId;
import com.deltawalker.ui.ButtonFactory;
import com.deltawalker.ui.IDiffSummary;
import com.deltawalker.ui.IDiffSummaryItem;
import com.deltawalker.ui.IDiffSummaryProvider;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.IPrintable;
import com.deltawalker.ui.printing.IPrinter;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.ui.OSFileDialog;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DiffSummaryDialog
extends TrayDialog
implements IPrintable {
    public static final int COPY_ID = 1024;
    private static final int INITIAL_HEIGHT = 350;
    private static final String NULL_ITEM_VALUE = "-";
    public static final int SAVE_AS_ID = 2048;
    private static final RGB TABLE_HEADER_BACKGROUND_COLOR = new RGB(136, 136, 136);
    private static final String TABLE_HEADER_BACKGROUND_COLOR_PLACEHOLDER = "/* tableHeaderBackgroundColor */";
    private static final RGB TABLE_HEADER_FOREGROUND_COLOR = new RGB(204, 204, 204);
    private static final String TABLE_HEADER_FOREGROUND_COLOR_PLACEHOLDER = "/* tableHeaderForegroundColor */";
    private static final String TABLE_ROW_CONFLICTING_CSS_CLASS = "conflicting";
    private static final String TABLE_ROW_CONFLICTING_CSS_STYLE = "tr.conflicting { font-weight:bold }";
    private static final String Z_HTML_STYLE = "table { border-left: 1px solid #000000; border-top: 1px solid #000000 } th, td { border-right: 1px solid #000000; border-bottom: 1px solid #000000; padding-left: 5px; padding-right: 5px } th { /* tableHeaderBackgroundColor */; /* tableHeaderForegroundColor */ }td.characteristicValue { text-align: right }tr.conflicting { font-weight:bold }";
    private Browser browser;
    private String html;
    private IDiffSummary summary;
    private IDiffSummaryProvider dsProvider;

    private static List<List<IDiffSummaryItem>> collectItemsInLevels(IDiffSummary iDiffSummary) {
        ArrayList<List<IDiffSummaryItem>> arrayList = new ArrayList<List<IDiffSummaryItem>>();
        List<IDiffSummaryItem> list = iDiffSummary.getItems();
        if (!list.isEmpty()) {
            int n;
            int n2;
            ArrayList<IDiffSummaryItem> arrayList2 = new ArrayList<IDiffSummaryItem>();
            for (IDiffSummaryItem iDiffSummaryItem : list) {
                arrayList2.add(iDiffSummaryItem);
            }
            arrayList.add(arrayList2);
            do {
                n = arrayList.size();
                DiffSummaryDialog.expandLastLevel(arrayList);
            } while ((n2 = arrayList.size()) != n);
        }
        return arrayList;
    }

    private static void expandLastLevel(List<List<IDiffSummaryItem>> list) {
        List<IDiffSummaryItem> list2 = list.get(list.size() - 1);
        ArrayList<IDiffSummaryItem> arrayList = new ArrayList<IDiffSummaryItem>();
        for (IDiffSummaryItem iDiffSummaryItem : list2) {
            IDiffSummaryItem[] iDiffSummaryItemArray;
            IDiffSummaryItem[] iDiffSummaryItemArray2 = iDiffSummaryItemArray = iDiffSummaryItem.items();
            int n = iDiffSummaryItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffSummaryItem iDiffSummaryItem2 = iDiffSummaryItemArray2[n2];
                arrayList.add(iDiffSummaryItem2);
                ++n2;
            }
        }
        if (arrayList.size() > 0) {
            list.add(arrayList);
        }
    }

    private static String toString(IDiffSummary iDiffSummary, Formatter formatter) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(formatter.getHeader());
        while (iDiffSummary != null) {
            DiffSummaryDialog.toSubstring(iDiffSummary, formatter, stringBuffer);
            iDiffSummary = iDiffSummary.nextSummary();
        }
        stringBuffer.append(formatter.getFooter());
        return stringBuffer.toString();
    }

    private static void toSubstring(IDiffSummary iDiffSummary, Formatter formatter, StringBuffer stringBuffer) {
        Object object;
        Object object2;
        Object object3;
        List<List<IDiffSummaryItem>> list = DiffSummaryDialog.collectItemsInLevels(iDiffSummary);
        int n = list.size();
        if (n == 0) {
            return;
        }
        String string = iDiffSummary.description();
        if (!StringUtil.isEmpty((String)string)) {
            stringBuffer.append(formatter.getParagraph(string));
        }
        stringBuffer.append(formatter.getTableStart());
        String string2 = formatter.getNonBreakingSpace();
        String string3 = formatter.getTableRowEnd();
        String string4 = formatter.getTableHeaderEnd();
        String string5 = formatter.getTableDataStart();
        String string6 = formatter.getTableDataEnd();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(formatter.getTableRowStart(null));
            if (n2 == 0) {
                stringBuffer.append(formatter.getTableHeaderStart(1, n));
                object3 = iDiffSummary.getName();
                if (object3 == null) {
                    object3 = UIMsg.CompareSummaryDlg_name;
                }
                stringBuffer.append((String)object3);
                stringBuffer.append(string4);
            }
            object3 = list.get(n2);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                String string7 = object.getName();
                if (string7 == null) {
                    string7 = string2;
                }
                stringBuffer.append(formatter.getTableHeaderStart(object.itemCount(), 1));
                stringBuffer.append(string7);
                stringBuffer.append(string4);
            }
            stringBuffer.append(string3);
            ++n2;
        }
        String[] stringArray = iDiffSummary.properties();
        object3 = list.get(n - 1);
        object = Msg.DeltaKind_conflicting;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object2 = stringArray2[n4];
            String string8 = ((String)object).equals(object2) ? TABLE_ROW_CONFLICTING_CSS_CLASS : null;
            stringBuffer.append(formatter.getTableRowStart(string8));
            stringBuffer.append(string5);
            stringBuffer.append((String)(object2 != null ? object2 : string2));
            stringBuffer.append(string6);
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                IDiffSummaryItem iDiffSummaryItem = (IDiffSummaryItem)iterator.next();
                Object object4 = iDiffSummaryItem.getValue((String)object2);
                stringBuffer.append(string5);
                stringBuffer.append(object4 != null ? object4 : NULL_ITEM_VALUE);
                stringBuffer.append(string6);
            }
            stringBuffer.append(string3);
            ++n4;
        }
        stringBuffer.append(formatter.getTableEnd());
    }

    public DiffSummaryDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        UIUtil.setHelpContextId((Control)shell, ContextId.COMPARISON_SUMMARY_DIALOG);
    }

    protected IAction createButtonAction(int n) {
        switch (n) {
            case 1024: {
                return new Action(){

                    public void run() {
                        Clipboard clipboard = new Clipboard(UIUtil.display());
                        try {
                            clipboard.setContents(new Object[]{DiffSummaryDialog.toString(DiffSummaryDialog.this.summary, new CSVFormatter('\t')), DiffSummaryDialog.this.html}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
                        }
                        finally {
                            clipboard.dispose();
                        }
                    }
                };
            }
            case 2048: {
                return new Action(){

                    public void run() {
                        OSFileDialog oSFileDialog = new OSFileDialog(DiffSummaryDialog.this.getShell(), 8192);
                        oSFileDialog.setFilterExtensions(new String[]{"html", Msg.Common_allFiles_extension});
                        oSFileDialog.setFilterNames(new String[]{UIMsg.CompareSummaryDlg_htmlFiles_name, Msg.Common_allFiles_name});
                        oSFileDialog.setFileName(UIMsg.CompareSummaryDlg_fileName);
                        String string = oSFileDialog.open();
                        if (string != null) {
                            try (FileWriter fileWriter = new FileWriter(string);){
                                fileWriter.write(DiffSummaryDialog.this.html);
                            }
                            catch (IOException iOException) {
                                MessageDialog.openError((Shell)DiffSummaryDialog.this.getShell(), null, (String)iOException.getMessage());
                            }
                        }
                    }
                };
            }
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        composite.setLayoutData((Object)new GridData(768));
        final ButtonFactory buttonFactory = new ButtonFactory(){

            @Override
            protected IAction createButtonAction(int n) {
                return DiffSummaryDialog.this.createButtonAction(n);
            }
        };
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                IAction iAction = buttonFactory.getButtonAction((Button)event.widget);
                if (iAction != null && iAction.isEnabled()) {
                    iAction.run();
                }
            }
        };
        Button button = buttonFactory.createButton(composite, 1024, Msg.Common_copy, false);
        button.addListener(13, listener);
        Button button2 = buttonFactory.createButton(composite, 2, String.valueOf(Msg.Common_pageSetup) + "...", false);
        button2.addListener(13, listener);
        Button button3 = buttonFactory.createButton(composite, 4, Msg.Common_print, false);
        button3.addListener(13, listener);
        Button button4 = buttonFactory.createButton(composite, 2048, Msg.Common_saveAs, false);
        button4.addListener(13, listener);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.initialize();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.browser = new Browser(composite2, 2048);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getShell().setText(this.dsProvider.summary().title());
        DiffSummaryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected HeaderFooterPrintOp createPrintOp(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        return new Printing(iPrinter, iProgressMonitor);
    }

    protected Point getInitialSize() {
        Point point = this.getShell().computeSize(-1, 350, true);
        point.x += 20;
        if (OS.GTK) {
            point.y += 60;
        }
        return point;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void initialize() {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        String string = "rgb(" + DiffSummaryDialog.TABLE_HEADER_BACKGROUND_COLOR.red + ',' + DiffSummaryDialog.TABLE_HEADER_BACKGROUND_COLOR.green + ',' + DiffSummaryDialog.TABLE_HEADER_BACKGROUND_COLOR.blue + ')';
        String string2 = "rgb(" + DiffSummaryDialog.TABLE_HEADER_FOREGROUND_COLOR.red + ',' + DiffSummaryDialog.TABLE_HEADER_FOREGROUND_COLOR.green + ',' + DiffSummaryDialog.TABLE_HEADER_FOREGROUND_COLOR.blue + ')';
        String string3 = StringUtil.replace((String)StringUtil.replace((String)Z_HTML_STYLE, (String)TABLE_HEADER_BACKGROUND_COLOR_PLACEHOLDER, (String)("background-color: " + string)), (String)TABLE_HEADER_FOREGROUND_COLOR_PLACEHOLDER, (String)("color: " + string2));
        HTMLFormatter hTMLFormatter = new HTMLFormatter();
        hTMLFormatter.setStyle(string3);
        Control control = this.getDialogArea();
        if (control != null) {
            hTMLFormatter.setFont(control.getFont());
        }
        this.html = DiffSummaryDialog.toString(this.summary, hTMLFormatter);
        this.browser.setText(this.html);
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        return super.open();
    }

    @Override
    public void print(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        HeaderFooterPrintOp headerFooterPrintOp = this.createPrintOp(iPrinter, iProgressMonitor);
        if (headerFooterPrintOp != null) {
            headerFooterPrintOp.run();
        }
    }

    public void setDiffSummaryProvider(IDiffSummaryProvider iDiffSummaryProvider) {
        if (!ObjectUtil.areEqual((Object)this.dsProvider, (Object)iDiffSummaryProvider)) {
            this.dsProvider = iDiffSummaryProvider;
            this.summary = this.dsProvider.summary();
            this.initialize();
        }
    }

    private static class CSVFormatter
    extends Formatter {
        private final String separator;

        public CSVFormatter(char c) {
            this.separator = Character.toString(c);
        }

        @Override
        public String getTableDataEnd() {
            return this.separator;
        }

        @Override
        public String getTableHeaderEnd() {
            return this.getTableDataEnd();
        }

        @Override
        public String getTableRowEnd() {
            return Const.LINE_ENDING;
        }
    }

    private static class Formatter {
        public String getFooter() {
            return "";
        }

        public String getHeader() {
            return "";
        }

        public String getNonBreakingSpace() {
            return " ";
        }

        public String getParagraph(String string) {
            return "";
        }

        public String getTableDataEnd() {
            return "";
        }

        public String getTableDataStart() {
            return "";
        }

        public String getTableEnd() {
            return Const.LINE_ENDING;
        }

        public String getTableHeaderEnd() {
            return "";
        }

        public String getTableHeaderStart(int n, int n2) {
            return "";
        }

        public String getTableRowEnd() {
            return "";
        }

        public String getTableRowStart(String string) {
            return "";
        }

        public String getTableStart() {
            return "";
        }
    }

    private static class HTMLFormatter
    extends Formatter {
        private Font font;
        private String style;

        @Override
        public String getFooter() {
            return "</body></html>";
        }

        @Override
        public String getHeader() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><head>");
            if (this.font != null) {
                FontData fontData = this.font.getFontData()[0];
                stringBuffer.append("<style> body,table { font-family: \"");
                stringBuffer.append(fontData.getName());
                stringBuffer.append("\"; font-size: ");
                stringBuffer.append(fontData.getHeight());
                stringBuffer.append(OS.OSX ? "px" : "pt");
                stringBuffer.append("; } </style>");
            }
            if (this.style != null) {
                stringBuffer.append("<style>");
                stringBuffer.append(this.style);
                stringBuffer.append("</style>");
            }
            stringBuffer.append("</head><body>");
            return stringBuffer.toString();
        }

        @Override
        public String getNonBreakingSpace() {
            return "&nbsp;";
        }

        @Override
        public String getParagraph(String string) {
            return "<p>" + string + "</p>";
        }

        @Override
        public String getTableDataEnd() {
            return "</td>";
        }

        @Override
        public String getTableDataStart() {
            return "<td>";
        }

        @Override
        public String getTableEnd() {
            return "</table><br/>";
        }

        @Override
        public String getTableHeaderEnd() {
            return "</th>";
        }

        @Override
        public String getTableHeaderStart(int n, int n2) {
            String string = "<th";
            if (n > 1) {
                string = String.valueOf(string) + " colspan=\"" + n + "\"";
            }
            if (n2 > 1) {
                string = String.valueOf(string) + " rowspan=\"" + n2 + "\"";
            }
            return String.valueOf(string) + ">";
        }

        @Override
        public String getTableRowEnd() {
            return "</tr>";
        }

        @Override
        public String getTableRowStart(String string) {
            String string2 = "<tr";
            if (string != null) {
                string2 = String.valueOf(string2) + " class=\"" + string + "\"";
            }
            return String.valueOf(string2) + ">";
        }

        @Override
        public String getTableStart() {
            return "<table border=\"0\" cellspacing=\"0\" width=\"100%\">";
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public void setStyle(String string) {
            this.style = string;
        }
    }

    private class Printing
    extends HeaderFooterPrintOp {
        private static final float CELL_PADDING_X = 0.1f;
        private static final float CELL_PADDING_Y = 0.05f;
        private static final float MARGIN_HEIGHT = 0.1f;

        public Printing(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
            super(iPrinter, iProgressMonitor);
            final Control control = DiffSummaryDialog.this.getDialogArea();
            if (control != null && !control.isDisposed()) {
                control.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Font font = control.getFont();
                        if (font != null) {
                            Printing.this.setFontData(font.getFontData()[0]);
                        }
                    }
                });
            }
        }

        @Override
        protected HeaderFooterPrintOp newInstance(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
            return new Printing(iPrinter, iProgressMonitor);
        }

        @Override
        protected void print() {
            int n = Math.round(0.1f * (float)this.getPrinterDPI().y);
            Rectangle rectangle = this.getPrintableArea();
            rectangle.y += n;
            rectangle.height -= 2 * n;
            int n2 = rectangle.y;
            IDiffSummary iDiffSummary = DiffSummaryDialog.this.summary;
            while (iDiffSummary != null) {
                if ((n2 = this.print(rectangle, iDiffSummary, n2) + n) == Integer.MIN_VALUE) {
                    return;
                }
                iDiffSummary = iDiffSummary.nextSummary();
            }
        }

        private int print(Rectangle rectangle, IDiffSummary iDiffSummary, int n) {
            String[][] stringArray = iDiffSummary.tableData();
            int n2 = stringArray.length;
            int n3 = n2 > 0 ? stringArray[0].length : 0;
            Point point = this.getPrinterDPI();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n3];
            int n4 = Math.round(0.1f * (float)point.x);
            int n5 = Math.round(0.05f * (float)point.y);
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n3) {
                    Point point2 = this.textExtent(stringArray[n6][n7]);
                    point2.x += 2 * n4;
                    point2.y += 2 * n5;
                    if (nArray[n6] < point2.y) {
                        nArray[n6] = point2.y;
                    }
                    if (nArray2[n7] < point2.x) {
                        nArray2[n7] = point2.x;
                    }
                    ++n7;
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < n2) {
                if ((n = this.print(rectangle, n6, stringArray[n6], n, nArray2, nArray[n6], new Point(n4, n5))) == Integer.MIN_VALUE) break;
                ++n6;
            }
            return n;
        }

        private int print(Rectangle rectangle, int n, String[] stringArray, int n2, int[] nArray, int n3, Point point) {
            Color color;
            int n4;
            int n5;
            int n6;
            if (n2 + n3 > rectangle.y + rectangle.height) {
                this.endPage();
                n2 = rectangle.y;
            }
            if (n2 == rectangle.y && !this.startPage()) {
                return Integer.MIN_VALUE;
            }
            int n7 = nArray.length;
            Device device = this.getPrinterDevice();
            if (n == 0) {
                n6 = rectangle.x;
                n5 = 0;
                while (n5 < n7) {
                    n4 = nArray[n5];
                    color = new Color(device, TABLE_HEADER_BACKGROUND_COLOR);
                    this.fillRectangle(n6, n2, n4, n3, color);
                    color.dispose();
                    n6 += n4;
                    ++n5;
                }
            }
            n6 = rectangle.x;
            n5 = 0;
            while (n5 < n7) {
                n4 = nArray[n5];
                color = null;
                if (n == 0) {
                    color = new Color(device, TABLE_HEADER_FOREGROUND_COLOR);
                }
                this.drawText(stringArray[n5], n6 + point.x, n2 + point.y, n4 - 2 * point.x, n3 - 2 * point.y, color);
                if (color != null) {
                    color.dispose();
                }
                if (n == 0) {
                    this.drawLine(n6, n2, n6 + n4, n2);
                }
                if (n5 == 0) {
                    this.drawLine(n6, n2, n6, n2 + n3);
                }
                this.drawLine(n6 + n4, n2, n6 + n4, n2 + n3);
                this.drawLine(n6, n2 + n3, n6 + n4, n2 + n3);
                n6 += n4;
                ++n5;
            }
            return n2 + n3;
        }
    }
}

