/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.App;
import com.deltawalker.DiffDoc;
import com.deltawalker.DiffDocAdapter;
import com.deltawalker.NotifyUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.internal.ui.DWViewHolder;
import com.deltawalker.ui.IThrobber;
import com.deltawalker.ui.ThrobberService;
import com.deltopia.AdaptableUtil;
import com.deltopia.ObjectUtil;
import com.deltopia.jface.util.IViewHolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.WorkbenchPart;

public abstract class WorkbenchPartAdapter
implements IReusableEditor {
    public static final int MAX_TITLE_LENGTH = 60;
    private final WorkbenchPart adaptedPart;
    private IEditorInput editorInput;
    private String fullTitle;
    private Image image;
    private ImageDescriptor imgDescriptor;
    private final IDocBoss.IDeltaDocListener onDeltaDoc = new IDocBoss.IDeltaDocListener(){

        @Override
        public void deltaDocChanged(IDocBoss.ChangeEvent changeEvent) {
            if (changeEvent.type == IDocBoss.ChangeEvent.Type.NAME) {
                WorkbenchPartAdapter.this.constructAndSetTitle();
                WorkbenchPartAdapter.this.setTitleToolTip(WorkbenchPartAdapter.this.getTitleToolTip());
            }
        }
    };
    private final IDiffDocListener onDiffDoc = new DiffDocAdapter(){

        @Override
        public void threeWayChanged(boolean bl) {
            WorkbenchPartAdapter.this.constructAndSetTitle();
            WorkbenchPartAdapter.this.setTitleToolTip(WorkbenchPartAdapter.this.getTitleToolTip());
        }
    };
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WorkbenchPartAdapter.this.propertyChange(propertyChangeEvent);
        }
    };
    private IEditorSite site;
    private IThrobber throbber;
    private Image titleImg;
    private IViewHolder viewHolder;
    private Composite viewParent;

    public WorkbenchPartAdapter(WorkbenchPart workbenchPart) {
        this.adaptedPart = workbenchPart;
        App.instance().docBoss().addListener(this.onDeltaDoc);
    }

    public void addPropertyListener(IPropertyListener iPropertyListener) {
        this.adaptedPart.addPropertyListener(iPropertyListener);
    }

    public void constructAndSetTitle() {
        this.fullTitle = DiffDoc.constructFullTitle(this.deltaDoc(), false);
        String string = this.fullTitle;
        if (string != null) {
            int n = string.length();
            if (n > 60) {
                string = string.substring(n - 60);
            }
            this.setTitle(string);
        }
    }

    public void createPartControl(Composite composite) {
        this.viewParent = new Composite(composite, 0);
        this.viewParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (WorkbenchPartAdapter.this.throbber != null) {
                    ThrobberService.getDefault(WorkbenchPartAdapter.this.viewParent.getDisplay()).removeThrobber(WorkbenchPartAdapter.this.throbber);
                }
            }
        });
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        this.viewParent.setLayout((Layout)fillLayout);
        this.viewHolder();
    }

    public IDiffDoc deltaDoc() {
        return (IDiffDoc)this.getEditorInput();
    }

    public void dispose() {
        App.instance().docBoss().removeListener(this.onDeltaDoc);
        DiffDoc diffDoc = (DiffDoc)this.editorInput;
        if (diffDoc != null) {
            NotifyUtil.installPropertyListener(diffDoc, this.onProp, false);
            diffDoc.removeDiffDocListener(this.onDiffDoc);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ISaveablePart iSaveablePart = this.getSaveableEditorPart();
        if (iSaveablePart != null) {
            iSaveablePart.doSave(iProgressMonitor);
        }
    }

    public void doSaveAs() {
        ISaveablePart iSaveablePart = this.getSaveableEditorPart();
        if (iSaveablePart != null) {
            iSaveablePart.doSaveAs();
        }
    }

    protected abstract void firePropertyChange(int var1);

    public Object getAdapter(Class clazz) {
        return clazz.isInstance(this) ? this : AdaptableUtil.getAdapter((Object)this.viewHolder(), (Class)clazz);
    }

    public IEditorInput getEditorInput() {
        return this.adaptedPart instanceof IEditorPart ? ((IEditorPart)this.adaptedPart).getEditorInput() : this.editorInput;
    }

    public IEditorSite getEditorSite() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        return iWorkbenchPartSite instanceof IEditorSite ? (IEditorSite)iWorkbenchPartSite : null;
    }

    public String getFullTitle() {
        return this.fullTitle;
    }

    public Image getImage() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput != null) {
            ImageDescriptor imageDescriptor = iEditorInput.getImageDescriptor();
            if (this.imgDescriptor != imageDescriptor) {
                this.image = null;
                this.imgDescriptor = imageDescriptor;
                if (this.imgDescriptor != null) {
                    this.image = this.imgDescriptor.createImage();
                }
            }
            return this.image;
        }
        return null;
    }

    public ISaveablePart getSaveableEditorPart() {
        return this.adaptedPart instanceof ISaveablePart ? (ISaveablePart)this.adaptedPart : null;
    }

    public IWorkbenchPartSite getSite() {
        return this.adaptedPart.getSite();
    }

    public IThrobber getThrobber() {
        if (this.throbber == null && this.viewParent != null && !this.viewParent.isDisposed()) {
            this.throbber = new TitleImageThrobber();
            ThrobberService.getDefault(this.viewParent.getDisplay()).addThrobber(this.throbber);
        }
        return this.throbber;
    }

    public String getTitle() {
        return this.adaptedPart.getTitle();
    }

    public Image getTitleImage() {
        return this.titleImg == null ? this.adaptedPart.getTitleImage() : this.titleImg;
    }

    public String getTitleToolTip() {
        return this.getEditorInput().getToolTipText();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.site = iEditorSite;
        this.setInput(iEditorInput);
    }

    public boolean isDirty() {
        return this.deltaDoc().isModified();
    }

    public boolean isSaveAsAllowed() {
        return this.getSaveableEditorPart() != null;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("IMAGE")) {
            this.setTitleImage(this.getImage());
        } else if (string.equals("NAME") || string.equals("MODIFIED")) {
            this.constructAndSetTitle();
            this.setTitleToolTip(this.getTitleToolTip());
            if (string.equals("MODIFIED")) {
                this.firePropertyChange(257);
            }
        }
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        this.adaptedPart.removePropertyListener(iPropertyListener);
    }

    public void setFocus() {
        IViewHolder iViewHolder = this.viewHolder();
        if (iViewHolder != null) {
            iViewHolder.activeView().control().setFocus();
        } else if (this.viewParent != null) {
            this.viewParent.setFocus();
        }
    }

    public void setInput(IEditorInput iEditorInput) {
        if (!(iEditorInput instanceof DiffDoc)) {
            throw new IllegalArgumentException("newInput");
        }
        DiffDoc diffDoc = (DiffDoc)this.editorInput;
        if (diffDoc != null) {
            NotifyUtil.installPropertyListener(diffDoc, this.onProp, false);
            diffDoc.removeDiffDocListener(this.onDiffDoc);
        }
        if (this.adaptedPart instanceof IReusableEditor && !ObjectUtil.areEqual((Object)iEditorInput, (Object)((IReusableEditor)this.adaptedPart).getEditorInput())) {
            ((IReusableEditor)this.adaptedPart).setInput(iEditorInput);
        }
        this.editorInput = iEditorInput;
        if (this.viewHolder != null) {
            this.viewHolder.createViews(this.getEditorInput(), this.site);
        }
        DiffDoc diffDoc2 = (DiffDoc)iEditorInput;
        NotifyUtil.installPropertyListener(diffDoc2, this.onProp, true);
        diffDoc2.addDiffDocListener(this.onDiffDoc);
        this.constructAndSetTitle();
        this.setTitleToolTip(iEditorInput.getToolTipText());
        this.setTitleImage(this.getImage());
        this.firePropertyChange(258);
    }

    public abstract void setTitle(String var1);

    public void setTitleImage(Image image) {
        this.titleImg = image;
        this.setTitleImageImpl(image);
    }

    protected abstract void setTitleImageImpl(Image var1);

    public abstract void setTitleToolTip(String var1);

    public IViewHolder viewHolder() {
        if (this.viewHolder == null) {
            DiffDoc diffDoc = (DiffDoc)this.getEditorInput();
            this.viewHolder = new DWViewHolder(this.viewParent);
            this.viewHolder.createViews(diffDoc, this.site);
        }
        return this.viewHolder;
    }

    public Composite viewParent() {
        return this.viewParent;
    }

    private class TitleImageThrobber
    implements IThrobber {
        private boolean busy;
        private final ListenerList listeners = new ListenerList();

        private TitleImageThrobber() {
        }

        @Override
        public void addPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
            this.listeners.add((Object)iPropertyChangeListener);
        }

        @Override
        public void currentFrameChanged(Image image) {
            WorkbenchPartAdapter.this.setTitleImageImpl(this.isBusy() ? image : WorkbenchPartAdapter.this.titleImg);
        }

        @Override
        public boolean isBusy() {
            return this.busy;
        }

        @Override
        public void removePropertyListener(IPropertyChangeListener iPropertyChangeListener) {
            this.listeners.remove((Object)iPropertyChangeListener);
        }

        @Override
        public void setBusy(boolean bl) {
            if (this.busy != bl) {
                boolean bl2 = this.busy;
                this.busy = bl;
                NotifyUtil.firePropertyChange(this.listeners, this, "BUSY", bl2, this.busy);
            }
        }
    }
}

