/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.ui.UIMsg;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class TagEntry
extends Composite {
    private Button btnArrow;
    private MenuItem miAdvanced;
    private Menu mTemplates;
    private Listener onAdvanced = new Listener(){

        public void handleEvent(Event event) {
            TagEntry.this.text.insert(((MenuItem)event.widget).getText());
        }
    };
    private Listener onFtrSelect = new Listener(){

        public void handleEvent(Event event) {
            TagEntry.this.text.setText(((MenuItem)event.widget).getText());
        }
    };
    private Listener onHdrSelect = new Listener(){

        public void handleEvent(Event event) {
            String string = ((MenuItem)event.widget).getText();
            if (TagEntry.this.siblings != null) {
                for (TagEntry tagEntry : TagEntry.this.siblings) {
                    tagEntry.setText(string);
                }
            }
        }
    };
    private List<TagEntry> siblings;
    private Text text;

    public TagEntry(Composite composite, int n, boolean bl) {
        super(composite, n & 0xFFFFF7FF);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: 
                    case 16: 
                    case 24: {
                        TagEntry.this.notifyListeners(event.type, null);
                        break;
                    }
                    case 13: {
                        Button button = (Button)event.widget;
                        Point point = button.toDisplay(0, button.getSize().y);
                        TagEntry.this.mTemplates.setLocation(point);
                        TagEntry.this.mTemplates.setVisible(true);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        };
        this.text = new Text((Composite)this, n);
        this.text.setEditable(!bl);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.addListener(15, listener);
        this.text.addListener(16, listener);
        this.text.addListener(24, listener);
        this.btnArrow = new Button((Composite)this, 1028);
        this.btnArrow.setLayoutData((Object)new GridData(131072, 4, false, true));
        this.btnArrow.addListener(15, listener);
        this.btnArrow.addListener(16, listener);
        this.btnArrow.addListener(13, listener);
        this.mTemplates = new Menu((Control)this.btnArrow);
        if (!bl) {
            this.miAdvanced = new MenuItem(this.mTemplates, 64);
            this.miAdvanced.setText(UIMsg.TagEntry_insertTag);
            this.miAdvanced.setMenu(new Menu(this.miAdvanced));
        }
    }

    private MenuItem createTagMenuItem(String string) {
        MenuItem menuItem = new MenuItem(this.miAdvanced.getMenu(), 0, 0);
        menuItem.setText(string);
        menuItem.addListener(13, this.onAdvanced);
        return menuItem;
    }

    private MenuItem createTemplateMenuItem(String string) {
        MenuItem menuItem = new MenuItem(this.mTemplates, 0, 0);
        menuItem.setText(string);
        if (this.miAdvanced == null) {
            menuItem.addListener(13, this.onHdrSelect);
        } else {
            menuItem.addListener(13, this.onFtrSelect);
        }
        return menuItem;
    }

    public void dispose() {
        super.dispose();
        if (this.siblings != null) {
            this.siblings.clear();
        }
    }

    public String getText() {
        return this.text.getText();
    }

    public boolean isFocusControl() {
        return this.text.isFocusControl() || this.btnArrow.isFocusControl();
    }

    public void setEnabled(boolean bl) {
        this.text.setEnabled(bl);
        this.btnArrow.setEnabled(bl);
    }

    public void setSiblings(List<TagEntry> list) {
        this.siblings = list;
    }

    public void setTags(Collection<String> collection) {
        String[] stringArray;
        if (this.miAdvanced == null) {
            return;
        }
        MenuItem[] menuItemArray = this.miAdvanced.getMenu().getItems();
        int n = menuItemArray.length - 1;
        while (n >= 0) {
            stringArray = menuItemArray[n];
            if (stringArray != this.miAdvanced) {
                stringArray.dispose();
            }
            --n;
        }
        n = collection.size();
        stringArray = collection.toArray(new String[n]);
        int n2 = n - 1;
        while (n2 >= 0) {
            this.createTagMenuItem(stringArray[n2]);
            --n2;
        }
    }

    public void setTemplates(Collection<String> collection) {
        String[] stringArray;
        MenuItem[] menuItemArray = this.mTemplates.getItems();
        int n = menuItemArray.length - 1;
        while (n >= 0) {
            stringArray = menuItemArray[n];
            if (stringArray != this.miAdvanced) {
                stringArray.dispose();
            }
            --n;
        }
        n = collection.size();
        stringArray = collection.toArray(new String[n]);
        int n2 = n - 1;
        while (n2 >= 0) {
            this.createTemplateMenuItem(stringArray[n2]);
            --n2;
        }
        if (this.miAdvanced != null) {
            new MenuItem(this.mTemplates, 2, n);
        }
    }

    public void setText(String string) {
        this.text.setText(string);
    }
}

