/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.DocType;
import com.deltawalker.IPersistable;
import com.deltawalker.IStorageNotifier;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.ui.DiffView;
import com.deltopia.io.StorageEvent;
import java.io.IOException;

public class RefreshFromStorageRunnable
implements Runnable {
    private final StorageEvent event;
    private final IDoc doc;
    private final DiffView dView;

    public RefreshFromStorageRunnable(IDoc iDoc, StorageEvent storageEvent, DiffView diffView) {
        this.doc = iDoc;
        this.event = storageEvent;
        this.dView = diffView;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RefreshFromStorageRunnable)) {
            return false;
        }
        RefreshFromStorageRunnable refreshFromStorageRunnable = (RefreshFromStorageRunnable)object;
        return this.dView == refreshFromStorageRunnable.dView && this.doc instanceof IPersistable && refreshFromStorageRunnable.doc instanceof IPersistable;
    }

    @Override
    public void run() {
        DocType docType = this.doc.docType();
        if (docType.isImage() || docType.isText()) {
            this.dView.compare();
        } else if (this.event != null) {
            try {
                ((IStorageNotifier)this.event.getSource()).refreshFromStorage(this.event.getCauses());
            }
            catch (IOException iOException) {}
        } else {
            try {
                IResource iResource = this.doc.resource();
                if (iResource instanceof IPersistableResource) {
                    ((IPersistableResource)((Object)iResource)).load(null, null);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

