/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.resources.IResource;
import com.deltawalker.ui.Alert;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltopia.io.FileType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class RefreshFromStorageAlert
extends Alert {
    private DiffView dView;
    private Set<Runnable> runnables = new HashSet<Runnable>();
    private Set<IResource> sources = new HashSet<IResource>();

    public RefreshFromStorageAlert(DiffView diffView, IResource iResource, Runnable runnable) {
        this.setStyle(194);
        this.dView = diffView;
        this.add(iResource, runnable);
    }

    public synchronized void add(IResource iResource, Runnable runnable) {
        if (iResource == null) {
            throw new IllegalArgumentException("source");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable");
        }
        if (!this.sources.contains(iResource)) {
            this.sources.add(iResource);
            this.runnables.add(runnable);
            int n = this.sources.size();
            String string = iResource.getType() == FileType.FILE ? (n <= 1 ? UIMsg.RefreshFromStorageQuestion_text_singleFile : UIMsg.RefreshFromStorageQuestion_text_multipleFiles) : (n <= 1 ? UIMsg.RefreshFromStorageQuestion_text_singleFolder : UIMsg.RefreshFromStorageQuestion_text_multipleFolders);
            String string2 = "";
            boolean bl = this.sources.size() > 1;
            Iterator<IResource> iterator = this.sources.iterator();
            while (iterator.hasNext()) {
                string2 = String.valueOf(string2) + iterator.next().getName();
                if (!bl) continue;
                string2 = String.valueOf(string2) + ", ";
            }
            if (string2.endsWith(", ")) {
                string2 = string2.substring(0, string2.length() - ", ".length());
            }
            this.setText(NLS.bind((String)string, (Object)string2));
        }
    }

    @Override
    public void dispose() {
        if (this.dView != null) {
            if (this.getReturnCode() == 64) {
                this.dView.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (Runnable runnable : RefreshFromStorageAlert.this.runnables) {
                            runnable.run();
                        }
                    }
                });
            }
            this.dView = null;
        }
        super.dispose();
    }
}

