/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LogItemWorkbenchAdapter
implements IWorkbenchAdapter,
IAdaptable {
    private static final Object[] NO_CHILDREN = new Object[0];
    Item item;
    private final Object parent;

    public LogItemWorkbenchAdapter(Item item, Object object) {
        this.item = item;
        this.parent = object;
    }

    public Object getAdapter(Class clazz) {
        return IWorkbenchAdapter.class.equals((Object)clazz) ? this : null;
    }

    public Object[] getChildren(Object object) {
        return NO_CHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object object) {
        return this.item.displayName();
    }

    public Object getParent(Object object) {
        return this.parent;
    }

    public Item item() {
        return this.item;
    }

    public String toString() {
        return this.item.displayName();
    }

    public static enum Item {
        DELTOPIA("Deltopia Core", "com.deltopia"),
        DW_APP("Application Logic", "com.deltawalker.product.application"),
        DW_CORE("DeltaWalker Core", "com.deltawalker"),
        DW_FOLDER("Folder Comparison", "com.deltawalker.structure"),
        DW_HTML("HTML Comparison", "com.deltawalker.html"),
        DW_IMAGE("Image Comparison", "com.deltawalker.image"),
        DW_TEXT("Text Comparison", "com.deltawalker.text"),
        DW_VFS("Virtual File System", "com.deltawalker.vfs"),
        DW_XML("XML Comparison", "com.deltawalker.xml");

        private static Map<String, Item> str2enum;
        private final String dispName;
        private final String pluginName;
        private final List<String> plugins;

        static {
            str2enum = new HashMap<String, Item>();
            Item[] itemArray = Item.values();
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                str2enum.put(item.pluginName, item);
                ++n2;
            }
        }

        public static Item fromPluginName(String string) {
            return str2enum.get(string);
        }

        private Item(String string2, String ... stringArray) {
            this.dispName = string2;
            this.plugins = Arrays.asList(stringArray);
            this.pluginName = stringArray[0];
        }

        public String displayName() {
            return this.dispName;
        }

        public String pluginName() {
            return this.pluginName;
        }

        public List<String> plugins() {
            return this.plugins;
        }
    }
}

