/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.App;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Relation;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.resources.FileResource;
import com.deltawalker.script.Role;
import com.deltawalker.sessions.HistoryTreeFilter;
import com.deltawalker.structure.TreeUtil;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryTree
extends Composite
implements ISelectionProvider {
    private static final int COLUMN_PADDING = OS.OSX ? 70 : 80;
    private static final Logger LOG = LoggerFactory.getLogger(HistoryTree.class);
    private static final String ROLE_KEY = String.valueOf(HistoryTree.class.getName()) + ".role";
    private static final int SEARCH_MARGIN = OS.COCOA ? 2 : 0;
    public static final int URI_COLUMN_WIDTH = 330;
    private static final int VISIBLE_ITEM_COUNT = 16;
    private boolean canLaunch = true;
    private Set<IDiffDoc> entries;
    private boolean mouseDown = false;
    private final boolean organize;
    private boolean threeWay = true;
    private int timeColWidth = 100;
    private HistoryTreeFilter treeFilter;
    private TreeViewer treeViewer;
    private FileType type;
    private int uriColWidth = 330;

    private static void addHistoryEntry(List<IDiffDoc> list, IDiffDoc iDiffDoc) {
        int n = list.size();
        if (n == 0) {
            list.add(iDiffDoc);
        } else {
            long l = iDiffDoc.getTimeLastOpened();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (list.get(n2).getTimeLastOpened() < l) {
                    list.add(n2, iDiffDoc);
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                list.add(iDiffDoc);
            }
        }
    }

    private static List<TimeSpan> createTimeSpans() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.getMaximum(11));
        calendar.set(12, calendar.getMaximum(12));
        calendar.set(13, calendar.getMaximum(13));
        calendar.set(14, calendar.getMaximum(14));
        long l = calendar.getTimeInMillis();
        calendar.set(11, calendar.getMinimum(11));
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        calendar.set(14, calendar.getMinimum(14));
        long l2 = calendar.getTimeInMillis();
        TimeSpan timeSpan = new TimeSpan(l2, l, UIMsg.HistoryTree_today);
        long l3 = l2 - 1L;
        calendar.roll(5, false);
        long l4 = calendar.getTimeInMillis();
        TimeSpan timeSpan2 = new TimeSpan(l4, l3, UIMsg.HistoryTree_yesterday);
        long l5 = l4 - 1L;
        TimeSpan timeSpan3 = new TimeSpan(0L, l5, UIMsg.HistoryTree_earlier);
        return Arrays.asList(timeSpan, timeSpan2, timeSpan3);
    }

    private static TimeSpan findTimeSpan(List<TimeSpan> list, long l) {
        for (TimeSpan timeSpan : list) {
            if (timeSpan.from > l || l > timeSpan.to) continue;
            return timeSpan;
        }
        return null;
    }

    public HistoryTree(Composite composite, int n, FileType fileType, boolean bl) {
        super(composite, n | 0x800);
        GC gC = new GC((Drawable)this);
        gC.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        this.timeColWidth = gC.stringExtent((String)"00/00/00 00:00:00").x;
        this.setupLayout();
        this.type = fileType;
        this.organize = bl;
        IDocBoss iDocBoss = App.instance().docBoss();
        this.entries = iDocBoss.getAll(fileType, false);
        this.showThreeWay(iDocBoss.hasThreeWay(this.entries));
        this.createTreeViewer(n);
        Color color = this.getDisplay().getSystemColor(25);
        this.setBackground(color);
        this.createSearchControl(color);
        this.inputChanged();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    private void clearItemImages(TreeItem treeItem) {
        Tree tree = this.treeViewer.getTree();
        int n = tree.getColumnCount();
        List<TreeItem> list = TreeUtil.getItems(tree, true);
        for (TreeItem treeItem2 : list) {
            if (treeItem2 == treeItem) continue;
            Column[] columnArray = Column.values();
            int n2 = columnArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Column column = columnArray[n3];
                int n4 = Column.index(column, n);
                if (column == Column.FAVORITE) {
                    Object object;
                    if (treeItem2 != null && (object = treeItem2.getData()) instanceof IDiffDoc) {
                        boolean bl = ((IDiffDoc)object).isFavorite();
                        treeItem2.setImage(n4, bl ? column.image(true) : null);
                    }
                } else {
                    treeItem2.setImage(n4, null);
                }
                ++n3;
            }
        }
    }

    private Point computeCellEditorSize() {
        Tree tree = this.treeViewer.getTree();
        int n = 0;
        int n2 = Relation.roles(this.threeWay).size();
        int n3 = 0;
        while (n3 < n2) {
            TreeColumn treeColumn = tree.getColumn(n3);
            n += treeColumn.getWidth();
            ++n3;
        }
        n3 = Column.FAVORITE.width() * 2 + (OS.OSX ? 0 : (OS.WIN ? 8 : 6));
        return new Point(n - n3, tree.getItemHeight());
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = super.computeSize(n, n2, bl);
        if (this.treeViewer != null) {
            int n3;
            if (n2 == -1) {
                Tree tree = this.treeViewer.getTree();
                point.y = 2 * tree.getBorderWidth() + 16 * tree.getItemHeight();
            }
            if (n == -1 && point.x < (n3 = 990 + this.timeColWidth)) {
                point.x = n3;
            }
        }
        return point;
    }

    public void copySelectedCreationDate() {
        Set<IDiffDoc> set = this.getSelectedSessions();
        if (set.iterator().hasNext()) {
            IDiffDoc iDiffDoc = set.iterator().next();
            UIUtil.copyTextToClipboard(iDiffDoc.displayCreationTime());
        }
    }

    private void createSearchControl(Color color) {
        Text text = new Text((Composite)this, 2948);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.verticalIndent = SEARCH_MARGIN;
        text.setLayoutData((Object)gridData);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        if ((text.getStyle() & 0x100) == 0) {
            ToolBar toolBar = toolBarManager.createControl((Composite)this);
            toolBar.setBackground(color);
            gridData = new GridData(1, 0x1000000, false, false);
            gridData.verticalIndent = 0;
            toolBar.setLayoutData((Object)gridData);
        }
        this.treeFilter.connectSearchControl((IToolBarManager)toolBarManager, text, true);
    }

    private void createTreeViewer(int n) {
        Role role2;
        Tree tree = new Tree((Composite)this, n | 0x10000 | 2);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = OS.OSX ? 1 : 2;
        tree.setLayoutData((Object)gridData);
        tree.getHorizontalBar().setVisible(false);
        tree.setHeaderVisible(true);
        Set<Role> set = Relation.roles(this.threeWay);
        for (Role role2 : set) {
            TreeColumn treeColumn = new TreeColumn(tree, 16384);
            treeColumn.setData(ROLE_KEY, (Object)role2);
            treeColumn.setText(role2.getDisplayName(this.threeWay));
            treeColumn.setWidth(role2 == Relation.firstRole(this.threeWay) ? 330 + COLUMN_PADDING : 330 - COLUMN_PADDING);
        }
        role2 = new TreeColumn(tree, 16384);
        role2.setWidth(this.timeColWidth);
        role2.setText("Time Created");
        role2 = new TreeColumn(tree, 16384);
        role2.setWidth(Column.FAVORITE.width());
        if (!OS.WIN) {
            role2.setImage(Column.FAVORITE.image(true));
        }
        role2 = new TreeColumn(tree, 16384);
        role2.setWidth(Column.DELETE.width());
        if (!OS.WIN) {
            role2.setImage(Column.DELETE.image(false));
        }
        role2 = new TreeColumn(tree, 16384);
        role2.setWidth(Column.RENAME.width());
        if (!OS.WIN) {
            role2.setImage(Column.RENAME.image(false));
        }
        this.treeViewer = new TreeViewer(tree){

            protected void setExpanded(Item item, boolean bl) {
                super.setExpanded(item, bl);
                this.getControl().update();
            }
        };
        this.treeViewer.setContentProvider((IContentProvider)new HistoryTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SessionTreeLabelProvider());
        this.treeViewer.addFilter((ViewerFilter)new TimeSpanViewerFilter());
        this.treeFilter = new HistoryTreeFilter(this.treeViewer, UIMsg.HistoryTree_searchToolTip, App.instance().docBoss().hasThreeWay(this.entries));
        this.installToolTips(tree);
        this.installListeners(tree);
        this.installCellEditors();
        this.installSorter();
    }

    public void deleteSelectedSessions() {
        Set<IDiffDoc> set = this.getSelectedSessions();
        App.instance().docBoss().removeAll(set);
        this.entries.removeAll(set);
        this.inputChanged();
        this.clearItemImages(null);
    }

    public void editSelectedTreeItem() {
        Set<IDiffDoc> set = this.getSelectedSessions();
        if (set.iterator().hasNext()) {
            this.treeViewer.editElement((Object)set.iterator().next(), 0);
        }
    }

    private Column getColumnType(Tree tree, int n, int n2) {
        Object[] objectArray = TreeUtil.getViewableElements(tree);
        Point point = new Point(-1, -1);
        TreeItem treeItem = tree.getItem(new Point(n, n2));
        if (treeItem == null) {
            return null;
        }
        int n3 = tree.getColumnCount();
        int n4 = 0;
        while (n4 < objectArray.length) {
            Object object = objectArray[n4];
            if (!(object instanceof TimeSpan) && object.equals(treeItem.getData())) {
                Column[] columnArray = Column.values();
                int n5 = columnArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Column column = columnArray[n6];
                    int n7 = Column.index(column, n3);
                    Rectangle rectangle = treeItem.getBounds(n7);
                    if (rectangle.contains(n, n2)) {
                        point.x = n4;
                        point.y = 2;
                        return column;
                    }
                    ++n6;
                }
            }
            ++n4;
        }
        return null;
    }

    private Image getFavoriteImage(boolean bl) {
        return bl ? ImageCache.getImage(ImageConst.FAVORITE_ON_OVR) : ImageCache.getImage(ImageConst.FAVORITE_OFF_OVR);
    }

    public Set<IDiffDoc> getSelectedSessions() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.treeViewer.getSelection();
        List list = iStructuredSelection.toList();
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        TreeSet<IDiffDoc> treeSet = new TreeSet<IDiffDoc>();
        for (Object e : list) {
            if (iTreeContentProvider.hasChildren(e)) {
                Object[] objectArray;
                Object[] objectArray2 = objectArray = iTreeContentProvider.getChildren(e);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray2[n2];
                    treeSet.add((IDiffDoc)object);
                    ++n2;
                }
                continue;
            }
            if (treeSet.contains(e)) continue;
            treeSet.add((IDiffDoc)e);
        }
        return treeSet;
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.treeViewer.getSelection();
    }

    private String getToolTipText(Event event) {
        Object object;
        TreeItem treeItem;
        Tree tree = this.treeViewer.getTree();
        if (event.widget == tree && (treeItem = tree.getItem(new Point(event.x, event.y))) != null && (object = treeItem.getData()) != null) {
            int n = -1;
            int n2 = tree.getColumnCount();
            int n3 = 0;
            while (n3 < n2) {
                Rectangle rectangle = treeItem.getBounds(n3);
                if (rectangle.x <= event.x && event.x < rectangle.x + rectangle.width) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (n >= 0 && n < Column.index(Column.FAVORITE, n2)) {
                return ((SessionTreeLabelProvider)this.treeViewer.getLabelProvider()).getColumnToolTipText(object, n);
            }
        }
        return null;
    }

    private void inputChanged() {
        IDocBoss iDocBoss = App.instance().docBoss();
        this.entries = iDocBoss.getAll(this.type, false);
        if (this.entries.size() < 16) {
            this.treeViewer.getTree().getVerticalBar().setVisible(false);
        }
        HashMap hashMap = new HashMap();
        List<TimeSpan> list = HistoryTree.createTimeSpans();
        for (IDiffDoc iDiffDoc : this.entries) {
            TimeSpan timeSpan;
            if (!iDiffDoc.shouldBeInHistory() || (timeSpan = HistoryTree.findTimeSpan(list, iDiffDoc.getTimeLastOpened())) == null) continue;
            ArrayList arrayList = (ArrayList)hashMap.get(timeSpan);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(timeSpan, arrayList);
            }
            HistoryTree.addHistoryEntry(arrayList, iDiffDoc);
        }
        this.treeViewer.setInput(hashMap);
        this.treeViewer.expandAll();
        this.showThreeWay(iDocBoss.hasThreeWay(this.entries));
    }

    private void installCellEditors() {
        this.treeViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object object, String string) {
                return true;
            }

            public Object getValue(Object object, String string) {
                return ((IDiffDoc)object).getName();
            }

            public void modify(Object object, String string, Object object2) {
                HistoryTree.this.renameEntry((TreeItem)object, object2.toString());
            }
        });
        this.treeViewer.setColumnProperties(new String[1]);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.treeViewer.getTree(), 2048){

            public CellEditor.LayoutData getLayoutData() {
                CellEditor.LayoutData layoutData = new CellEditor.LayoutData();
                Control control = this.getControl();
                if (control != null) {
                    Point point = HistoryTree.this.computeCellEditorSize();
                    layoutData.minimumWidth = point.x;
                    layoutData.minimumHeight = point.y + 2;
                }
                return layoutData;
            }
        };
        this.treeViewer.setCellEditors(new CellEditor[]{textCellEditor});
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
                return columnViewerEditorActivationEvent.eventType == 4;
            }
        }, (int)1);
    }

    private void installContextMenu() {
        Menu menu = new Menu(this.treeViewer.getControl());
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HistoryTree.this.editSelectedTreeItem();
            }
        });
        menuItem.setText(UIMsg.OrganizeHistoryDlg_btnRename);
        final MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HistoryTree.this.deleteSelectedSessions();
            }
        });
        menuItem2.setText(UIMsg.OrganizeHistoryDlg_btnDelete);
        new MenuItem(menu, 2);
        final MenuItem menuItem3 = new MenuItem(menu, 8);
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HistoryTree.this.copySelectedCreationDate();
            }
        });
        menuItem3.setText(UIMsg.OrganizeHistoryDlg_copyCreationTime);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)HistoryTree.this.treeViewer.getSelection();
                menuItem.setEnabled(iStructuredSelection.getFirstElement() instanceof IDiffDoc);
                menuItem2.setEnabled(HistoryTree.this.getSelectedSessions().size() > 0);
                menuItem3.setEnabled(HistoryTree.this.getSelectedSessions().size() > 0);
            }
        });
        this.treeViewer.getTree().setMenu(menu);
    }

    private void installListeners(final Tree tree) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        Column column = HistoryTree.this.getColumnType(tree, event.x, event.y);
                        if (column != null) {
                            TreeItem treeItem = (TreeItem)event.item;
                            if (treeItem == null) {
                                treeItem = tree.getItem(new Point(event.x, event.y));
                            }
                            if (treeItem == null) break;
                            HistoryTree.this.clearItemImages(treeItem);
                            HistoryTree.this.mouseDown = true;
                            if (column == Column.FAVORITE) {
                                IDiffDoc iDiffDoc;
                                iDiffDoc.setFavorite(!(iDiffDoc = (IDiffDoc)treeItem.getData()).isFavorite());
                                int n = Column.index(Column.FAVORITE, tree.getColumnCount());
                                treeItem.setImage(n, HistoryTree.this.getFavoriteImage(iDiffDoc.isFavorite()));
                            } else if (column == Column.DELETE) {
                                HistoryTree.this.deleteSelectedSessions();
                            } else if (column == Column.RENAME) {
                                HistoryTree.this.editSelectedTreeItem();
                            } else {
                                HistoryTree.this.mouseDown = false;
                            }
                            HistoryTree.this.canLaunch = false;
                            break;
                        }
                        HistoryTree.this.canLaunch = event.button == 1;
                        break;
                    }
                    case 11: {
                        HistoryTree.this.resizeColumns();
                        break;
                    }
                    case 5: {
                        TreeItem treeItem = (TreeItem)event.item;
                        if (treeItem == null) {
                            treeItem = tree.getItem(new Point(event.x, event.y));
                        }
                        if (treeItem == null || !(treeItem.getData() instanceof IDiffDoc)) break;
                        IDiffDoc iDiffDoc = (IDiffDoc)treeItem.getData();
                        int n = HistoryTree.this.treeViewer.getTree().getColumnCount();
                        Column[] columnArray = Column.values();
                        int n2 = columnArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Column column = columnArray[n3];
                            int n4 = Column.index(column, n);
                            if (column == Column.FAVORITE) {
                                treeItem.setImage(n4, column.image(iDiffDoc.isFavorite()));
                            } else {
                                treeItem.setImage(n4, column.image(false));
                            }
                            ++n3;
                        }
                        HistoryTree.this.clearItemImages(treeItem);
                        break;
                    }
                    case 7: {
                        HistoryTree.this.clearItemImages(null);
                    }
                }
            }
        };
        tree.addListener(3, listener);
        tree.addListener(5, listener);
        tree.addListener(7, listener);
        tree.addListener(11, listener);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                Object object = ((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
                if (object instanceof TimeSpan) {
                    boolean bl = HistoryTree.this.treeViewer.getExpandedState(object);
                    HistoryTree.this.treeViewer.setExpandedState(object, !bl);
                    HistoryTree.this.treeViewer.getControl().update();
                }
            }
        });
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TreeItem[] treeItemArray;
                TreeItem[] treeItemArray2 = treeItemArray = tree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray2[n2];
                    HistoryTree.this.itemSelected((Widget)treeItem);
                    ++n2;
                }
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!HistoryTree.this.organize && HistoryTree.this.canLaunch) {
                    TreeItem[] treeItemArray;
                    TreeItem[] treeItemArray2 = treeItemArray = tree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem treeItem = treeItemArray2[n2];
                        HistoryTree.this.itemSelected((Widget)treeItem);
                        ++n2;
                    }
                }
            }
        });
        this.installContextMenu();
    }

    private void installSorter() {
        this.treeViewer.setComparator(new ViewerComparator(){

            public int category(Object object) {
                if (object instanceof TimeSpan) {
                    String string = ((TimeSpan)object).name;
                    if (string.equals(TimeSpan.TODAY)) {
                        return 0;
                    }
                    if (string.equals(TimeSpan.YESTERDAY)) {
                        return 1;
                    }
                    if (!$assertionsDisabled && !string.equals(TimeSpan.EARLIER)) {
                        throw new AssertionError();
                    }
                    return 2;
                }
                return 0;
            }

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof IDiffDoc && object2 instanceof IDiffDoc) {
                    long l;
                    long l2 = ((IDiffDoc)object).getTimeLastOpened();
                    if (l2 == (l = ((IDiffDoc)object2).getTimeLastOpened())) {
                        return 0;
                    }
                    if (l2 > l) {
                        return -1;
                    }
                    return 1;
                }
                return super.compare(viewer, object, object2);
            }
        });
    }

    private void installToolTips(final Tree tree) {
        tree.setToolTipText("");
        DefaultToolTip defaultToolTip = new DefaultToolTip((Control)tree){

            protected String getText(Event event) {
                Column column = HistoryTree.this.getColumnType(tree, event.x, event.y);
                if (column == null) {
                    return HistoryTree.this.getToolTipText(event);
                }
                switch (HistoryTree.this.getColumnType(tree, event.x, event.y)) {
                    case FAVORITE: {
                        return UIMsg.HistoryTree_favoriteToolTip;
                    }
                    case DELETE: {
                        return UIMsg.HistoryTree_deleteToolTip;
                    }
                    case RENAME: {
                        return UIMsg.HistoryTree_renameToolTip;
                    }
                }
                return super.getText(event);
            }

            protected boolean shouldCreateToolTip(Event event) {
                if (!super.shouldCreateToolTip(event)) {
                    return false;
                }
                return this.getText(event) != null;
            }
        };
        defaultToolTip.setPopupDelay(0);
    }

    private void itemSelected(Widget widget) {
        Object object;
        if (widget != null && !widget.isDisposed() && (object = widget.getData()) instanceof IDiffDoc) {
            Object object2;
            if (!this.isDisposed()) {
                object2 = this.getShell();
                object2.dispose();
            }
            object2 = App.instance().viewBoss();
            IDiffDoc iDiffDoc = (IDiffDoc)object;
            if (iDiffDoc.getHasOpenView()) {
                List<DiffView> list = object2.viewsOnDoc(iDiffDoc.getId());
                if (!list.isEmpty()) {
                    IWorkbenchPartSite iWorkbenchPartSite = list.get(0).getSite();
                    iWorkbenchPartSite.getPage().activate(iWorkbenchPartSite.getPart());
                    if (iDiffDoc.isModified()) {
                        list.get(0).compare();
                    }
                } else {
                    LOG.warn("An opened document without a view?");
                    App.instance().viewBoss().viewDoc(iDiffDoc, true);
                }
            } else {
                App.instance().viewBoss().viewDoc(iDiffDoc, true);
            }
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void renameEntry(TreeItem treeItem, String string) {
        try {
            ((IDiffDoc)treeItem.getData()).setName(string);
            this.treeViewer.update(treeItem.getData(), null);
        }
        catch (Exception exception) {
            LOG.warn(exception.getLocalizedMessage());
        }
    }

    private void resizeColumns() {
        Tree tree = this.treeViewer.getTree();
        int n = tree.getClientArea().width;
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        TreeColumn treeColumn = Column.values();
        int n3 = ((Column[])treeColumn).length;
        int n4 = 0;
        while (n4 < n3) {
            Column column = treeColumn[n4];
            n2 = column == Column.TIME ? (n2 += this.timeColWidth) : (n2 += column.width());
            ++n4;
        }
        int n5 = (n - n2) / (this.threeWay ? 3 : 2) - (OS.COCOA && !this.threeWay ? 1 : 0);
        n4 = Relation.roles(this.threeWay).size();
        n3 = 0;
        while (n3 < n4) {
            treeColumn = tree.getColumn(n3);
            int n6 = 0;
            Role role = (Role)((Object)treeColumn.getData(ROLE_KEY));
            n6 = n5;
            n6 = role == Relation.firstRole(this.threeWay) ? (n6 += 20) : (n6 -= 20);
            if (role == Relation.lastRole(this.threeWay)) {
                this.uriColWidth = n6;
            }
            treeColumn.setWidth(n6);
            ++n3;
        }
    }

    public void setSelection(ISelection iSelection) {
        this.treeViewer.setSelection(iSelection);
    }

    public void setType(FileType fileType) {
        if (this.type != fileType) {
            this.type = fileType;
            this.inputChanged();
        }
    }

    private void setupLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = OS.OSX ? 1 : 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = SEARCH_MARGIN;
        gridLayout.marginRight = SEARCH_MARGIN;
        gridLayout.marginBottom = SEARCH_MARGIN;
        this.setLayout((Layout)gridLayout);
    }

    private void showThreeWay(boolean bl) {
        this.threeWay = bl;
        if (this.treeViewer != null) {
            this.resizeColumns();
        }
    }

    static enum Column {
        DELETE(1, 24, ImageConst.DELETE_OVR, null),
        FAVORITE(2, 24, ImageConst.FAVORITE_OFF_OVR, ImageConst.FAVORITE_ON_OVR),
        RENAME(0, 24, ImageConst.EDIT_OVR, null),
        TIME(3, 100, null, null);

        private final String imgPath;
        private final int reverseIx;
        private final String selImgPath;
        private final int width;

        public static int index(Column column, int n) {
            return n - column.reverseIndex() - 1;
        }

        private Column(int n2, int n3, String string2, String string3) {
            this.reverseIx = n2;
            this.width = n3;
            this.selImgPath = string3;
            this.imgPath = string2;
        }

        public Image image(boolean bl) {
            if (bl) {
                return StringUtil.isEmpty((String)this.selImgPath) ? null : ImageCache.getImage(this.selImgPath);
            }
            return StringUtil.isEmpty((String)this.imgPath) ? null : ImageCache.getImage(this.imgPath);
        }

        public int reverseIndex() {
            return this.reverseIx;
        }

        public int width() {
            return this.width;
        }
    }

    private class HistoryTreeContentProvider
    implements ITreeContentProvider {
        private HistoryTreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object object) {
            List list;
            if (object instanceof TimeSpan && (list = (List)((Map)HistoryTree.this.treeViewer.getInput()).get(object)) != null) {
                return list.toArray();
            }
            return null;
        }

        public Object[] getElements(Object object) {
            return ((Map)object).keySet().toArray();
        }

        public Object getParent(Object object) {
            if (object instanceof TimeSpan) {
                return HistoryTree.this.treeViewer.getInput();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof TimeSpan) {
                List list = (List)((Map)HistoryTree.this.treeViewer.getInput()).get(object);
                return list != null && list.size() > 0;
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class SessionTreeLabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private SessionTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object object, int n) {
            Image image;
            block6: {
                IDiffDoc iDiffDoc;
                block7: {
                    image = null;
                    if (!(object instanceof IDiffDoc)) break block6;
                    iDiffDoc = (IDiffDoc)object;
                    Role role = (Role)((Object)HistoryTree.this.treeViewer.getTree().getColumn(n).getData(ROLE_KEY));
                    if (role == null) break block7;
                    if (n > 0 && !iDiffDoc.getName().isEmpty()) {
                        return null;
                    }
                    String string = iDiffDoc.uriInfo(role).displayUri();
                    if (StringUtil.isEmpty((String)string)) break block6;
                    FileUtil.ProgramInfo programInfo = FileUtil.getImageFromExtension((String)FileUtil.getExtension((String)string), (Point)FileResource.getImageSize());
                    if (programInfo != null) {
                        image = programInfo.image;
                    }
                    if (image != null) break block6;
                    image = ImageCache.getImage(iDiffDoc.fileType().imagePath());
                    break block6;
                }
                int n2 = HistoryTree.this.treeViewer.getTree().getColumnCount();
                Column[] columnArray = Column.values();
                int n3 = columnArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Column column = columnArray[n4];
                    if (n == Column.index(column, n2)) {
                        if (column == Column.FAVORITE) {
                            boolean bl = iDiffDoc.isFavorite();
                            if (HistoryTree.this.mouseDown) {
                                return column.image(bl);
                            }
                            return bl ? column.image(true) : null;
                        }
                        return column.image(!HistoryTree.this.mouseDown);
                    }
                    ++n4;
                }
            }
            return image;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof TimeSpan) {
                if (n == 0) {
                    return ((TimeSpan)object).name;
                }
            } else if (object instanceof IDiffDoc) {
                IDiffDoc iDiffDoc = (IDiffDoc)object;
                if (n == Column.index(Column.TIME, HistoryTree.this.treeViewer.getTree().getColumnCount())) {
                    return TimeFormatter.formatShort(iDiffDoc.getTimeCreated());
                }
                String string = iDiffDoc.getName();
                if (!StringUtil.isEmpty((String)string)) {
                    return n == 0 ? string : null;
                }
                Role role = (Role)((Object)HistoryTree.this.treeViewer.getTree().getColumn(n).getData(ROLE_KEY));
                if (role == null) {
                    return null;
                }
                string = iDiffDoc.uriInfo(role).displayUri();
                int n2 = HistoryTree.this.threeWay ? -50 : 90;
                return StringUtil.ellipsize((String)string, (Control)HistoryTree.this.treeViewer.getControl(), (int)(HistoryTree.this.uriColWidth + n2));
            }
            return null;
        }

        public String getColumnToolTipText(Object object, int n) {
            if (object instanceof IDiffDoc) {
                Role role = (Role)((Object)HistoryTree.this.treeViewer.getTree().getColumn(n).getData(ROLE_KEY));
                return ((IDiffDoc)object).uriInfo(role).displayUri();
            }
            return null;
        }

        public Font getFont(Object object, int n) {
            return HistoryTree.this.treeFilter.getBoldFont(object);
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private static class TimeSpan {
        public static final String EARLIER = UIMsg.HistoryTree_earlier;
        public static final String TODAY = UIMsg.HistoryTree_today;
        public static final String YESTERDAY = UIMsg.HistoryTree_yesterday;
        public final long from;
        public final String name;
        public final long to;

        public TimeSpan(long l, long l2, String string) {
            this.from = l;
            this.to = l2;
            this.name = string;
        }
    }

    private static class TimeSpanViewerFilter
    extends ViewerFilter {
        private TimeSpanViewerFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof TimeSpan) {
                return ((ITreeContentProvider)((ContentViewer)viewer).getContentProvider()).hasChildren(object2);
            }
            return true;
        }
    }
}

