/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.ui.StatusLineCLabelContribution;
import com.deltawalker.ui.UIMsg;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class EditorActionContributor
extends EditorActionBarContributor {
    private static final String[] ACTIONS = new String[]{ITextEditorActionConstants.UNDO, ITextEditorActionConstants.REDO, ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.SELECT_ALL, ITextEditorActionConstants.FIND, ITextEditorActionConstants.PROPERTIES, ITextEditorActionConstants.REVERT};
    static final int DEFAULT_WIDTH_IN_CHARS = 14;
    private static final StatusFieldDef[] STATUS_FIELD_DEFS = new StatusFieldDef[]{new StatusFieldDef("findField", null, false, UIMsg.Editor_FindIncremental_reverse_name.length() + 15), new StatusFieldDef("InputMode", "org.eclipse.ui.edit.text.toggleOverwrite", true, 14), new StatusFieldDef("InputPosition", "GotoLine", true, 14)};
    private IEditorPart fActiveEditorPart;
    private RetargetTextEditorAction fFindNext = new RetargetTextEditorAction(UIMsg.constructedKeyBundle(), "Editor.FindNext.");
    private RetargetTextEditorAction fFindPrevious;
    private RetargetTextEditorAction fGotoLine;
    private RetargetTextEditorAction fIncrementalFind;
    private RetargetTextEditorAction fIncrementalFindReverse;
    private Map<StatusFieldDef, StatusLineCLabelContribution> fStatusFields;

    public EditorActionContributor() {
        this.fFindNext.setActionDefinitionId("org.eclipse.ui.edit.findNext");
        this.fFindPrevious = new RetargetTextEditorAction(UIMsg.constructedKeyBundle(), "Editor.FindPrevious.");
        this.fFindPrevious.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
        this.fIncrementalFind = new RetargetTextEditorAction(UIMsg.constructedKeyBundle(), "Editor.FindIncremental.");
        this.fIncrementalFind.setActionDefinitionId("org.eclipse.ui.edit.findIncremental");
        this.fIncrementalFindReverse = new RetargetTextEditorAction(UIMsg.constructedKeyBundle(), "Editor.FindIncrementalReverse.");
        this.fIncrementalFindReverse.setActionDefinitionId("org.eclipse.ui.edit.findIncrementalReverse");
        this.fGotoLine = new RetargetTextEditorAction(UIMsg.constructedKeyBundle(), "Editor.GotoLine.");
        this.fGotoLine.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        this.fStatusFields = new HashMap<StatusFieldDef, StatusLineCLabelContribution>(3);
        int n = 0;
        while (n < STATUS_FIELD_DEFS.length) {
            StatusFieldDef statusFieldDef = STATUS_FIELD_DEFS[n];
            this.fStatusFields.put(statusFieldDef, new StatusLineCLabelContribution(statusFieldDef.category, statusFieldDef.visible, statusFieldDef.widthInChars));
            ++n;
        }
    }

    private void addOrInsert(IContributionManager iContributionManager, IContributionItem iContributionItem) {
        String string = iContributionItem.getId();
        if (iContributionManager.find(string) == null) {
            iContributionManager.add(iContributionItem);
        } else {
            iContributionManager.insertAfter(string, iContributionItem);
        }
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        IMenuManager iMenuManager2;
        IMenuManager iMenuManager3 = iMenuManager.findMenuUsingPath("edit");
        if (iMenuManager3 != null) {
            iMenuManager3.prependToGroup("find.ext", (IAction)this.fIncrementalFindReverse);
            iMenuManager3.prependToGroup("find.ext", (IAction)this.fIncrementalFind);
            iMenuManager3.prependToGroup("find.ext", (IAction)this.fFindPrevious);
            iMenuManager3.prependToGroup("find.ext", (IAction)this.fFindNext);
            this.addOrInsert((IContributionManager)iMenuManager3, (IContributionItem)new Separator("group.open"));
            this.addOrInsert((IContributionManager)iMenuManager3, (IContributionItem)new Separator("group.information"));
            this.addOrInsert((IContributionManager)iMenuManager3, (IContributionItem)new Separator("group.assist"));
            this.addOrInsert((IContributionManager)iMenuManager3, (IContributionItem)new Separator("group.generate"));
            this.addOrInsert((IContributionManager)iMenuManager3, (IContributionItem)new Separator("additions"));
        }
        if ((iMenuManager2 = iMenuManager.findMenuUsingPath("navigate")) != null) {
            iMenuManager2.appendToGroup("additions", (IAction)this.fGotoLine);
        }
    }

    public void contributeToStatusLine(IStatusLineManager iStatusLineManager) {
        super.contributeToStatusLine(iStatusLineManager);
        int n = 0;
        while (n < STATUS_FIELD_DEFS.length) {
            iStatusLineManager.add((IContributionItem)this.fStatusFields.get(STATUS_FIELD_DEFS[n]));
            ++n;
        }
    }

    public void dispose() {
        for (StatusLineCLabelContribution statusLineCLabelContribution : this.fStatusFields.values()) {
            statusLineCLabelContribution.dispose();
        }
        this.fStatusFields.clear();
        this.doSetActiveEditor(null);
        super.dispose();
    }

    private void doSetActiveEditor(IEditorPart iEditorPart) {
        ITextEditorExtension iTextEditorExtension;
        if (this.fActiveEditorPart == iEditorPart) {
            return;
        }
        if (this.fActiveEditorPart instanceof ITextEditorExtension) {
            iTextEditorExtension = (ITextEditorExtension)this.fActiveEditorPart;
            int n = 0;
            while (n < STATUS_FIELD_DEFS.length) {
                iTextEditorExtension.setStatusField(null, STATUS_FIELD_DEFS[n].category);
                ++n;
            }
        }
        this.fActiveEditorPart = iEditorPart;
        iTextEditorExtension = iEditorPart instanceof ITextEditor ? (ITextEditor)iEditorPart : null;
        IActionBars iActionBars = this.getActionBars();
        int n = 0;
        while (n < ACTIONS.length) {
            iActionBars.setGlobalActionHandler(ACTIONS[n], this.getAction((ITextEditor)iTextEditorExtension, ACTIONS[n]));
            ++n;
        }
        this.fFindNext.setAction(this.getAction((ITextEditor)iTextEditorExtension, "FindNext"));
        this.fFindPrevious.setAction(this.getAction((ITextEditor)iTextEditorExtension, "FindPrevious"));
        this.fIncrementalFind.setAction(this.getAction((ITextEditor)iTextEditorExtension, "FindIncremental"));
        this.fIncrementalFindReverse.setAction(this.getAction((ITextEditor)iTextEditorExtension, "FindIncrementalReverse"));
        this.fGotoLine.setAction(this.getAction((ITextEditor)iTextEditorExtension, "GotoLine"));
        n = 0;
        while (n < STATUS_FIELD_DEFS.length) {
            if (this.fActiveEditorPart instanceof ITextEditorExtension) {
                StatusLineCLabelContribution statusLineCLabelContribution = this.fStatusFields.get(STATUS_FIELD_DEFS[n]);
                statusLineCLabelContribution.setActionHandler(this.getAction((ITextEditor)iTextEditorExtension, STATUS_FIELD_DEFS[n].actionId));
                ITextEditorExtension iTextEditorExtension2 = (ITextEditorExtension)this.fActiveEditorPart;
                iTextEditorExtension2.setStatusField((IStatusField)statusLineCLabelContribution, STATUS_FIELD_DEFS[n].category);
            }
            ++n;
        }
    }

    protected final IAction getAction(ITextEditor iTextEditor, String string) {
        return iTextEditor == null || string == null ? null : iTextEditor.getAction(string);
    }

    protected final IEditorPart getActiveEditorPart() {
        return this.fActiveEditorPart;
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        this.doSetActiveEditor(iEditorPart);
    }

    private static class StatusFieldDef {
        private String actionId;
        private String category;
        private boolean visible;
        private int widthInChars;

        private StatusFieldDef(String string, String string2, boolean bl, int n) {
            Assert.isNotNull((Object)string);
            this.category = string;
            this.actionId = string2;
            this.visible = bl;
            this.widthInChars = n;
        }
    }
}

