/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.Addon;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.DocType;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.ViewFactory;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.jface.util.ViewHolder;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWViewHolder
extends ViewHolder {
    private static final Logger LOG = LoggerFactory.getLogger(DWViewHolder.class);
    protected IDiffDoc dDoc;
    private IEditorSite site;

    public DWViewHolder(Composite composite) {
        super(composite);
    }

    @Override
    protected void activeViewChanged(int n, int n2) {
        if (n2 == 1 && !this.isLicensed(n2) || n == n2) {
            return;
        }
        IMvcView iMvcView = this.view(n2, true);
        iMvcView.control().setFocus();
        assert (iMvcView.equals(this.activeView()));
        this.fireActiveViewerChanged(n, n2);
        if (n != -1 && n < this.tabFolder.getItemCount()) {
            IMvcView iMvcView2 = this.view(n, false);
            ((DiffController)iMvcView2.controller()).connectSearchField(false, false);
        }
        ((DiffController)iMvcView.controller()).connectSearchField(true, true);
    }

    @Override
    protected boolean canShowViewer(int n) {
        return n == 1 ? this.isLicensed(n) : true;
    }

    @Override
    protected IMvcView createView(Composite composite, int n) {
        DocType docType = this.dDoc.docType(n);
        DiffView diffView = ViewFactory.getFactory(docType.viewFactoryId()).createDiffView(composite, n);
        if (diffView instanceof DiffView) {
            diffView.setSite(this.site);
        }
        ((Viewer)diffView).setInput((Object)this.dDoc);
        return diffView;
    }

    @Override
    public void createViews(Object object, IEditorSite iEditorSite) {
        if (this.dDoc != object) {
            Object object2;
            int n;
            int n2;
            this.dDoc = (IDiffDoc)object;
            this.site = iEditorSite;
            int n3 = this.dDoc.triadCount();
            if (n3 != (n2 = this.tabFolder.getItemCount())) {
                int n4 = Math.min(n3, n2);
                boolean bl = false;
                n = n2 - 1;
                while (n >= n4) {
                    this.tabFolder.getItem(n).dispose();
                    bl = true;
                    --n;
                }
                n = n4;
                while (n < n3) {
                    CTabItem cTabItem = this.addTab();
                    object2 = this.dDoc.docType(n);
                    cTabItem.setText(((DocType)((Object)object2)).displayName());
                    Image image = ((DocType)((Object)object2)).image();
                    if (object2 == DocType.XML && !this.isLicensed(n)) {
                        Image image2 = ImageCache.getImage(ImageConst.PADLOCK_OVR);
                        image = image.createOverlayCopy(image2, 132096, 0.3, 1.0);
                        cTabItem.setToolTipText(String.valueOf(UIMsg.DWViewHolder_structView) + NLS.bind((String)UIMsg.LicensedAction_availableIn_one, (Object)Addon.Edition.ORO.displayName()));
                    }
                    if (image != null && !image.isDisposed()) {
                        cTabItem.setImage(image);
                    } else {
                        LOG.error(NLS.bind((String)"Invalid image for the ''{0}'' DocType", (Object)object2));
                    }
                    bl = true;
                    ++n;
                }
                if (bl) {
                    this.updateLayout();
                }
                this.view(0, true);
            }
            IMvcView[] iMvcViewArray = this.views(false);
            object2 = iMvcViewArray;
            int n5 = iMvcViewArray.length;
            n = 0;
            while (n < n5) {
                IMvcView iMvcView = object2[n];
                if (iMvcView instanceof DiffView) {
                    ((DiffView)iMvcView).setSite(iEditorSite);
                }
                ((Viewer)iMvcView).setInput(object);
                ++n;
            }
            ((DiffView)this.view(0, false)).showAlerts();
        }
    }

    public IEditorSite getSite() {
        return this.site;
    }

    private boolean isLicensed(int n) {
        DocType docType = this.dDoc.docType(n);
        Addon.Edition edition = AddonInfoUtil.addonInfo().edition();
        return docType != DocType.XML ? true : edition != Addon.Edition.STANDARD;
    }
}

