/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.ui.MenuCombo;
import com.deltawalker.ui.fieldassist.ContentProposalAdapter;
import com.deltopia.StringUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ContentProposalTable
extends Table {
    private final Runnable adjustBoundsRunnable = new Runnable(){

        @Override
        public void run() {
            if (!ContentProposalTable.this.isDisposed()) {
                ContentProposalTable.this.adjustBounds();
            }
        }
    };
    private final ContentProposalAdapter contentProposalAdapter;
    private boolean skipSelection = true;

    public ContentProposalTable(ContentProposalAdapter contentProposalAdapter, Composite composite, int n) {
        super(composite, n & 0xEFFFFFFF);
        this.contentProposalAdapter = contentProposalAdapter;
        Display display = this.getDisplay();
        this.setBackground(display.getSystemColor(29));
        this.setForeground(display.getSystemColor(28));
        this.installListeners();
    }

    private void adjustBounds() {
        GridData gridData = new GridData(1808);
        Object object = this.getLayoutData();
        gridData.heightHint = object instanceof GridData ? ((GridData)object).heightHint : -1;
        gridData.widthHint = this.computeSize((int)-1, (int)gridData.heightHint, (boolean)true).x;
        this.setLayoutData(gridData);
        this.getShell().pack();
    }

    protected void checkSubclass() {
    }

    private void handleKeyDown(Event event) {
        if (event.character == '\t') {
            this.getShell().close();
        }
    }

    private void handleMouseUp(Event event) {
        this.getShell().close();
    }

    private void handleSelection(Event event) {
        Object object;
        if (event.widget.isDisposed()) {
            return;
        }
        TableItem[] tableItemArray = this.getSelection();
        if (tableItemArray != null && tableItemArray.length > 0 && (object = tableItemArray[0].getData()) != null) {
            String string = StringUtil.makeSafe((String)this.contentProposalAdapter.getLabelProvider().getText(object));
            MenuCombo menuCombo = (MenuCombo)this.contentProposalAdapter.getControl();
            menuCombo.setText(string);
            int n = string.length();
            menuCombo.setSelection(new Point(n, n));
        }
    }

    private void handleTraverse(Event event) {
        if (event.detail == 16 || event.detail == 8) {
            this.getShell().close();
        }
    }

    private void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        ContentProposalTable.this.handleKeyDown(event);
                        break;
                    }
                    case 4: {
                        ContentProposalTable.this.handleMouseUp(event);
                    }
                    case 13: {
                        ContentProposalTable.this.handleSelection(event);
                        break;
                    }
                    case 31: {
                        ContentProposalTable.this.handleTraverse(event);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("event");
                    }
                }
            }
        };
        this.addListener(1, listener);
        this.addListener(4, listener);
        this.addListener(13, listener);
        this.addListener(31, listener);
    }

    public void setBackground(Color color) {
        super.setBackground(this.getDisplay().getSystemColor(29));
    }

    public void setForeground(Color color) {
        super.setForeground(this.getDisplay().getSystemColor(28));
    }

    public void setItemCount(int n) {
        super.setItemCount(n);
        this.deselectAll();
        this.skipSelection = true;
        this.getDisplay().asyncExec(this.adjustBoundsRunnable);
    }

    public void setLayoutData(Object object) {
        if (object instanceof GridData) {
            Object object2 = this.getLayoutData();
            int n = object2 instanceof GridData ? ((GridData)object2).widthHint : -1;
            GridData gridData = (GridData)object;
            int n2 = gridData.widthHint;
            if (n2 != -1 && n2 < n) {
                gridData.widthHint = n;
            }
        }
        super.setLayoutData(object);
    }

    public void setSelection(int n) {
        if (this.skipSelection && this.getSelectionIndex() == -1 && n == 0) {
            this.skipSelection = false;
            return;
        }
        super.setSelection(n);
        this.notifyListeners(13, null);
    }
}

