/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.ui.OverlayPrefStore;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.io.FileType;
import com.deltopia.jface.util.DialogUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ClearHistoryDialog
extends TrayDialog {
    private static final OverlayPrefStore.OverlayKey[] OVERLAY_KEYS = new OverlayPrefStore.OverlayKey[]{new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.C_CLEAR_FILE_URI_HISTORY.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.C_CLEAR_FOLDER_URI_HISTORY.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.C_CLEAR_FILE_COMP_HISTORY.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.C_CLEAR_FOLDER_COMP_HISTORY.toString()), new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.C_CLEAR_FAVORITES.toString())};
    private Map<String, Button> checkBoxes = new HashMap<String, Button>();
    private final Listener onSelect = new Listener(){

        public void handleEvent(Event event) {
            Button button = (Button)event.widget;
            String string = (String)button.getData();
            ClearHistoryDialog.this.overlayPrefs.setValue(string, button.getSelection());
            String string2 = PrefKey.C_CLEAR_FILE_COMP_HISTORY.toString();
            String string3 = PrefKey.C_CLEAR_FOLDER_COMP_HISTORY.toString();
            if (string.equals(string2) || string.equals(string3)) {
                boolean bl = ((Button)ClearHistoryDialog.this.checkBoxes.get(string2)).getSelection() || ((Button)ClearHistoryDialog.this.checkBoxes.get(string3)).getSelection();
                ((Button)ClearHistoryDialog.this.checkBoxes.get(PrefKey.C_CLEAR_FAVORITES.toString())).setEnabled(bl);
            }
        }
    };
    OverlayPrefStore overlayPrefs = new OverlayPrefStore(PrefUtil.getGlobalPrefs(), OVERLAY_KEYS);

    public ClearHistoryDialog(Shell shell) {
        super(shell);
    }

    protected void cancelPressed() {
        this.overlayPrefs.stop();
        super.cancelPressed();
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        if (n == 0) {
            return super.createButton(composite, n, UIMsg.ClearHistoryDlg_clear, bl);
        }
        return super.createButton(composite, n, string, bl);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.getShell().setText(UIMsg.ClearHistoryDlg_clearHistory);
        DialogUtil.insertLabelSeparator(composite2, UIMsg.ClearHistoryDlg_clearCompHistory);
        this.createSessionControls(composite2);
        DialogUtil.insertLabelSeparator(composite2, UIMsg.ClearHistoryDlg_clearUriHistory);
        this.createHistoryControls(composite2);
        this.overlayPrefs.load();
        this.overlayPrefs.start();
        this.initializeFromPrefs();
        this.installListeners();
        ClearHistoryDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createHistoryControls(Composite composite) {
        Composite composite2 = DialogUtil.createIndentComposite(composite, 1, 769);
        Button button = new Button(composite2, 32);
        button.setText(FileType.FILE.toString());
        button.setData((Object)PrefKey.C_CLEAR_FILE_URI_HISTORY.toString());
        button.setLayoutData((Object)new GridData(4, 0, false, false));
        this.checkBoxes.put(PrefKey.C_CLEAR_FILE_URI_HISTORY.toString(), button);
        button = new Button(composite2, 32);
        button.setText(FileType.FOLDER.toString());
        button.setData((Object)PrefKey.C_CLEAR_FOLDER_URI_HISTORY.toString());
        button.setLayoutData((Object)new GridData(4, 0, false, false));
        this.checkBoxes.put(PrefKey.C_CLEAR_FOLDER_URI_HISTORY.toString(), button);
    }

    private void createSessionControls(Composite composite) {
        Composite composite2 = DialogUtil.createIndentComposite(composite, 1, 769);
        Button button = new Button(composite2, 32);
        button.setText(FileType.FILE.toString());
        button.setData((Object)PrefKey.C_CLEAR_FILE_COMP_HISTORY.toString());
        button.setLayoutData((Object)new GridData(4, 0, false, false));
        this.checkBoxes.put(PrefKey.C_CLEAR_FILE_COMP_HISTORY.toString(), button);
        button = new Button(composite2, 32);
        button.setText(FileType.FOLDER.toString());
        button.setData((Object)PrefKey.C_CLEAR_FOLDER_COMP_HISTORY.toString());
        button.setLayoutData((Object)new GridData(4, 0, false, false));
        this.checkBoxes.put(PrefKey.C_CLEAR_FOLDER_COMP_HISTORY.toString(), button);
        button = new Button(composite2, 32);
        button.setText(UIMsg.ClearHistoryDlg_favorites);
        button.setData((Object)PrefKey.C_CLEAR_FAVORITES.toString());
        button.setLayoutData((Object)new GridData(4, 0, false, false));
        this.checkBoxes.put(PrefKey.C_CLEAR_FAVORITES.toString(), button);
    }

    protected void helpPressed() {
        UIUtil.showHelp("clear-comparison-history", UIUtil.HelpContext.DIALOG);
    }

    private void initializeFromPrefs() {
        for (Button button : this.checkBoxes.values()) {
            String string;
            if (32 != (button.getStyle() & 0x20) || StringUtil.isEmpty((String)(string = (String)button.getData()))) continue;
            button.setSelection(this.overlayPrefs.getBoolean(string));
            button.notifyListeners(13, null);
        }
    }

    private void installListeners() {
        for (Button button : this.checkBoxes.values()) {
            if (32 != (button.getStyle() & 0x20)) continue;
            button.addListener(13, this.onSelect);
        }
    }

    protected void okPressed() {
        String[] stringArray = new String[]{UIMsg.ClearHistoryDlg_clearHistory, IDialogConstants.CANCEL_LABEL};
        int n = UIUtil.showConfirmActionPrompt(this.getShell(), UIMsg.ClearHistoryAction_prompt, stringArray);
        if (n != 1) {
            this.overlayPrefs.propagate();
            super.okPressed();
        }
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000000);
        return super.open();
    }
}

