/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.ui;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.IAlertChangeListener;
import com.deltawalker.ui.IAlertPresenter;
import com.deltawalker.ui.IAlertService;
import com.deltawalker.ui.UIMsg;
import com.deltopia.StringUtil;
import com.deltopia.ui.swt.CloseButton;
import com.deltopia.ui.swt.ImageCanvas;
import com.deltopia.util.Const;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;

public class AlertPresenter
implements IAlertPresenter {
    private static Color clrBg;
    private static Color clrBgErr;
    private static final String[] RETURN_CODE_STRING_KEYS;
    private static final int[] RETURN_CODES;
    private Color clrBorder;
    private Color clrFg;
    private final RGB RGB_ERR_BG = new RGB(255, 240, 240);
    private final RGB RGB_WHITE = new RGB(255, 255, 255);
    private final Map<RGB, Color> rgb2crlBg = new HashMap<RGB, Color>(2);

    static {
        RETURN_CODE_STRING_KEYS = new String[]{"yes", "no", "ok", "cancel"};
        RETURN_CODES = new int[]{64, 128, 32, 256};
    }

    @Override
    public boolean canPresent(IAlert iAlert) {
        return true;
    }

    private Control createButtonBar(Composite composite, IAlert iAlert, Composite composite2) {
        Composite composite3 = new Composite(composite, 0);
        composite3.setForeground(composite.getForeground());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(0x1000008, 0x1000008, false, false);
        composite3.setLayoutData((Object)gridData);
        this.createButtonsForButtonBar(composite3, iAlert, composite2);
        gridData.exclude = gridLayout.numColumns < 1;
        return composite3;
    }

    private void createButtonsForButtonBar(Composite composite, final IAlert iAlert, final Composite composite2) {
        int n = iAlert.getStyle();
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        Color color = composite.getForeground();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                int n = (Integer)event.widget.getData();
                iAlert.setReturnCode(n);
                composite2.dispose();
            }
        };
        ResourceBundle resourceBundle = UIMsg.constructedKeyBundle();
        int n2 = 0;
        while (n2 < RETURN_CODES.length) {
            int n3 = RETURN_CODES[n2];
            if ((n & n3) != 0) {
                String string;
                String string2;
                if (gridLayout.numColumns > 0) {
                    ++gridLayout.numColumns;
                    string2 = new Label(composite, 0);
                    string2.setForeground(color);
                    string2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
                    string2.setText("|");
                }
                if (StringUtil.isEmpty((String)(string2 = iAlert.getReturnCodeString(n3)))) {
                    string = RETURN_CODE_STRING_KEYS[n2];
                    try {
                        string2 = resourceBundle.getString("AlertPresenter.returnCode." + string);
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = string;
                    }
                }
                ++gridLayout.numColumns;
                string = new Link(composite, 0);
                string.setData((Object)n3);
                string.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
                string.setText("<a>" + string2 + "</a>");
                string.addListener(13, listener);
            }
            ++n2;
        }
    }

    private void createButtonsForSystemBar(Composite composite, final IAlert iAlert, final Control control) {
        int n = iAlert.getDecorationStyle();
        if ((n & 0x40) != 0) {
            GridLayout gridLayout = (GridLayout)composite.getLayout();
            ++gridLayout.numColumns;
            new CloseButton(composite, 0){

                protected void handleSelection() {
                    iAlert.onClose();
                    control.dispose();
                }
            };
        }
    }

    private Control createSystemBar(Composite composite, IAlert iAlert, Composite composite2) {
        Composite composite3 = new Composite(composite, 0);
        composite3.setForeground(composite.getForeground());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 0;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(0x1000008, 1, false, false);
        composite3.setLayoutData((Object)gridData);
        this.createButtonsForSystemBar(composite3, iAlert, (Control)composite2);
        gridData.exclude = gridLayout.numColumns < 1;
        return composite3;
    }

    @Override
    public void dispose() {
    }

    private Color getBgColor(int n, Display display) {
        boolean bl = false;
        if (!bl) {
            if ((n & 1) == 1) {
                if (clrBgErr == null || clrBgErr.isDisposed()) {
                    clrBgErr = new Color((Device)display, this.RGB_ERR_BG);
                }
                return clrBgErr;
            }
            if (clrBg == null || clrBg.isDisposed()) {
                clrBg = display.getSystemColor(1);
            }
        } else {
            if ((n & 1) == 0) {
                return display.getSystemColor(29);
            }
            if (clrBg == null || clrBg.isDisposed()) {
                clrBg = new Color((Device)display, this.RGB_ERR_BG);
            }
        }
        return clrBg;
    }

    private Color getBgColor(RGB rGB, Display display) {
        if (rGB == null) {
            return null;
        }
        Color color = this.rgb2crlBg.get(rGB);
        if (color == null || color.isDisposed()) {
            color = new Color((Device)display, rGB);
            this.rgb2crlBg.put(rGB, color);
        }
        return color;
    }

    private Color getBorderColor(RGB rGB, int n, Display display) {
        if ((n & 1) == 1) {
            rGB = this.RGB_ERR_BG;
        }
        if (rGB == null || rGB.equals((Object)this.RGB_WHITE)) {
            return display.getSystemColor(15);
        }
        if (this.clrBorder == null || this.clrBorder.isDisposed()) {
            this.clrBorder = new Color((Device)display, new RGB(Math.max(0, rGB.red - 60), Math.max(0, rGB.green - 60), Math.max(0, rGB.blue - 60)));
        }
        return this.clrBorder;
    }

    private Color getFgColor(RGB rGB, Display display) {
        if (rGB == null) {
            return null;
        }
        if (this.clrFg == null || this.clrFg.isDisposed()) {
            this.clrFg = new Color((Device)display, rGB);
        }
        return this.clrFg;
    }

    private Image getImage(int n) {
        String string;
        if ((n & 2) == 2 || (n & 4) == 4) {
            string = ImageConst.DIALOG_INFO;
        } else if ((n & 8) == 8) {
            string = ImageConst.DIALOG_WARNING;
        } else if ((n & 1) == 1) {
            string = ImageConst.DIALOG_ERROR;
        } else {
            return null;
        }
        return ImageCache.getImage(string);
    }

    @Override
    public Control present(final IAlert iAlert, IAlertService iAlertService, Composite composite) {
        final int n = iAlert.getStyle() | 0x40000000 | 0x40000 | 0x100000;
        final Display display = composite.getDisplay();
        RGB rGB = iAlert.getForegroundRgb();
        final RGB rGB2 = iAlert.getBackgroundRgb();
        final Color color = rGB != null ? this.getFgColor(rGB, display) : display.getSystemColor(2);
        final Color color2 = rGB2 != null ? this.getBgColor(rGB2, display) : this.getBgColor(n, display);
        final Composite composite2 = new Composite(composite, n);
        composite2.setBackground(color2);
        composite2.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (color.isDisposed() || color2.isDisposed()) {
                    return;
                }
                GC gC = paintEvent.gc;
                Color color3 = gC.getForeground();
                Rectangle rectangle = composite2.getClientArea();
                gC.setForeground(AlertPresenter.this.getBorderColor(rGB2, n, display));
                gC.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, Const.ARC_M.x, Const.ARC_M.y);
                gC.setForeground(color3);
                Color color22 = gC.getBackground();
                gC.setBackground(color2);
                gC.fillRoundRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, Const.ARC_M.x, Const.ARC_M.y);
                gC.setBackground(color22);
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Image image = this.getImage(n);
        final ImageCanvas imageCanvas = new ImageCanvas(composite2, 0);
        imageCanvas.setImage(image);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.exclude = image == null;
        imageCanvas.setLayoutData((Object)gridData);
        final StyledText styledText = new StyledText(composite2, 74);
        styledText.setBackground(color2);
        styledText.setForeground(color);
        int n2 = styledText.getLineHeight();
        styledText.setLineSpacing(n2 / 6);
        styledText.setLayoutData((Object)new GridData(4, 4, true, true));
        styledText.setText(StringUtil.makeSafe((String)iAlert.getText()));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setForeground(color);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        gridData = new GridData(0x1000008, 4, false, true);
        gridData.exclude = true;
        composite3.setLayoutData((Object)gridData);
        Control[] controlArray = new Control[]{this.createSystemBar(composite3, iAlert, composite2), this.createButtonBar(composite3, iAlert, composite2)};
        int n3 = 0;
        while (n3 < controlArray.length) {
            Control control = controlArray[n3];
            if (control != null && !((GridData)control.getLayoutData()).exclude) {
                gridData.exclude = false;
                break;
            }
            ++n3;
        }
        final IAlertChangeListener iAlertChangeListener = new IAlertChangeListener(){

            @Override
            public void styleChanged(IAlert iAlert, int n, int n2) {
                if (!imageCanvas.isDisposed()) {
                    imageCanvas.setImage(AlertPresenter.this.getImage(n2));
                }
            }

            @Override
            public void textChanged(IAlert iAlert, String string, final String string2) {
                if (styledText != null && !styledText.isDisposed()) {
                    Display display = styledText.getDisplay();
                    if (Thread.currentThread().equals(display.getThread())) {
                        styledText.setText(string2);
                    } else {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                styledText.setText(string2);
                            }
                        });
                    }
                }
            }
        };
        styledText.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                iAlert.removeAlertChangeListener(iAlertChangeListener);
                if (AlertPresenter.this.clrFg != null && !AlertPresenter.this.clrFg.isDisposed()) {
                    AlertPresenter.this.clrFg.dispose();
                    AlertPresenter.this.clrFg = null;
                }
                LinkedList linkedList = new LinkedList(AlertPresenter.this.rgb2crlBg.values());
                Iterator iterator = linkedList.descendingIterator();
                while (iterator.hasNext()) {
                    ((Color)iterator.next()).dispose();
                }
                AlertPresenter.this.rgb2crlBg.clear();
            }
        });
        iAlert.addAlertChangeListener(iAlertChangeListener);
        return composite2;
    }
}

