/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script.ui;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.SaveAs;
import com.deltawalker.internal.script.doc.ScriptDoc;
import com.deltawalker.internal.script.doc.ScriptDocumentProvider;
import com.deltawalker.internal.script.ui.ScriptController;
import com.deltawalker.text.source.SourceViewerConfig;
import com.deltopia.eclipse.util.IPropertyChangeNotifier;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.ui.swt.Border;
import com.deltopia.ui.swt.BorderDoubleLine;
import com.deltopia.ui.swt.IPannerHost;
import com.deltopia.ui.swt.Panner;
import com.deltopia.util.OS;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEditor
extends TextEditor
implements IMvcView,
IPannerHost {
    public static final String ID = ScriptEditor.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(ScriptEditor.class);
    private static final Insets PANNER_BORDER_GAP = new Insets(18, 5, 5, 5);
    private static final Dimension PANNER_SIZE = new Dimension(40, 40);
    private boolean dockPanner = true;
    private Image image;
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if (string.equals("NAME") || string.equals("MODIFIED")) {
                ScriptEditor.this.setPartName(ScriptEditor.this.getEditorInput().getName());
                ScriptEditor.this.setTitleToolTip(ScriptEditor.this.getTitleToolTip());
                if (string.equals("MODIFIED")) {
                    ScriptEditor.this.firePropertyChange(257);
                }
            }
        }
    };
    private Panner panner;
    private final Point PANNER_MARGIN = new Point(10, 10);
    private ScriptController scrCtlr;
    private StyledText stText;

    public ScriptEditor() {
        this.setDocumentProvider((IDocumentProvider)new ScriptDocumentProvider());
        this.scrCtlr = this.createController();
    }

    protected void adjustHighlightRange(int n, int n2) {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            iTextViewerExtension5.exposeModelRange((IRegion)new Region(n, n2));
        }
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        this.getEditorInput().setHasOpenView(true);
    }

    public Control control() {
        return null;
    }

    public ScriptController controller() {
        return this.scrCtlr;
    }

    protected ScriptController createController() {
        return new ScriptController();
    }

    private void createPanner(Composite composite) {
        this.stText.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                ScriptEditor.this.dockPanner(true);
            }

            public void controlResized(ControlEvent controlEvent) {
                ScriptEditor.this.dockPanner(true);
            }
        });
        this.stText.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScriptEditor.this.dockPanner(true);
            }
        });
        this.stText.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScriptEditor.this.dockPanner(true);
            }
        });
        this.stText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ScriptEditor.this.dockPanner(true);
            }
        });
        this.image = ImageCache.getImage(ImageConst.PLAY);
        this.panner = new Panner(composite, 524288, (IPannerHost)this);
        this.panner.setBorder((Border)new BorderDoubleLine((Device)this.stText.getDisplay(), 17, 19, PANNER_BORDER_GAP, 1));
        this.panner.setSize(ScriptEditor.PANNER_SIZE.width, ScriptEditor.PANNER_SIZE.height);
        this.panner.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                Rectangle rectangle = ScriptEditor.this.panner.projectionBounds();
                if (rectangle.contains(mouseEvent.x, mouseEvent.y)) {
                    ScriptEditor.this.getEditorInput().runScript();
                }
            }
        });
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        ISourceViewer iSourceViewer = super.createSourceViewer(composite, iVerticalRuler, n);
        this.stText = iSourceViewer.getTextWidget();
        this.getSourceViewerDecorationSupport(iSourceViewer);
        this.scrCtlr.installListeners();
        this.createPanner((Composite)this.stText);
        return iSourceViewer;
    }

    public void disconnect() {
        this.installPropertyListener(this.getEditorInput(), false);
    }

    public void dispose() {
        this.disconnect();
        this.scrCtlr = null;
    }

    private void dockPanner(boolean bl) {
        Rectangle rectangle = this.pannerParent().getBounds();
        Point point = this.panner.getLocation();
        Point point2 = new Point(rectangle.width - ScriptEditor.PANNER_SIZE.width - point.x, -this.panner.getLocation().y);
        if (this.dockPanner || bl) {
            this.panner.move(point2.x - this.PANNER_MARGIN.x, point2.y + this.PANNER_MARGIN.y);
        } else if (point.x > point2.x - 5 || point.y > point2.y - 5) {
            this.dockPanner = true;
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ScriptDoc scriptDoc = this.getEditorInput();
        try {
            scriptDoc.doSave(iProgressMonitor);
        }
        catch (IOException iOException) {
            LOG.error("ScriptEditor#doSave()", (Throwable)iOException);
        }
    }

    public void doSaveAs() {
        ScriptDoc scriptDoc = this.getEditorInput();
        try {
            scriptDoc.doSaveAs(SaveAs.PRESERVE);
        }
        catch (IOException iOException) {
            LOG.error("ScriptEditor#doSaveAs()", (Throwable)iOException);
        }
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        ScriptDoc scriptDoc = this.getEditorInput();
        if (iEditorInput != scriptDoc) {
            if (scriptDoc != null) {
                this.installPropertyListener(scriptDoc, false);
            }
            if (iEditorInput != null) {
                this.installPropertyListener((IPropertyChangeNotifier)iEditorInput, true);
            }
            super.doSetInput(iEditorInput);
        }
        this.scrCtlr.connect(this.model(), this);
        this.connect(this.model(), this.scrCtlr);
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("group.open"));
        iMenuManager.add((IContributionItem)new Separator("group.undo"));
        iMenuManager.add((IContributionItem)new Separator("group.copy"));
        iMenuManager.add((IContributionItem)new Separator("group.save"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        ScriptController scriptController = this.controller();
        IAction iAction = this.getAction(ActionFactory.UNDO.getId());
        if (OS.OSX) {
            iAction.setImageDescriptor(null);
            iAction.setDisabledImageDescriptor(null);
        }
        this.addAction(iMenuManager, "group.undo", iAction.getId());
        iAction = this.getAction(ActionFactory.REDO.getId());
        if (OS.OSX) {
            iAction.setImageDescriptor(null);
            iAction.setDisabledImageDescriptor(null);
        }
        this.addAction(iMenuManager, "group.undo", iAction.getId());
        this.addAction(iMenuManager, "group.copy", ActionFactory.CUT.getId());
        this.addAction(iMenuManager, "group.copy", ActionFactory.COPY.getId());
        this.addAction(iMenuManager, "group.copy", ActionFactory.PASTE.getId());
        this.addAction(iMenuManager, "group.copy", ActionFactory.SELECT_ALL.getId());
        iMenuManager.appendToGroup("group.copy", (IContributionItem)new Separator());
        iMenuManager.appendToGroup("group.save", scriptController.getAction("saveAs"));
        iMenuManager.appendToGroup("additions", (IContributionItem)new Separator("settings"));
        IAction iAction2 = this.getAction("Preferences.ContextAction");
        iMenuManager.appendToGroup("settings", iAction2);
    }

    public Control getControl() {
        return this.stText;
    }

    public ScriptDoc getEditorInput() {
        return (ScriptDoc)super.getEditorInput();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration(new SourceViewerConfig("js"));
    }

    private void installPropertyListener(IPropertyChangeNotifier iPropertyChangeNotifier, boolean bl) {
        assert (iPropertyChangeNotifier != null);
        if (bl) {
            iPropertyChangeNotifier.addPropertyListener(this.onProp);
        } else {
            iPropertyChangeNotifier.removePropertyListener(this.onProp);
        }
    }

    public boolean isDirty() {
        ScriptDoc scriptDoc = this.getEditorInput();
        return scriptDoc.isModified();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IMvcModel model() {
        return this.getEditorInput();
    }

    public void movePanner(int n, int n2) {
    }

    public void paint(GC gC) {
        int n = gC.getAlpha();
        gC.setAlpha(220);
        Rectangle rectangle = this.panner.projectionBounds();
        gC.drawImage(this.image, rectangle.x + 3, rectangle.y + 3);
        gC.setAlpha(n);
    }

    private Composite pannerParent() {
        return this.stText;
    }

    public void setDockPanner(boolean bl) {
        this.dockPanner = bl;
    }

    public void showPanner(boolean bl, boolean bl2) {
    }
}

