/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script.ui;

import com.deltawalker.Msg;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.script.ui.BooleanFieldEditor2;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor2 fWrapEditor = null;
    private ConsoleIntegerFieldEditor fWidthEditor = null;
    private BooleanFieldEditor2 fUseBufferSize = null;
    private ConsoleIntegerFieldEditor fBufferSizeEditor = null;
    private ConsoleIntegerFieldEditor fTabSizeEditor = null;

    public ConsolePreferencePage() {
        super(1);
        this.setDescription(Msg.ConsolePreferencePage_Console_settings);
        this.setPreferenceStore(DeltaWalkerPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.console_preference_page_context");
    }

    public void createFieldEditors() {
        this.fWrapEditor = new BooleanFieldEditor2("Console.wrap", Msg.ConsolePreferencePage_Wrap_text_1, 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fWrapEditor);
        this.fWidthEditor = new ConsoleIntegerFieldEditor("Console.width", Msg.ConsolePreferencePage_Console_width, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fWidthEditor);
        this.fWidthEditor.setValidRange(80, 1000);
        this.fWidthEditor.setErrorMessage(Msg.ConsolePreferencePage_console_width);
        this.fWrapEditor.getChangeControl(this.getFieldEditorParent()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConsolePreferencePage.this.updateWidthEditor();
            }
        });
        this.fUseBufferSize = new BooleanFieldEditor2("Console.limitConsoleOutput", Msg.ConsolePreferencePage_Limit_console_output_1, 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fUseBufferSize);
        this.fBufferSizeEditor = new ConsoleIntegerFieldEditor("Console.lowWaterMark", Msg.ConsolePreferencePage_Console_buffer_size__characters___2, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fBufferSizeEditor);
        this.fBufferSizeEditor.setValidRange(1000, 1000000);
        this.fBufferSizeEditor.setErrorMessage(Msg.ConsolePreferencePage_The_console_buffer_size_must_be_at_least_1000_characters__1);
        this.fUseBufferSize.getChangeControl(this.getFieldEditorParent()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConsolePreferencePage.this.updateBufferSizeEditor();
            }
        });
        this.fTabSizeEditor = new ConsoleIntegerFieldEditor("Console.console_tab_width", Msg.ConsolePreferencePage_12, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fTabSizeEditor);
        this.fTabSizeEditor.setValidRange(1, 100);
        this.fTabSizeEditor.setErrorMessage(Msg.ConsolePreferencePage_13);
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG.consoleOpenOnOut", Msg.ConsolePreferencePage_Show__Console_View_when_there_is_program_output_3, 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG.consoleOpenOnErr", Msg.ConsolePreferencePage_Show__Console_View_when_there_is_program_error_3, 0, this.getFieldEditorParent()));
        ColorFieldEditor colorFieldEditor = new ColorFieldEditor("org.eclipse.debug.ui.outColor", Msg.ConsolePreferencePage_Standard_Out__2, this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor2 = new ColorFieldEditor("org.eclipse.debug.ui.errorColor", Msg.ConsolePreferencePage_Standard_Error__3, this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor3 = new ColorFieldEditor("org.eclipse.debug.ui.inColor", Msg.ConsolePreferencePage_Standard_In__4, this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor4 = new ColorFieldEditor("org.eclipse.debug.ui.consoleBackground", Msg.ConsolePreferencePage_11, this.getFieldEditorParent());
        this.addField((FieldEditor)colorFieldEditor);
        this.addField((FieldEditor)colorFieldEditor2);
        this.addField((FieldEditor)colorFieldEditor3);
        this.addField((FieldEditor)colorFieldEditor4);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        IPreferenceStore iPreferenceStore = DeltaWalkerPlugin.getDefault().getPreferenceStore();
        int n = iPreferenceStore.getInt("Console.lowWaterMark");
        int n2 = n + 8000;
        iPreferenceStore.setValue("Console.highWaterMark", n2);
        return bl;
    }

    protected void initialize() {
    }

    protected void updateWidthEditor() {
        Button button = this.fWrapEditor.getChangeControl(this.getFieldEditorParent());
        this.fWidthEditor.getTextControl(this.getFieldEditorParent()).setEnabled(button.getSelection());
        this.fWidthEditor.getLabelControl(this.getFieldEditorParent()).setEnabled(button.getSelection());
    }

    protected void updateBufferSizeEditor() {
        Button button = this.fUseBufferSize.getChangeControl(this.getFieldEditorParent());
        this.fBufferSizeEditor.getTextControl(this.getFieldEditorParent()).setEnabled(button.getSelection());
        this.fBufferSizeEditor.getLabelControl(this.getFieldEditorParent()).setEnabled(button.getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateWidthEditor();
        this.updateBufferSizeEditor();
    }

    protected boolean canClearErrorMessage() {
        return this.fWidthEditor.isValid() && this.fBufferSizeEditor.isValid();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl) {
                if (this.fWidthEditor != null && propertyChangeEvent.getSource() != this.fWidthEditor) {
                    this.fWidthEditor.refreshValidState();
                }
                if (this.fBufferSizeEditor != null && propertyChangeEvent.getSource() != this.fBufferSizeEditor) {
                    this.fBufferSizeEditor.refreshValidState();
                }
                this.checkState();
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    protected class ConsoleIntegerFieldEditor
    extends IntegerFieldEditor {
        public ConsoleIntegerFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (ConsolePreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }
}

