/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script.doc;

import com.deltawalker.App;
import com.deltawalker.DocBase;
import com.deltawalker.DocType;
import com.deltawalker.IPersistable;
import com.deltawalker.IStreamContentAccessor;
import com.deltawalker.Msg;
import com.deltawalker.NotifyUtil;
import com.deltawalker.Pre;
import com.deltawalker.PrefUtil;
import com.deltawalker.SaveAs;
import com.deltawalker.ScriptRunner;
import com.deltawalker.StateBoss;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IScriptBoss;
import com.deltawalker.interfaces.IScriptDoc;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.IResourceFactory;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.FileDialogEx;
import com.deltawalker.ui.dialogs.ILocalResourceDialog;
import com.deltawalker.ui.dialogs.IResourceDialog;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.io.IByteSequence;
import com.deltopia.io.StorageEvent;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptDoc
extends DocBase
implements IScriptDoc,
IPersistable,
IEditorInput,
IStreamContentAccessor,
IJsonState {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptDoc.class);
    private static IScriptBoss sBoss = App.instance().scriptBoss();
    private IDocument document;
    private int hashCode;
    private boolean hasOpenView;
    private String initialContent = "";
    private boolean modified;
    private final IDocumentListener onDocument = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            ScriptDoc.this.setModified(!ScriptDoc.this.document().get().equals(ScriptDoc.this.initialContent));
        }
    };
    private long timeCreated;
    private long timeOpened;
    private UriInfo uriInfo;

    public ScriptDoc() {
        this.timeCreated = this.timeOpened = System.currentTimeMillis();
        this.uriInfo = super.uriInfo();
    }

    public ScriptDoc(JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("op")) {
                this.hasOpenView = jsonReader.nextBoolean();
                continue;
            }
            if (string.equals("io")) {
                this.uriInfo = UriInfoUtil.readUriInfo(jsonReader);
                continue;
            }
            if (string.equals("dt")) {
                this.timeCreated = jsonReader.nextLong();
                continue;
            }
            if (string.equals("lo") || StateBoss.is(Pre.V_21) && string.equals("lat")) {
                this.timeOpened = jsonReader.nextLong();
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    @Override
    public void clear() {
        if (this.document != null) {
            this.document.set("");
        }
        this.initialContent = "";
        this.modified = false;
        super.clear();
    }

    @Override
    public int compareTo(IScriptDoc iScriptDoc) {
        long l = this.timeOpened - iScriptDoc.getTimeLastOpened();
        if (l == 0L) {
            l = this.timeCreated - iScriptDoc.getTimeCreated();
        }
        if (l != 0L) {
            return l > 0L ? -1 : 1;
        }
        return this.uriInfo().uri().compareTo(((ScriptDoc)iScriptDoc).uriInfo().uri());
    }

    private boolean confirmFileOverwrite(String string, boolean bl) {
        if (!bl && this.isWritable()) {
            return true;
        }
        Shell shell = UIUtil.getActiveWindowShell();
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText(UIMsg.DiffView_ResourceAttrDlgBox_title);
        messageBox.setMessage(NLS.bind((String)UIMsg.DiffView_ResourceAttrDlgBox_msg, (Object)string));
        return messageBox.open() == 64;
    }

    @Override
    public void dispose() {
        try {
            if (this.document != null) {
                this.document.removeDocumentListener(this.onDocument);
                this.document = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    @Override
    public DocType docType() {
        return DocType.SCRIPT;
    }

    public IDocument document() {
        if (this.document == null) {
            this.document = new Document();
            this.doLoad(null, (IProgressMonitor)new NullProgressMonitor());
            this.document.addDocumentListener(this.onDocument);
        }
        return this.document;
    }

    @Override
    public void doLoad(String string, IProgressMonitor iProgressMonitor) {
        if (string != null) {
            this.uriInfo = this.uriInfo.cloneUpdateUri(string, false);
        } else {
            string = this.uriInfo.uri();
        }
        try {
            if (!this.hasResource()) {
                this.setResource(ResourceFactory.staticCreateResource(this.uriInfo, false, false));
            }
            if (!StringUtil.isEmpty((String)string)) {
                IByteSequence iByteSequence = ((IPersistableResource)((Object)this.resource())).load(string, iProgressMonitor);
                this.initialize(iByteSequence.toString());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public boolean doSave(IProgressMonitor iProgressMonitor) throws IOException {
        if (!this.isModified()) {
            return false;
        }
        return this.save(iProgressMonitor, false, SaveAs.PRESERVE);
    }

    @Override
    public boolean doSave(UriInfo uriInfo, IProgressMonitor iProgressMonitor) throws IOException {
        String string = this.document().get();
        byte[] byArray = string.getBytes();
        byArray = string.getBytes();
        this.saveByteResourceOpt(uriInfo, byArray, iProgressMonitor);
        this.setUriInfo(uriInfo, !this.hasResource());
        this.initialize(string);
        this.getName();
        return true;
    }

    @Override
    public boolean doSaveAs(SaveAs saveAs) throws IOException {
        return this.save((IProgressMonitor)new NullProgressMonitor(), true, saveAs);
    }

    public boolean exists() {
        return false;
    }

    protected void fireReadOnlyPropertyChanged(boolean bl, boolean bl2) {
        if (bl2 != bl) {
            NotifyUtil.firePropertyChange(this.getListeners(), new PropertyChangeEvent((Object)this, "READ_ONLY", (Object)bl, (Object)bl2));
        }
    }

    @Override
    protected void fireStoragePropertyChanged(StorageEvent storageEvent) {
        NotifyUtil.firePropertyChange(this.getListeners(), new PropertyChangeEvent((Object)this, "STORAGE", null, (Object)storageEvent));
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
    }

    public Object getAdapter(Class clazz) {
        if (IDocument.class.equals((Object)clazz)) {
            return this.document();
        }
        return null;
    }

    @Override
    public InputStream getContents() throws IOException {
        return new ByteArrayInputStream(this.document().get().getBytes());
    }

    @Override
    public boolean getHasOpenView() {
        return this.hasOpenView;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public long getLastAccessTime() {
        return this.timeOpened;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    @Override
    public long getTimeCreated() {
        return this.timeCreated;
    }

    @Override
    public long getTimeLastOpened() {
        return this.timeOpened;
    }

    public String getToolTipText() {
        String string = this.uriInfo().uri();
        if (string.isEmpty()) {
            string = this.getName();
        }
        return string;
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = 31 * n + (int)(this.timeCreated ^ this.timeCreated >>> 32);
            n = 31 * n + (int)(this.timeOpened ^ this.timeOpened >>> 32);
            this.hashCode = n = 31 * n + this.uriInfo.hashCode();
        }
        return n;
    }

    public void initialize(String string) {
        if (!(this.document() == null || string == null || this.document.getLength() == string.length() && this.document.get().equals(string))) {
            this.document.set(string);
        }
        this.initialContent = string;
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public IPreferenceStore preferences() {
        return PrefUtil.getGlobalPrefs();
    }

    private UriInfo prepareForSaving(boolean bl, SaveAs saveAs) throws IOException {
        UriInfo uriInfo;
        block12: {
            Object object;
            String string = this.getName();
            if (string != null && string.equals(((UriInfo)(object = this.uriInfo())).uri())) {
                string = ((UriInfo)object).uri();
            }
            if (this.hasResource() && !this.resource().factory().resourceExists(this.uriInfo())) {
                bl = true;
            }
            if (!bl && !this.confirmFileOverwrite(this.getName(), false)) {
                return null;
            }
            object = this.resource();
            if (object == null || bl) {
                uriInfo = this.showSaveDialog(this.uriInfo(), saveAs);
                if (uriInfo == null) {
                    return null;
                }
                Object object2 = null;
                try {
                    this.setResource(null);
                    try {
                        object2 = ResourceFactory.staticCreateResource(uriInfo, true, false);
                    }
                    catch (IOException iOException) {
                        uriInfo = uriInfo.cloneUpdateError(iOException);
                    }
                    if (object2 != null && !object2.isWritable() && !this.confirmFileOverwrite(object2.getName(), true)) {
                        object2 = null;
                        return null;
                    }
                    break block12;
                }
                finally {
                    if (object2 == null) {
                        object2 = object;
                    }
                    this.setResource((IResource)object2);
                }
            }
            uriInfo = this.uriInfo();
        }
        return uriInfo;
    }

    @Override
    public void reduceToSession() {
    }

    @Override
    public void runScript() {
        ScriptRunner scriptRunner = sBoss.runner("application/javascript");
        try {
            if (this.hasResource() && this.isModified()) {
                this.save((IProgressMonitor)new NullProgressMonitor(), false, SaveAs.PRESERVE);
            }
            scriptRunner.evaluate(this.document().get());
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
        }
    }

    private boolean save(IProgressMonitor iProgressMonitor, boolean bl, SaveAs saveAs) throws IOException {
        UriInfo uriInfo = this.prepareForSaving(bl, saveAs);
        if (uriInfo == null) {
            return false;
        }
        return this.doSave(uriInfo, iProgressMonitor);
    }

    @Override
    public void setHasOpenView(boolean bl) {
        this.hasOpenView = bl;
    }

    @Override
    public void setModified(boolean bl) {
        boolean bl2 = this.modified;
        this.modified = bl;
        this.firePropertyChanged("MODIFIED", bl2, bl);
    }

    public void setTimeLastOpened(long l) {
        this.timeOpened = l;
    }

    private void setUriInfo(UriInfo uriInfo, boolean bl) {
        boolean bl2;
        UriInfo uriInfo2 = uriInfo;
        UriInfo uriInfo3 = this.uriInfo();
        boolean bl3 = this.hasResource() ? this.resource().factory().isCaseSensitive() : true;
        boolean bl4 = bl3 ? uriInfo3.uri().equals(uriInfo2.uri()) : uriInfo3.uri().equalsIgnoreCase(uriInfo2.uri());
        boolean bl5 = bl2 = bl ? true : ObjectUtil.areEqual((Object)uriInfo3.lineEnding(), (Object)uriInfo2.lineEnding());
        if (bl4 && bl2) {
            return;
        }
        this.uriInfo = uriInfo;
        String string = "";
        if (bl || !bl4) {
            string = "URI";
        } else if (!bl2) {
            string = "LINE_ENDING";
        }
        if (!StringUtil.isEmpty((String)string)) {
            this.fireUriInfoChanged(string);
        }
    }

    private UriInfo showSaveDialog(UriInfo uriInfo, SaveAs saveAs) {
        IResourceFactory iResourceFactory = saveAs == SaveAs.PRESERVE && this.hasResource() ? this.resource().factory() : ResourceFactory.getFactory(saveAs == SaveAs.REMOTE ? "com.deltawalker.vfs.vfsResourceFactory" : "com.deltawalker.localResourceFactory");
        IPreferenceStore iPreferenceStore = this.preferences();
        IResourceDialog iResourceDialog = iResourceFactory.createResourceWindow(null, true, false, "", iPreferenceStore, uriInfo);
        if (iResourceFactory.isLocal()) {
            ILocalResourceDialog iLocalResourceDialog = (ILocalResourceDialog)iResourceDialog;
            iLocalResourceDialog.setFilterPath(FileDialogEx.chooseFilterPath(uriInfo, "", iPreferenceStore));
            iLocalResourceDialog.setFilterExtensions(new String[]{UIMsg.LoadScriptAction_scriptFiles_extension, Msg.Common_allFiles_extension});
            iLocalResourceDialog.setFilterNames(new String[]{UIMsg.LoadScriptAction_scriptFiles_name, Msg.Common_allFiles_name});
        }
        uriInfo = iResourceDialog.show();
        return uriInfo;
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        if (!this.hasResource()) {
            return;
        }
        jsonWriter.beginObject();
        jsonWriter.name("dt").value(this.timeCreated);
        jsonWriter.name("lo").value(this.timeOpened);
        if (this.hasOpenView) {
            jsonWriter.name("op").value(this.hasOpenView);
        }
        jsonWriter.name("io");
        this.uriInfo.toJson(jsonWriter);
        jsonWriter.endObject();
    }

    @Override
    public UriInfo uriInfo() {
        return this.uriInfo;
    }
}

