/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.ITextDiffDoc;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.internal.script.FileComparison;
import com.deltawalker.internal.script.ProgressMonitor;
import com.deltawalker.script.BadLocationException;
import com.deltawalker.script.ComparisonListener;
import com.deltawalker.script.DeltaRange;
import com.deltawalker.script.PatchFormat;
import com.deltawalker.script.ProgressListener;
import com.deltawalker.script.ReportKind;
import com.deltawalker.script.Role;
import com.deltawalker.text.MergeOp;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.ReportAction;
import com.deltopia.StringUtil;
import com.deltopia.io.TextEncoding;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;

public class TextComparison
extends FileComparison
implements com.deltawalker.script.TextComparison {
    public TextComparison(UUID uUID, ComparisonListener comparisonListener) {
        super(uUID, comparisonListener);
    }

    @Override
    public void deleteText(DeltaRange[] deltaRangeArray, Role[] roleArray, ProgressListener progressListener) throws BadLocationException {
        if (roleArray == null) {
            throw new NullPointerException("'roles' cannot be null.");
        }
        if (roleArray.length == 0) {
            throw new IllegalArgumentException("'roles' cannot be empty.");
        }
        if (deltaRangeArray == null) {
            throw new NullPointerException("'deltas' cannot be null.");
        }
        if (deltaRangeArray.length == 0) {
            throw new IllegalArgumentException("'deltas' cannot be empty.");
        }
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>(Arrays.asList(roleArray));
        if (!this.deltaDoc().roles().containsAll(linkedHashSet)) {
            String string = "Role.TWO is not a valid role for this comparison.";
            throw new IllegalArgumentException(string);
        }
        org.eclipse.jface.text.BadLocationException[] badLocationExceptionArray = new org.eclipse.jface.text.BadLocationException[1];
        try {
            this.deltaModel().deleteText(this.toList(deltaRangeArray), Relation.roleArrayToSet(roleArray), new ProgressMonitor(progressListener));
        }
        catch (org.eclipse.jface.text.BadLocationException badLocationException) {
            badLocationExceptionArray[0] = badLocationException;
        }
        this.waitTillDone();
        if (badLocationExceptionArray[0] != null) {
            throw new BadLocationException(badLocationExceptionArray[0]);
        }
    }

    @Override
    protected ITextDiffDoc deltaDoc() {
        return (ITextDiffDoc)super.deltaDoc();
    }

    @Override
    protected ITextDiffModel deltaModel() {
        return (ITextDiffModel)super.deltaModel();
    }

    protected IDocument document(Role role) {
        return this.deltaDoc().document(role);
    }

    @Override
    public DeltaRange[] getAllDeltas() {
        List<DiffRange> list = this.deltaModel().getDeltas(true);
        return list.toArray(new DiffRange[list.size()]);
    }

    public String getContent(Role role) {
        return this.deltaDoc().document(role).get();
    }

    public int getCurrentLineNumber(Role role) {
        ISourceViewer iSourceViewer = this.deltaView().viewer(role);
        Point point = iSourceViewer.getSelectedRange();
        int n = 0;
        try {
            n = this.deltaDoc().document(role).getLineOfOffset(point.x);
        }
        catch (org.eclipse.jface.text.BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return n;
    }

    public String getLine(int n, boolean bl, Role role) throws BadLocationException {
        try {
            IDocument iDocument = this.document(role);
            int n2 = iDocument.getLineOffset(n);
            int n3 = iDocument.getLineLength(n);
            String string = iDocument.getLineDelimiter(n);
            if (bl || StringUtil.isEmpty((String)string)) {
                return iDocument.get(n2, n3);
            }
            String string2 = iDocument.get(n2, n3);
            int n4 = string2.length() - string.length() - 1;
            return string2.substring(0, n4);
        }
        catch (org.eclipse.jface.text.BadLocationException badLocationException) {
            throw new BadLocationException(badLocationException.getLocalizedMessage());
        }
    }

    public int getLineCount(Role role) {
        return this.document(role).getNumberOfLines();
    }

    public String getLineEnding(int n, Role role) throws BadLocationException {
        try {
            return this.document(role).getLineDelimiter(n);
        }
        catch (org.eclipse.jface.text.BadLocationException badLocationException) {
            throw new BadLocationException(badLocationException.getLocalizedMessage());
        }
    }

    public int getLineLength(int n, Role role) throws org.eclipse.jface.text.BadLocationException {
        return this.document(role).getLineLength(n);
    }

    @Override
    public String getText(Role role, int n, int n2) throws BadLocationException {
        try {
            return this.document(role).get(n, n2);
        }
        catch (org.eclipse.jface.text.BadLocationException badLocationException) {
            throw new BadLocationException(badLocationException.getLocalizedMessage());
        }
    }

    @Override
    public boolean hasDifferences() {
        return this.deltaModel().hasTrueDiffs();
    }

    @Override
    public int length(Role role) {
        return this.document(role).getLength();
    }

    @Override
    public void merge(com.deltawalker.script.MergeOp mergeOp, DeltaRange[] deltaRangeArray, Role role, Role role2, ProgressListener progressListener) throws BadLocationException {
        if (mergeOp == null) {
            throw new NullPointerException("'mergeOp' cannot be null.");
        }
        if (deltaRangeArray == null) {
            throw new NullPointerException("'deltas' cannot be null.");
        }
        if (deltaRangeArray.length == 0) {
            return;
        }
        if (!this.isThreeWay()) {
            if (role == Role.TWO || role2 == Role.TWO) {
                throw new IllegalArgumentException("There's no 'Role.TWO' in a two-way comparison.");
            }
            if (mergeOp == com.deltawalker.script.MergeOp.MERGE) {
                throw new IllegalArgumentException("'MergeOp.MERGE' is only applicable to three-way comparisons.");
            }
        }
        MergeOp mergeOp2 = MergeOp.fromScript(mergeOp);
        org.eclipse.jface.text.BadLocationException[] badLocationExceptionArray = new org.eclipse.jface.text.BadLocationException[1];
        try {
            this.deltaModel().merge(mergeOp2, this.toList(deltaRangeArray), role, role2, new ProgressMonitor(progressListener));
        }
        catch (org.eclipse.jface.text.BadLocationException badLocationException) {
            badLocationExceptionArray[0] = badLocationException;
        }
        this.waitTillDone();
        if (badLocationExceptionArray[0] != null) {
            throw new BadLocationException(badLocationExceptionArray[0]);
        }
    }

    @Override
    public void report(String string, ReportKind reportKind, PatchFormat patchFormat) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("'path' cannot be null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'path' cannot be empty");
        }
        this.reportEx(new com.deltawalker.script.UriInfo(string), reportKind, patchFormat);
    }

    @Override
    public void reportEx(com.deltawalker.script.UriInfo uriInfo, ReportKind reportKind, PatchFormat patchFormat) throws IllegalArgumentException {
        DiffView diffView;
        if (uriInfo == null) {
            throw new NullPointerException("'uriInfo' cannot be null");
        }
        UriInfo uriInfo2 = UriInfoUtil.fromScript(uriInfo);
        if (uriInfo2.isEmpty()) {
            throw new IllegalArgumentException("'uriInfo' cannot be empty");
        }
        if (reportKind == null) {
            throw new NullPointerException("'kind' cannot be null");
        }
        if (reportKind == ReportKind.PATCH && patchFormat == null) {
            throw new NullPointerException("'format' cannot be null");
        }
        if (uriInfo2.textEncoding() == null) {
            uriInfo2 = uriInfo2.cloneUpdateEncoding(TextEncoding.getDefault());
        }
        if ((diffView = this.deltaView()) == null) {
            throw new IllegalStateException("Missing view to make report for " + uriInfo);
        }
        ReportAction reportAction = (ReportAction)diffView.controller().getAction("createReportHtml");
        reportAction.report(uriInfo2.uri(), uriInfo2.textEncoding(), uriInfo2.lineEnding(), null);
        this.waitTillDone();
    }

    public void setContent(final Role role, final String string) {
        if (role == null) {
            throw new NullPointerException("role");
        }
        if (string == null) {
            throw new NullPointerException("text");
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                TextComparison.this.document(role).set(string);
            }
        });
    }

    public void setCurrentLineNumber(int n, Role role) {
    }

    public void setSelectedDelta(DeltaRange deltaRange, boolean bl, boolean bl2) {
        this.deltaModel().selectDelta((DiffRange)deltaRange, bl, bl2);
    }

    @Override
    public void setText(final Role role, final int n, final int n2, final String string) throws BadLocationException, IllegalArgumentException {
        if (role == null) {
            throw new NullPointerException("'role' cannot be null.");
        }
        if (string == null) {
            throw new NullPointerException("'text' cannot be null.");
        }
        if (role == Role.TWO && !this.isThreeWay()) {
            throw new IllegalArgumentException("There's no 'Role.TWO' in a two-way comparison.");
        }
        final org.eclipse.jface.text.BadLocationException[] badLocationExceptionArray = new org.eclipse.jface.text.BadLocationException[1];
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TextComparison.this.document(role).replace(n, n2, string);
                }
                catch (org.eclipse.jface.text.BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        });
        if (badLocationExceptionArray[0] != null) {
            throw new BadLocationException(badLocationExceptionArray[0]);
        }
    }

    private List<DiffRange> toList(DeltaRange[] deltaRangeArray) {
        ArrayList<DiffRange> arrayList = new ArrayList<DiffRange>();
        if (deltaRangeArray != null) {
            DeltaRange[] deltaRangeArray2 = deltaRangeArray;
            int n = deltaRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DeltaRange deltaRange = deltaRangeArray2[n2];
                if (deltaRange != null) {
                    arrayList.add((DiffRange)deltaRange);
                }
                ++n2;
            }
        }
        return arrayList;
    }
}

