/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.App;
import com.deltawalker.DiffMethodUtil;
import com.deltawalker.DocType;
import com.deltawalker.PrefKey;
import com.deltawalker.StateBoss;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.interfaces.IFilterBoss;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.Filters;
import com.deltawalker.script.PageSettings;
import com.deltawalker.script.PrinterSettings;
import com.deltopia.io.SettingKey;
import com.deltopia.util.script.JSUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import javax.script.Bindings;
import org.eclipse.jface.preference.IPreferenceStore;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class Settings
implements com.deltawalker.script.Settings {
    private final UUID docId;
    private final PageSettings page;
    private IPreferenceStore prefs;
    private final PrinterSettings printer;

    public Settings(IPreferenceStore iPreferenceStore, UUID uUID, PrinterSettings printerSettings, PageSettings pageSettings) {
        this.prefs = iPreferenceStore;
        this.docId = uUID;
        this.printer = printerSettings;
        this.page = pageSettings;
    }

    @Override
    public Filters filters(Comparison.Type type) {
        if (type == null && this.docId == null) {
            throw new NullPointerException("'type' cannot be null");
        }
        IFilterBoss iFilterBoss = App.instance().filterBoss();
        IDocBoss iDocBoss = App.instance().docBoss();
        if (this.docId == null) {
            return iFilterBoss.getDefaultFilters(DocType.fromScript(type));
        }
        IFilters iFilters = iFilterBoss.getSessionFilters(iDocBoss.get(this.docId).getFiltersId());
        iFilters.setDocId(this.docId);
        return iFilters;
    }

    @Override
    public Object get(SettingKey settingKey) {
        if (settingKey == null) {
            throw new NullPointerException("key");
        }
        PrefKey prefKey = PrefKey.fromScript(settingKey);
        Class<?> clazz = prefKey.type();
        String string = prefKey.toString();
        if (clazz == Boolean.TYPE) {
            return this.prefs().getBoolean(string);
        }
        if (clazz == Integer.TYPE) {
            return this.prefs().getInt(string);
        }
        if (clazz == Long.TYPE) {
            return this.prefs().getLong(string);
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(this.prefs().getFloat(string));
        }
        if (clazz == Double.TYPE) {
            return this.prefs().getDouble(string);
        }
        throw new IllegalArgumentException("key");
    }

    @Override
    public PageSettings getPage() throws NotImplementedException {
        if (this.page != null) {
            return this.page;
        }
        throw new NotImplementedException();
    }

    @Override
    public PrinterSettings getPrinter() throws NotImplementedException {
        if (this.printer != null) {
            return this.printer;
        }
        throw new NotImplementedException();
    }

    @Override
    public void load(String string) {
        App.instance().stateBoss().loadState(new File(string), null);
    }

    private IPreferenceStore prefs() {
        if (this.prefs == null) {
            this.prefs = App.instance().docBoss().get(this.docId).preferences();
        }
        return this.prefs;
    }

    @Override
    public void save(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("'pathname' cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'pathname' cannot be an empty string.");
        }
        ((StateBoss)App.instance().stateBoss()).saveStateImpl(new File(string), false);
    }

    @Override
    public void set(SettingKey settingKey, Object object) {
        if (settingKey == null) {
            throw new NullPointerException("'key' cannot be null.");
        }
        if (object == null) {
            throw new NullPointerException("'value' cannot be null.");
        }
        if (object.toString().isEmpty()) {
            throw new IllegalArgumentException("'value' cannot be empty.");
        }
        this.prefs();
        PrefKey prefKey = PrefKey.fromScript(settingKey);
        Class<?> clazz = prefKey.type();
        String string = prefKey.toJson();
        if (clazz == Integer.TYPE) {
            Integer n = 0;
            boolean bl = object instanceof Bindings;
            if (bl || object instanceof Comparison.Method) {
                Object object2;
                Object object3;
                if (bl) {
                    object3 = JSUtil.jsArrayToJavaArray((Object)object);
                    if (object3 != null && ((Object[])object3).length > 0 && object3[0] instanceof Comparison.Method) {
                        Object object4 = object3;
                        int n2 = ((Object[])object3).length;
                        int n3 = 0;
                        while (n3 < n2) {
                            object2 = object4[n3];
                            n = n | ((Comparison.Method)((Object)object2)).toInt();
                            ++n3;
                        }
                    }
                } else if (object instanceof Comparison.Method) {
                    n = n | ((Comparison.Method)((Object)object)).toInt();
                }
                if (settingKey == SettingKey.D_COMP_METHOD) {
                    object3 = DiffMethodUtil.fromInt(n);
                    object2 = DiffMethodUtil.isContent((Set<Comparison.Method>)object3);
                    this.prefs.putValue(PrefKey.fromScript(SettingKey.D_COMP_BY_CONTENT).toJson(), ((Boolean)object2).toString());
                }
            } else {
                n = (int)((Double)object).doubleValue();
            }
            this.prefs.putValue(string, n.toString());
        } else {
            this.prefs.putValue(string, object.toString());
        }
    }

    public void showWindow(boolean bl) {
        throw new NotImplementedException();
    }
}

