/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.App;
import com.deltawalker.interfaces.IPrintBoss;
import com.deltawalker.script.DuplexMode;
import com.deltawalker.script.PrintScope;
import com.deltopia.util.OS;
import java.util.LinkedList;
import org.eclipse.swt.printing.PrinterData;

public class PrinterSettings
implements com.deltawalker.script.PrinterSettings {
    IPrintBoss printBoss = App.instance().printBoss();

    @Override
    public boolean getCollate() {
        return this.printBoss.getPrinterData((boolean)false).collate;
    }

    @Override
    public int getCopyCount() {
        return this.printBoss.getPrinterData((boolean)false).copyCount;
    }

    @Override
    public DuplexMode getDuplexMode() {
        DuplexMode duplexMode;
        switch (this.printBoss.getPrinterData((boolean)false).duplex) {
            case -1: {
                duplexMode = DuplexMode.DEFAULT;
                break;
            }
            case 0: {
                duplexMode = DuplexMode.NONE;
                break;
            }
            case 1: {
                duplexMode = DuplexMode.LONG_EDGE;
                break;
            }
            case 2: {
                duplexMode = DuplexMode.SHORT_EDGE;
                break;
            }
            default: {
                assert (false);
                duplexMode = DuplexMode.DEFAULT;
            }
        }
        return duplexMode;
    }

    @Override
    public int getEndPage() {
        return this.printBoss.getPrinterData((boolean)false).endPage;
    }

    @Override
    public String getFilePath() {
        return this.printBoss.getPrinterData((boolean)false).fileName;
    }

    @Override
    public String[] getInstalledPrinters() {
        PrinterData[] printerDataArray = this.printBoss.printers();
        LinkedList<String> linkedList = new LinkedList<String>();
        PrinterData[] printerDataArray2 = printerDataArray;
        int n = printerDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrinterData printerData = printerDataArray2[n2];
            linkedList.add(printerData.name);
            ++n2;
        }
        return linkedList.toArray(new String[printerDataArray.length]);
    }

    @Override
    public String getPrinterDriver() {
        return this.printBoss.getPrinterData((boolean)false).driver;
    }

    @Override
    public String getPrinterName() {
        return this.printBoss.getPrinterData((boolean)false).name;
    }

    @Override
    public boolean getPrintToFile() {
        return this.printBoss.getPrinterData((boolean)false).printToFile;
    }

    @Override
    public PrintScope getScope() {
        PrintScope printScope;
        switch (this.printBoss.getPrinterData((boolean)false).scope) {
            case 0: {
                printScope = PrintScope.ALL_PAGES;
                break;
            }
            case 1: {
                printScope = PrintScope.PAGE_RANGE;
                break;
            }
            default: {
                assert (false);
                printScope = PrintScope.ALL_PAGES;
            }
        }
        return printScope;
    }

    @Override
    public int getStartPage() {
        return this.printBoss.getPrinterData((boolean)false).startPage;
    }

    @Override
    public void setCollate(boolean bl) {
        this.printBoss.getPrinterData((boolean)false).collate = bl;
    }

    @Override
    public void setCopyCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("'copyCount' cannot be less than 1.");
        }
        this.printBoss.getPrinterData((boolean)false).copyCount = n;
    }

    @Override
    public void setDuplexMode(DuplexMode duplexMode) {
        int n;
        if (duplexMode == null) {
            throw new NullPointerException("'duplexMode' cannot be null .");
        }
        switch (duplexMode) {
            case DEFAULT: {
                n = -1;
                break;
            }
            case NONE: {
                n = 0;
                break;
            }
            case LONG_EDGE: {
                n = 1;
                break;
            }
            case SHORT_EDGE: {
                n = 2;
                break;
            }
            default: {
                assert (false);
                n = -1;
            }
        }
        this.printBoss.getPrinterData((boolean)false).duplex = n;
    }

    @Override
    public void setEndPage(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Please specify an 'endPage' value larger than 1.");
        }
        this.printBoss.getPrinterData((boolean)false).endPage = n;
    }

    @Override
    public void setFilePath(String string) {
        if (!OS.OSX) {
            throw new UnsupportedOperationException("Printing to a PDF file is only supported on Mac OS X");
        }
        if (string == null) {
            throw new NullPointerException("'path' cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'path' cannot be empty.");
        }
        this.printBoss.getPrinterData((boolean)false).fileName = string;
    }

    @Override
    public void setPrinterDriver(String string) {
        if (string == null) {
            throw new NullPointerException("'driver' cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'driver' cannot be empty.");
        }
        this.printBoss.getPrinterData((boolean)false).driver = string;
    }

    @Override
    public void setPrinterName(String string) {
        if (string == null) {
            throw new NullPointerException("'name' cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("'name' cannot be empty.");
        }
        this.printBoss.getPrinterData((boolean)false).name = string;
    }

    @Override
    public void setPrintToFile(boolean bl) {
        if (!OS.OSX) {
            throw new UnsupportedOperationException("Printing to a PDF file is only available on Mac OS X");
        }
        this.printBoss.getPrinterData((boolean)false).printToFile = bl;
    }

    @Override
    public void setScope(PrintScope printScope) {
        int n;
        if (printScope == null) {
            throw new NullPointerException("'scope' cannot be null.");
        }
        switch (printScope) {
            case ALL_PAGES: {
                n = 0;
                break;
            }
            case PAGE_RANGE: {
                n = 1;
                break;
            }
            default: {
                assert (false);
                n = 0;
            }
        }
        this.printBoss.getPrinterData((boolean)false).scope = n;
    }

    @Override
    public void setStartPage(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("'startPage' must be equal or larger than 1.");
        }
        this.printBoss.getPrinterData((boolean)false).startPage = n;
    }
}

