/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.internal.script.Settings;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.commands.common.EventManager;

public class HistoryEntry
extends EventManager
implements com.deltawalker.script.HistoryEntry {
    private static IApp app = App.instance();
    boolean async;
    private UUID docId;
    private com.deltawalker.script.Settings settings;

    public HistoryEntry(UUID uUID) {
        this.docId = uUID;
        this.settings = new Settings(null, uUID, null, null);
    }

    protected IDiffDoc deltaDoc() {
        return app.docBoss().get(this.docId);
    }

    protected IDiffModel deltaModel() {
        return this.deltaDoc().diffModel(0);
    }

    public DiffView deltaView() {
        final DiffView[] diffViewArray = new DiffView[1];
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                List<DiffView> list = app.viewBoss().viewsOnDoc(HistoryEntry.this.deltaDoc().getId());
                diffViewArray[0] = !list.isEmpty() ? list.get(0) : null;
            }
        });
        return diffViewArray[0];
    }

    public UUID getId() {
        return this.docId;
    }

    public void setId(UUID uUID) {
        this.docId = uUID;
    }

    @Override
    public final long getCreationTime() {
        return this.deltaDoc().getTimeCreated();
    }

    @Override
    public final String getDisplayCreationTime() {
        return this.deltaDoc().displayCreationTime();
    }

    @Override
    public final String getName() {
        return this.deltaDoc().getName();
    }

    @Override
    public String[] getPaths() {
        com.deltawalker.script.UriInfo[] uriInfoArray = this.getUriInfos();
        String[] stringArray = new String[uriInfoArray.length];
        int n = 0;
        while (n < uriInfoArray.length) {
            stringArray[n] = uriInfoArray[n].getUri();
            ++n;
        }
        return stringArray;
    }

    @Override
    public final Role[] getRoles() {
        Set<Role> set = this.deltaDoc().roles();
        return this.deltaDoc().roles().toArray(new Role[set.size()]);
    }

    @Override
    public final com.deltawalker.script.Settings getSettings() {
        return this.settings;
    }

    @Override
    public final Comparison.Type getType() {
        DocType docType = this.deltaDoc().docType(0);
        switch (docType) {
            case FOLDER: {
                return Comparison.Type.FOLDER;
            }
            case IMAGE: {
                return Comparison.Type.IMAGE;
            }
        }
        return Comparison.Type.TEXT;
    }

    @Override
    public com.deltawalker.script.UriInfo[] getUriInfos() {
        IDiffDoc iDiffDoc = this.deltaDoc();
        Map<Role, UriInfo> map = iDiffDoc.uriInfos();
        Set<Role> set = iDiffDoc.roles();
        com.deltawalker.script.UriInfo[] uriInfoArray = new com.deltawalker.script.UriInfo[set.size()];
        for (Role role : set) {
            uriInfoArray[role.toInt()] = UriInfoUtil.toScript(map.get((Object)role));
        }
        return uriInfoArray;
    }

    @Override
    public final void setName(String string) {
        this.deltaDoc().setName(string);
    }

    public String toString() {
        return this.deltaDoc().toString();
    }
}

