/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.internal.reports.Linked;
import com.deltawalker.internal.script.Comparison;
import com.deltawalker.internal.script.SyncProgressMonitor;
import com.deltawalker.script.ComparisonListener;
import com.deltawalker.script.DeltaNode;
import com.deltawalker.script.PatchFormat;
import com.deltawalker.script.ReportKind;
import com.deltawalker.script.ReportLink;
import com.deltawalker.script.Role;
import com.deltawalker.script.SortBy;
import com.deltawalker.script.SortDirection;
import com.deltawalker.script.SyncOp;
import com.deltawalker.script.SyncProgressListener;
import com.deltawalker.ui.actions.CreateReportJsonAction;
import com.deltawalker.ui.actions.ReportAction;
import com.deltopia.io.TextEncoding;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class FolderComparison
extends Comparison
implements com.deltawalker.script.FolderComparison {
    public FolderComparison(UUID uUID, ComparisonListener comparisonListener) {
        super(uUID, comparisonListener);
    }

    private Set<IDiffNode> arrayToSet(DeltaNode[] deltaNodeArray) {
        LinkedHashSet<IDiffNode> linkedHashSet = null;
        if (deltaNodeArray != null) {
            linkedHashSet = new LinkedHashSet<IDiffNode>();
            DeltaNode[] deltaNodeArray2 = deltaNodeArray;
            int n = deltaNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DeltaNode deltaNode = deltaNodeArray2[n2];
                if (deltaNode != null) {
                    linkedHashSet.add((IDiffNode)deltaNode);
                }
                ++n2;
            }
        }
        return linkedHashSet;
    }

    @Override
    public void deleteResource(DeltaNode[] deltaNodeArray, Role[] roleArray, SyncProgressListener syncProgressListener) throws IOException {
        if (roleArray == null) {
            throw new NullPointerException("'roles' cannot be null.");
        }
        if (roleArray.length == 0) {
            throw new IllegalArgumentException("'roles' cannot be empty.");
        }
        if (deltaNodeArray == null) {
            throw new NullPointerException("'deltas' cannot be null.");
        }
        if (deltaNodeArray.length == 0) {
            throw new IllegalArgumentException("'deltas' cannot be empty.");
        }
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>(Arrays.asList(roleArray));
        if (!this.deltaDoc().roles().containsAll(linkedHashSet)) {
            String string = "Role.TWO is not a valid role for this comparison.";
            throw new IllegalArgumentException(string);
        }
        Set<IDiffNode> set = this.arrayToSet(deltaNodeArray);
        IStructDiffModel iStructDiffModel = this.deltaModel();
        iStructDiffModel.delete(set, linkedHashSet, new SyncProgressMonitor(syncProgressListener), null);
    }

    @Override
    protected IStructDiffModel deltaModel() {
        return (IStructDiffModel)super.deltaModel();
    }

    @Override
    public DeltaNode[] getAllDeltas() {
        List<IDiffNode> list = this.deltaModel().getAllDeltas();
        return list.toArray(new DeltaNode[list.size()]);
    }

    @Override
    public int getDeltaCount() {
        return this.deltaModel().getAllDeltas().size();
    }

    @Override
    public DeltaNode getRootDelta() {
        return this.deltaModel().getRoot();
    }

    public DeltaNode[] getSelectedNodes() {
        List<IDiffNode> list = this.deltaModel().getSelected();
        return list.toArray(new DeltaNode[list.size()]);
    }

    @Override
    public boolean hasDifferences() {
        return !this.getRootDelta().isSame();
    }

    @Override
    public void recompare(DeltaNode[] deltaNodeArray) throws NullPointerException {
        if (deltaNodeArray == null) {
            throw new NullPointerException("nodes");
        }
        if (deltaNodeArray.length == 0) {
            return;
        }
        IStructDiffModel iStructDiffModel = this.deltaModel();
        LinkedHashSet<IDiffNode> linkedHashSet = new LinkedHashSet<IDiffNode>();
        linkedHashSet.addAll(Arrays.asList((IDiffNode[])deltaNodeArray));
        iStructDiffModel.recompare(linkedHashSet, true);
    }

    @Override
    public void report(String string, ReportKind reportKind, PatchFormat patchFormat, Role[] roleArray) {
        if (string == null) {
            throw new NullPointerException("'pathname' cannot be null");
        }
        if (string.isEmpty()) {
            throw new NullPointerException("'pathname' cannot be empty");
        }
        this.reportEx(new com.deltawalker.script.UriInfo(string), reportKind, patchFormat, null, roleArray);
    }

    @Override
    public void reportEx(com.deltawalker.script.UriInfo uriInfo, ReportKind reportKind, PatchFormat patchFormat, ReportLink reportLink, Role[] roleArray) {
        if (uriInfo == null) {
            throw new NullPointerException("'uriInfo' cannot be null");
        }
        UriInfo uriInfo2 = UriInfoUtil.fromScript(uriInfo);
        if (uriInfo2.isEmpty()) {
            throw new NullPointerException("'uriInfo' cannot be empty");
        }
        if (reportKind == null) {
            throw new NullPointerException("'kind' cannot be null");
        }
        if (reportKind == ReportKind.PATCH && patchFormat == null) {
            throw new NullPointerException("'format' cannot be null");
        }
        if (reportKind == ReportKind.JSON && roleArray == null) {
            throw new NullPointerException("'roles' cannot be null");
        }
        if (reportKind == ReportKind.JSON && roleArray.length == 0) {
            throw new NullPointerException("'roles' cannot be empty");
        }
        if (uriInfo2.textEncoding() == null) {
            uriInfo2 = uriInfo2.cloneUpdateEncoding(TextEncoding.getDefault());
        }
        switch (reportKind) {
            case HTML: {
                Linked linked = reportLink != null ? Linked.fromScript(reportLink) : null;
                ReportAction reportAction = (ReportAction)this.deltaView().controller().getAction("createReportHtml");
                reportAction.report(uriInfo2.uri(), uriInfo2.textEncoding(), uriInfo2.lineEnding(), linked);
                this.waitTillDone();
                break;
            }
            case JSON: {
                CreateReportJsonAction createReportJsonAction = (CreateReportJsonAction)this.deltaView().controller().getAction("createReportJson");
                createReportJsonAction.createAndSave(uriInfo2.uri(), Relation.roleArrayToSet(roleArray));
                this.waitTillDone();
                break;
            }
            case PATCH: {
                System.err.println("Not yet implemented");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void sort(Role role, SortBy sortBy, SortDirection sortDirection) {
        this.deltaModel().sort(role, sortBy, sortDirection);
    }

    @Override
    public void sync(SyncOp syncOp, DeltaNode[] deltaNodeArray, Role role, Role role2, SyncProgressListener syncProgressListener) throws IOException {
        if (syncOp == null) {
            throw new NullPointerException("syncOp");
        }
        if (deltaNodeArray == null) {
            throw new NullPointerException("'nodes' cannot be null.");
        }
        if (deltaNodeArray.length == 0) {
            return;
        }
        if (role2 == null) {
            throw new NullPointerException("'dst' cannot be null.");
        }
        if (role == role2) {
            throw new IllegalArgumentException("Role." + (Object)((Object)role) + " cannot be both a source and a destination.");
        }
        if (!this.isThreeWay()) {
            if (role == Role.TWO || role2 == Role.TWO) {
                throw new IllegalArgumentException("There's no 'Role.TWO' in a two-way comparison.");
            }
            if (syncOp == SyncOp.SYNC) {
                throw new IllegalArgumentException("'SyncOp.SYNC' is only applicable to three-way comparisons.");
            }
        }
        IStructDiffModel iStructDiffModel = this.deltaModel();
        Set<IDiffNode> set = this.arrayToSet(deltaNodeArray);
        iStructDiffModel.synchronize(syncOp, set, role, role2, new SyncProgressMonitor(syncProgressListener));
        this.waitTillDone();
    }
}

