/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.internal.script.Comparison;
import com.deltawalker.internal.script.FolderComparison;
import com.deltawalker.internal.script.HistoryEntry;
import com.deltawalker.internal.script.ImageComparison;
import com.deltawalker.internal.script.TextComparison;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.ComparisonListener;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.OpenReportJsonAction;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class Comparisons
implements com.deltawalker.script.Comparisons {
    private static IApp app = App.instance();
    private static IDocBoss docBoss = App.instance().docBoss();
    List<com.deltawalker.script.HistoryEntry> history;

    public static Map<Role, UriInfo> toInternalUriInfos(com.deltawalker.script.UriInfo[] uriInfoArray) {
        EnumMap<Role, UriInfo> enumMap = new EnumMap<Role, UriInfo>(Role.class);
        int n = uriInfoArray[2] == null ? 2 : 3;
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 - n3;
            com.deltawalker.script.UriInfo uriInfo = uriInfoArray[n4];
            if (n4 >= 0 && uriInfo != null) {
                Role role = Relation.argToRole(n3, n);
                enumMap.put(role, UriInfoUtil.fromScript(uriInfo));
            }
            ++n3;
        }
        return enumMap;
    }

    @Override
    public com.deltawalker.script.Comparison create(Comparison.Type type, String[] stringArray, ComparisonListener comparisonListener) {
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        com.deltawalker.script.UriInfo[] uriInfoArray = null;
        if (stringArray != null && stringArray.length > Role.count()) {
            throw new IllegalArgumentException("The number of 'paths' cannot exceed 3.");
        }
        if (stringArray != null) {
            uriInfoArray = new com.deltawalker.script.UriInfo[Role.count()];
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                uriInfoArray[n2] = new com.deltawalker.script.UriInfo(stringArray[n2]);
                ++n2;
            }
        }
        return this.createEx(type, uriInfoArray, comparisonListener);
    }

    private com.deltawalker.script.Comparison createComparison(IDiffDoc iDiffDoc, ComparisonListener comparisonListener) {
        com.deltawalker.script.Comparison comparison = (com.deltawalker.script.Comparison)iDiffDoc.getHistoryEntry();
        if (comparison != null) {
            if (comparisonListener != null) {
                ((Comparison)comparison).setComparisonListener(comparisonListener);
            }
            return comparison;
        }
        DocType docType = iDiffDoc.docType(0);
        switch (docType) {
            case FOLDER: {
                comparison = new FolderComparison(iDiffDoc.getId(), comparisonListener);
                break;
            }
            case IMAGE: {
                comparison = new ImageComparison(iDiffDoc.getId(), comparisonListener);
                break;
            }
            case TEXT: {
                comparison = new TextComparison(iDiffDoc.getId(), comparisonListener);
                break;
            }
            default: {
                comparison = new TextComparison(iDiffDoc.getId(), comparisonListener);
            }
        }
        iDiffDoc.setHistoryEntry(comparison);
        return comparison;
    }

    private com.deltawalker.script.Comparison createComparison(final Map<Role, UriInfo> map, final DocType docType, final ComparisonListener comparisonListener) {
        final com.deltawalker.script.Comparison[] comparisonArray = new com.deltawalker.script.Comparison[1];
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                DiffView diffView = docType == DocType.FOLDER ? app.viewBoss().showCompareView(null, null) : app.viewBoss().openCompareEditor(docType.contentType());
                IDiffDoc iDiffDoc = diffView.getInput();
                if (map != null) {
                    UriInfoUtil.makeUriInfosSafe(map, null);
                    diffView.uriChooserBoss().updateUriInfo(map);
                }
                comparisonArray[0] = Comparisons.this.createComparison(iDiffDoc, comparisonListener);
            }
        });
        return comparisonArray[0];
    }

    @Override
    public com.deltawalker.script.Comparison createEx(Comparison.Type type, com.deltawalker.script.UriInfo[] uriInfoArray, ComparisonListener comparisonListener) {
        Map<Role, UriInfo> map = null;
        if (uriInfoArray != null && uriInfoArray.length > 0) {
            com.deltawalker.script.UriInfo[] uriInfoArray2 = new com.deltawalker.script.UriInfo[Role.count()];
            System.arraycopy(uriInfoArray, 0, uriInfoArray2, 0, Math.min(uriInfoArray.length, Role.count()));
            map = Comparisons.toInternalUriInfos(uriInfoArray2);
        }
        return this.createComparison(map, DocType.fromScript(type), comparisonListener);
    }

    @Override
    public com.deltawalker.script.Comparison createFromHistory(Object object, ComparisonListener comparisonListener) {
        if (object == null) {
            throw new NullPointerException("'id' cannot be null");
        }
        if (object instanceof String && ((String)object).isEmpty()) {
            throw new IllegalArgumentException("'id' cannot be empty");
        }
        com.deltawalker.script.Comparison comparison = this.get(object, comparisonListener);
        return comparison;
    }

    @Override
    public com.deltawalker.script.Comparison createFromReport(String string, ComparisonListener comparisonListener) {
        IDiffDoc iDiffDoc = OpenReportJsonAction.open(string);
        return iDiffDoc != null ? (com.deltawalker.script.Comparison)iDiffDoc.getHistoryEntry() : null;
    }

    private com.deltawalker.script.HistoryEntry createHistoryRecord(IDiffDoc iDiffDoc) {
        com.deltawalker.script.HistoryEntry historyEntry = iDiffDoc.getHistoryEntry();
        if (historyEntry != null) {
            return historyEntry;
        }
        DocType docType = iDiffDoc.docType(0);
        switch (docType) {
            case FOLDER: {
                historyEntry = new HistoryEntry(iDiffDoc.getId());
                break;
            }
            case IMAGE: {
                historyEntry = new HistoryEntry(iDiffDoc.getId());
                break;
            }
            default: {
                historyEntry = new HistoryEntry(iDiffDoc.getId());
            }
        }
        iDiffDoc.setHistoryEntry(historyEntry);
        return historyEntry;
    }

    @Override
    public com.deltawalker.script.Comparison get(Object object) {
        if (object == null) {
            throw new NullPointerException("'id' cannot be null");
        }
        if (object instanceof String && ((String)object).isEmpty()) {
            throw new IllegalArgumentException("'id' cannot be empty");
        }
        return this.get(object, null);
    }

    private com.deltawalker.script.Comparison get(Object object, ComparisonListener comparisonListener) {
        IDiffDoc iDiffDoc = docBoss.get(object);
        if (iDiffDoc == null) {
            return null;
        }
        return iDiffDoc != null ? this.createComparison(iDiffDoc.uriInfos(), iDiffDoc.docType(0), comparisonListener) : null;
    }

    @Override
    public com.deltawalker.script.Comparison[] getAll() {
        List<IDiffDoc> list = docBoss.getAll();
        ArrayList<com.deltawalker.script.Comparison> arrayList = new ArrayList<com.deltawalker.script.Comparison>(list.size());
        for (IDiffDoc iDiffDoc : list) {
            if (!iDiffDoc.getHasOpenView()) continue;
            com.deltawalker.script.Comparison comparison = (com.deltawalker.script.Comparison)iDiffDoc.getHistoryEntry();
            if (comparison == null) {
                comparison = this.createComparison(iDiffDoc, null);
                iDiffDoc.setHistoryEntry(comparison);
            }
            arrayList.add(comparison);
        }
        return arrayList.toArray(new com.deltawalker.script.Comparison[arrayList.size()]);
    }

    @Override
    public int getCount() {
        return docBoss.getTotalCount();
    }

    @Override
    public com.deltawalker.script.HistoryEntry[] getHistory() {
        List<IDiffDoc> list = docBoss.getAll();
        ArrayList<com.deltawalker.script.HistoryEntry> arrayList = new ArrayList<com.deltawalker.script.HistoryEntry>(list.size());
        for (IDiffDoc iDiffDoc : list) {
            com.deltawalker.script.HistoryEntry historyEntry = iDiffDoc.getHistoryEntry();
            if (historyEntry == null) {
                historyEntry = this.createHistoryRecord(iDiffDoc);
                iDiffDoc.setHistoryEntry(historyEntry);
            }
            arrayList.add(historyEntry);
        }
        return arrayList.toArray(new com.deltawalker.script.HistoryEntry[arrayList.size()]);
    }

    @Override
    public boolean removeFromHistory(Object object) {
        if (object == null) {
            throw new NullPointerException("'id' cannot be null");
        }
        if (object instanceof String && ((String)object).isEmpty()) {
            throw new IllegalArgumentException("'id' cannot be empty");
        }
        IDiffDoc iDiffDoc = docBoss.get(object);
        if (iDiffDoc == null) {
            return false;
        }
        return docBoss.remove(iDiffDoc);
    }
}

