/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.App;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.internal.script.HistoryEntry;
import com.deltawalker.script.ComparisonEvent;
import com.deltawalker.script.ComparisonListener;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.StatusLineProgressMonitor;
import com.deltawalker.ui.printing.IPrintable;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public abstract class Comparison
extends HistoryEntry
implements com.deltawalker.interfaces.Comparison {
    private static final IApp app = App.instance();
    private boolean async;
    private boolean done = false;

    public Comparison(UUID uUID, ComparisonListener comparisonListener) {
        super(uUID);
        if (comparisonListener != null) {
            this.addListenerObject(comparisonListener);
            this.async = true;
        } else {
            this.async = false;
        }
    }

    @Override
    public void addListener(ComparisonListener comparisonListener) {
        if (comparisonListener == null) {
            throw new NullPointerException("'listener' cannot be 'null'");
        }
        this.addListenerObject(comparisonListener);
    }

    @Override
    public void close() {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                DiffView diffView = Comparison.this.deltaView();
                IWorkbenchPart iWorkbenchPart = diffView.getPart();
                if (iWorkbenchPart instanceof IEditorPart) {
                    diffView.getEditorSite().getPage().closeEditor((IEditorPart)iWorkbenchPart, false);
                } else if (iWorkbenchPart instanceof IViewPart) {
                    diffView.getSite().getPage().hideView((IViewPart)iWorkbenchPart);
                }
            }
        });
    }

    @Override
    public void compare() throws IOException {
        final DiffView diffView = this.deltaView();
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                app.viewBoss().viewDoc(diffView, true, null, null, false, true);
            }
        });
        this.waitTillDone();
    }

    @Override
    protected IDiffDoc deltaDoc() {
        IDocBoss iDocBoss = app.docBoss();
        if (iDocBoss == null) {
            throw new IllegalStateException("Null docBoss");
        }
        UUID uUID = this.getId();
        if (uUID == null) {
            throw new IllegalStateException("Null docId");
        }
        IDiffDoc iDiffDoc = iDocBoss.get(uUID);
        if (iDiffDoc == null) {
            throw new IllegalStateException("Cannot find doc with UID=" + uUID + " in docs:" + iDocBoss);
        }
        return iDiffDoc;
    }

    @Override
    protected IDiffModel deltaModel() {
        return this.deltaDoc().diffModel(0);
    }

    @Override
    public DiffView deltaView() {
        final DiffView[] diffViewArray = new DiffView[1];
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                List<DiffView> list = app.viewBoss().viewsOnDoc(Comparison.this.getId());
                diffViewArray[0] = !list.isEmpty() ? list.get(0) : null;
            }
        });
        return diffViewArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        this.done = true;
        Comparison comparison = this;
        synchronized (comparison) {
            this.notifyAll();
        }
    }

    public void fireComparisonChanged(ComparisonEvent comparisonEvent) {
        List<ComparisonListener> list = this.getComparisonListeners();
        for (ComparisonListener comparisonListener : list) {
            comparisonListener.comparisonChanged(comparisonEvent);
        }
    }

    private List<ComparisonListener> getComparisonListeners() {
        Object[] objectArray;
        LinkedList<ComparisonListener> linkedList = new LinkedList<ComparisonListener>();
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof ComparisonListener) {
                linkedList.add((ComparisonListener)object);
            }
            ++n2;
        }
        return linkedList;
    }

    public boolean isThreeWay() {
        return this.deltaDoc().isThreeWay();
    }

    public boolean isWorking() {
        return this.deltaDoc().isWorking();
    }

    @Override
    public void print() {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                DiffView diffView = Comparison.this.deltaView();
                if (diffView == null) {
                    throw new IllegalStateException("No delta view");
                }
                app.printBoss().print((IPrintable)((Object)diffView), StatusLineProgressMonitor.createInstance(diffView), false);
            }
        });
        this.waitTillDone();
    }

    public void printPreview() {
        DiffView diffView = this.deltaView();
        DiffController diffController = diffView.controller();
        App.instance().printBoss().printPreview((IPrintable)((Object)diffView), diffController.getAction(ActionFactory.PRINT.getId()), diffController.getAction("pageSetup"));
    }

    @Override
    public void removeListener(ComparisonListener comparisonListener) {
        if (comparisonListener == null) {
            throw new NullPointerException("'listener' cannot be 'null'");
        }
        this.removeListenerObject(comparisonListener);
    }

    protected void setComparisonListener(ComparisonListener comparisonListener) {
        if (comparisonListener == null) {
            throw new NullPointerException("'listener' cannot be 'null'");
        }
        this.addListenerObject(comparisonListener);
        this.async = true;
    }

    @Override
    public String toString() {
        return this.deltaDoc().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitTillDone() {
        if (this.async) {
            return;
        }
        Comparison comparison = this;
        synchronized (comparison) {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
        }
    }
}

