/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.script;

import com.deltawalker.AddonInfo;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.internal.script.Comparisons;
import com.deltawalker.internal.script.PageSettings;
import com.deltawalker.internal.script.PrinterSettings;
import com.deltawalker.internal.script.Settings;
import com.deltawalker.internal.script.Window;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.ComparisonEvent;
import com.deltawalker.script.ComparisonListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
extends EventManager
implements com.deltawalker.script.App {
    private static final Logger _LOG = LoggerFactory.getLogger(App.class);
    private static App INSTANCE = new App();
    public static final String PROP_SAMPLES = "dw.samples";
    private com.deltawalker.script.Comparisons comparisons = new Comparisons();
    private IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            App.this.fireSettingChanged(propertyChangeEvent, null);
        }
    };
    private com.deltawalker.script.Settings settings;
    private com.deltawalker.script.Window window;

    private static final void initAppProperties() {
        if (System.getProperty(PROP_SAMPLES) == null) {
            String string = System.getProperty("user.dir");
            File file = new File(string, "com.deltawalker.feature.application/rootfiles/samples");
            if (!file.exists() && !(file = new File(string, "samples")).exists()) {
                _LOG.warn("No 'samples' folder in: " + string);
            }
            System.setProperty(PROP_SAMPLES, file.getAbsolutePath());
        }
    }

    public static App instance() {
        return INSTANCE;
    }

    private App() {
        IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
        iPreferenceStore.addPropertyChangeListener(this.onProp);
        this.settings = new Settings(iPreferenceStore, null, new PrinterSettings(), new PageSettings());
        this.window = new Window();
        App.initAppProperties();
    }

    @Override
    public void addListener(ComparisonListener comparisonListener) {
        this.addListenerObject(comparisonListener);
    }

    public void fireSettingChanged(PropertyChangeEvent propertyChangeEvent, Comparison comparison) {
        String string = propertyChangeEvent.getProperty();
        PrefKey prefKey = PrefKey.fromString(string);
        if (prefKey == null) {
            return;
        }
    }

    public void fireStateChanged(ComparisonEvent comparisonEvent) {
        List<ComparisonListener> list = this.getComparisonListeners();
        for (ComparisonListener comparisonListener : list) {
            comparisonListener.comparisonChanged(comparisonEvent);
        }
    }

    private List<ComparisonListener> getComparisonListeners() {
        Object[] objectArray;
        LinkedList<ComparisonListener> linkedList = new LinkedList<ComparisonListener>();
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof ComparisonListener) {
                linkedList.add((ComparisonListener)object);
            }
            ++n2;
        }
        return linkedList;
    }

    @Override
    public com.deltawalker.script.Comparisons getComparisons() {
        return this.comparisons;
    }

    @Override
    public String getEdition() {
        AddonInfo addonInfo = AddonInfoUtil.addonInfo();
        String string = addonInfo.edition().displayName();
        return string;
    }

    @Override
    public String getProperty(String string) {
        return System.getProperty(string);
    }

    @Override
    public com.deltawalker.script.Settings getSettings() {
        return this.settings;
    }

    @Override
    public String getVersion() {
        return com.deltawalker.App.instance().version();
    }

    @Override
    public com.deltawalker.script.Window getWindow() {
        return this.window;
    }

    @Override
    public void removeListener(ComparisonListener comparisonListener) {
        this.removeListenerObject(comparisonListener);
    }
}

